#ifndef SDFX_LPHP_FILTER_H
#define SDFX_LPHP_FILTER_H


#include <math.h>
#include "sdfx.h"

typedef struct SDFX_LPHP_FILTER {
	SDFX_BASE
	float n[SDFX_MAX_CHANNELS][4];
	float fb_lp, fb_hp;
	float cut_lp, res_lp, cut_hp, res_hp;
};


void *sdfx_lphp_filter_create(int channels, float cut_lp, float res_lp, float cut_hp, float res_hp);
void sdfx_lphp_filter_process_mixing(void *self, float *src, float *dest, int len, int channels, int time);
void sdfx_lphp_filter_process_replacing(void *self, float *src, float *dest, int len, int channels, int time);


#endif