
#include "include.h"
#include <stdlib.h>
#include "font.h"
#include <string.h>

#define FSIZE (1/6.0)

unsigned char *loadJPG(char *path,int *width,int *height);

static GLint font;

void init_font(void)
{
    int x,y,n,sum;
    unsigned char *data,*dada;

    glGenTextures(1,&font);

    glBindTexture(GL_TEXTURE_2D,font);
    data=loadJPG("data/fontsor2smuut.jpg",&x,&y);
    dada=malloc(x*y*4);

    for(n=0;n<x*y;n++)
    {
        dada[n*4]=data[n*3];
        dada[n*4+1]=data[n*3+1];
        dada[n*4+2]=data[n*3+2];
        sum=data[n*3]+data[n*3+1]+data[n*3+2];
        dada[n*4+3]=(sum>180)?240:(sum*sum*sum)/(24300);
    }

    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);

    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	
    
    glTexImage2D(GL_TEXTURE_2D,0, GL_RGBA,x,y,0,GL_RGBA,GL_UNSIGNED_BYTE,dada);

    free(data);
    free(dada);
}

void draw_char(char c)
{
    float   tx,ty;
    int     ch;

    if(c==' ')
        return;

    if(c>='0' && c<='9')
        ch=c-'0'+26;
    else
        ch=c-'a';
    tx=(ch%6)*FSIZE;
    ty=(ch/6)*FSIZE+0.01;

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
    glDisable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);
    glColor3f(1,1,1);
    glBindTexture(GL_TEXTURE_2D,font);
    glBegin(GL_QUADS);
        glTexCoord2f(tx,ty+FSIZE);
        glVertex2f(-0.5,-0.5);
        glTexCoord2f(tx+FSIZE,ty+FSIZE);
        glVertex2f(0.5,-0.5);
        glTexCoord2f(tx+FSIZE,ty);
        glVertex2f(0.5,0.5);
        glTexCoord2f(tx,ty);
        glVertex2f(-0.5,0.5);
    glEnd();
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_BLEND);
}

void draw_string(char *text,float tid)
{
    int i;

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef(-(float)strlen(text)/2.0*0.4+0.2,0,0);
    for(i=0;text[i];i++)
    {
        glPushMatrix();
        glRotatef(sin(i*10.0+tid*2.0)*5,0,0,1);
        draw_char(text[i]);
        glPopMatrix();
        glTranslatef(0.4,0,0);
    }
    glPopMatrix();
}
