#include "include.h"
#include "juttu.h"

#define MAX_TRI 128

void juttu(float tim,float flash) {
	int y;
	float dx,dy,dz,dx2,dy2,dz2;

	float tid = tim / 500.0f+100;
	
	float et;
	

	float pit = 0.3f;
/*
	float flash = 1.0f+2.1f+2.0f*sin(tim*5);
	flash = 1.0f;
*/

    glMatrixMode(GL_MODELVIEW);	

    glPushMatrix();
    glDisable(GL_CULL_FACE);
    glEnable(GL_DEPTH_TEST);

	glTranslatef(0,0,-2);
	glRotatef(tim*35.0f,0,1,0);
	glRotatef(tim*25.0f,0,0,1);
	glRotatef(tim*55.0f,1,0,0);

	
	glLineWidth(3);
	for(y = 0; y<MAX_TRI; y++) {
		
		et= 1.4f*((float)y/MAX_TRI);

		glEnable (GL_POLYGON_OFFSET_FILL);
	    glPolygonOffset (1., 1.);
		dx = et * sin(tid*(y+1)*5.0f);
		dy = et * cos(tid*(y+1)*7.0f);
		dz = et * cos(tid*(y+1)*3.0f)*sin(tid*(y+1)*3.0f);

		dx2 = et * sin(tid*(y+1)*5.0f+pit);
		dy2 = et * cos(tid*(y+1)*7.0f+pit);
		dz2 = et * cos(tid*(y+1)*3.0f+pit)*sin(tid*(y+1)*3.0f+pit);


		glColor3f(1*flash,((float)y/MAX_TRI)*flash,0.2f*flash);
		glBegin(GL_TRIANGLES);
		glVertex3f(0.4*dx,0.4*dy,0.4*dz);
		glVertex3f(dx,dy,dz);
		glVertex3f(dx2,dy2,dz2);
		glEnd();
		glColor3f(0.5f*flash,0.5f*((float)y/MAX_TRI)*flash,0.2f*flash);
		glBegin(GL_LINE_STRIP);
		glVertex3f(0.4*dx,0.4*dy,0.4*dz);
		glVertex3f(dx,dy,dz);
		glVertex3f(dx2,dy2,dz2);
		glVertex3f(0.4*dx,0.4*dy,0.4*dz);
		glEnd();


		glDisable (GL_POLYGON_OFFSET_FILL);
		
	}

	glLineWidth(1);

	glDisable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
    glPopMatrix();
    glColor3f(1,1,1);

}

