#include <stdio.h>
#include <stdlib.h>

#include <SDL/SDL.h>
#include "include.h"
#include "tausta.h"
#include "pallot.h"
#include "juttu.h"
#include "font.h"

#include "cool_mzx/cool_mzx.h"

#define MODSIZE 4000000
#define HIT 18
#define KICKBASS 19

#define LASTRIG aikaa_siita_kun_viimeksi_tavattu
extern volatile int aikaa_siita_kun_viimeksi_tavattu[];
extern unsigned int pt_songpos;

/* Didn't bother to write a header... */
void piraali(float);
void piraali2(float);
void stara(float,int,int);
void staroja(float,int,int);
void rays(float,int,float);

void rinkula(float);
float musasynk(int,float);

extern unsigned int pt_songpos;

int main(int argc,char *argv[])
{
    int quit=0,finito=0,n;
    SDL_Event   e;
    long    alku;
    float   tid,prev=0,prev2=0,r,d;
    float vaihto=1.0f,vaihto_tid,dx,dy;
    int hitnum,oldhit;  
    char *swahili[9] = {    
        "simba",
        "duma",
        "twiga",
        "nyati", 
        "ndovu",
        "heroe",
        "nyani",
        "mamba",
        "punda milia"   
    };

    int greetnum=0;
    char *greeted[17] = {    
        "rno",
        "bandwagon",
        "halcyon",
        "exvrc",
        "unique",
        "lievestuore",
        "pode",
        "joija",
        "zenon",
        "tficm",
        "toar",
        "poks", 
        "diu",
        "dau",
        "jou",
        "jee",
        "naps"   
    };
    float grex[17] = {
        0.5,0.4,-0.7,0.5,-0.2,0.6,-0.8,-0.3,0.4,-0.2,0.6,0.8,-0.3,-0.4, 0.3,-0.4,0.7
    };
    
    float grey[17] = {
        -0.5,0.4,0.7,-0.5,0.2,-0.8, -0.3,0.4,-0.3,0.4,-0.6,0.8, 0.3,-0.4,-0.2,-0.6, 0.7
    };
    
    
    static unsigned char moddi[MODSIZE];
    FILE    *fp;

    SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO);
    SDL_SetVideoMode(640,480,32,SDL_OPENGL|SDL_FULLSCREEN|SDL_DOUBLEBUF);
    //SDL_SetVideoMode(640,480,32,SDL_OPENGL);
    SDL_ShowCursor(0);
    SDL_WM_SetCaption("Dr.Fungi goes Africa",0);

#ifndef BLKSIZE
    if(!mzx_init(44100, 4096))
#else
    if(!mzx_init(44100, BLKSIZE))
#endif
    {
        SDL_Quit();
        fprintf(stderr,"MZX failure\n");
        return(EXIT_FAILURE);
    }

    /* Not a very elegant way of reading the file but there's no time... */
    if((fp=fopen("data/afro.mod","rb"))==NULL)
    {
        SDL_Quit();
        fprintf(stderr,"Mod not found\n");
        return(EXIT_FAILURE);
    }
    fread(moddi,1,MODSIZE,fp);
    fclose(fp);
    mzx_get(moddi);

    init_tausta();
    init_font();

    mzx_start(1);
    /* Wait until the song really starts */
    //pt_songpos=1;
    while(mzx_position()<0 || mzx_position()>1500)
        ;

    alku=SDL_GetTicks();
    while(!quit)
    {
        tid=SDL_GetTicks()-alku;
        tid/=1000.0;

        glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        glFrustum(-1.33,1.33, -1,1, 3,1000.0);
        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();
        glTranslatef(0,0,-3);

        /* The beginning texts */
        if(mzx_position()<100)
        {
            d=cos(tid*2)*6/(1+tid*tid);
            glPushMatrix();
            glTranslatef(0,0,-3.5);
            if(mzx_position()>60)
            {
                if(prev==0)
                    prev=tid;
                else
                {
                    glTranslatef(0,0,(tid-prev)*20);
                }
            }
            glPushMatrix();
            glTranslatef(d,0.5,0);
            draw_string("the fiture crew",tid);
            glPopMatrix();
            glTranslatef(-d,-0.5,0);
            draw_string("presente",tid);
            glPopMatrix();
            prev2=tid;
        }

        /* Dr.Fungi gettin' it on */
        if(mzx_position()>=100 && mzx_position()<200)
        {
            d=tid-prev2;
            glTranslatef(0,cos(d*10)*2/(1+d*d*d*d*d),0);
            tausta(tid,9,0);
            glMatrixMode(GL_MODELVIEW);

            d=cos((tid-prev2)*2)*6/(1+(prev2-tid)*(prev2-tid));
            glPushMatrix();
            glTranslatef(0,0,-3);
            glPushMatrix();
            glTranslatef(d,0.5,0);
            draw_string("dr fungi",tid);
            glPopMatrix();
            glTranslatef(-d,-0.5,0);
            draw_string("goes africa",tid);
            glPopMatrix();

            glTranslatef(-0.4,0.4,0);
            d=(prev2-tid)*2+16.5;
            if(d<0)
                d=0;
   
            rinkula(d);
            prev=tid;
        }

        /* sun is shining */
        if(mzx_position()>=200 && mzx_position()<300)
        {
            d=(tid-prev)*2.0f;
            glTranslatef(musasynk(KICKBASS,tid)+musasynk(HIT,tid),0,0);
            
            tausta(tid,10,0);
            
            glTranslatef(-0.8f,0.8f,0);
            glMatrixMode(GL_MODELVIEW);
            glPushMatrix();
            dx = 2.0f+sin(tid*8.0f)*0.3f;
            dy = 2.0f+cos(tid*9.0f)*0.3f;
            glTranslatef(0,0,-5.0f);
            glScalef(dx,dy,dx*dy);
            juttu(tid,1);
            glPopMatrix();

            glMatrixMode(GL_MODELVIEW);
            glPushMatrix();
            dx = 1.0f+sin(tid*8.0f)*0.3f;
            dy = 1.0f+cos(tid*9.0f)*0.3f;
            glTranslatef(0,0,0);
            glScalef(dx,dy,dx*dy);
            glEnable(GL_BLEND);
            glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_COLOR);
            juttu(tid,1);
            glDisable(GL_BLEND);
            glPopMatrix();

            glDisable(GL_DEPTH_TEST);
            glMatrixMode(GL_MODELVIEW);
            glPushMatrix();
            glRotatef(23,0,0,1);
            glTranslatef(17-(tid-prev)*3.5,-2.3,-4);
            draw_string("2 days hard work   let us speak swahili",tid);
            glPopMatrix();
            glEnable(GL_DEPTH_TEST);

            dx = 1.0f+sin(tid*8.0f)*0.3f;
            dy = 1.0f+cos(tid*9.0f)*0.3f;
            glScalef(dx,dy,dx*dy);
            rinkula(d);
            prev2=tid;
        }

        /* swahili animals */
        if(mzx_position()>=300 && mzx_position()<600)
        {
            if(mzx_position()>=300 && mzx_position()<332) { hitnum = 0; oldhit = 10; }
            if(mzx_position()>=332 && mzx_position()<348) { hitnum = 1; oldhit = 0; }
            if(mzx_position()>=348 && mzx_position()<400) { hitnum = 2; oldhit = 1; }
            if(mzx_position()>=400 && mzx_position()<432) { hitnum = 3; oldhit = 2; }
            if(mzx_position()>=432 && mzx_position()<448) { hitnum = 4; oldhit = 3; }
            if(mzx_position()>=448 && mzx_position()<500) { hitnum = 5; oldhit = 4; }
            if(mzx_position()>=500 && mzx_position()<532) { hitnum = 6; oldhit = 5; }
            if(mzx_position()>=532 && mzx_position()<548) { hitnum = 7; oldhit = 6; }
            if(mzx_position()>=548 && mzx_position()<600) { hitnum = 8; oldhit = 7; }

            
            if(LASTRIG[HIT]<4 && vaihto>0.5f)
            {
                vaihto_tid=tid;
            }
    
            vaihto=tid-vaihto_tid;
            vaihto = (1.0f/vaihto)*20.0f;
            if(vaihto>4.0f) vaihto = 4.0f;

            glMatrixMode(GL_MODELVIEW);
            glPushMatrix();
            glTranslatef(0,-0.15f,0);
            tausta(tid,oldhit,0);
            glMatrixMode(GL_MODELVIEW);

            glTranslatef(-(4.0f-vaihto)+musasynk(HIT,tid)*3.0f,0.0f,-0.01f);

            glScalef(0.9,0.9,0.9);
            tausta(tid,hitnum,0);
            glMatrixMode(GL_MODELVIEW);         
            glPopMatrix();
            
            glMatrixMode(GL_MODELVIEW);         
            glPushMatrix();
            d=(tid-prev2);
            if(d>1.0f) d=1.0f;          
            
            d=(tid-vaihto_tid)/0.5f;
            if (d>1.0f) d=1.0f;
            d=1.0f;         
            if(mzx_position()>=300 && mzx_position()<332) { dx = 0.6f; dy = 0.8f; }
            if(mzx_position()>=332 && mzx_position()<348) { dx =-0.9f; dy =-0.7f; }
            if(mzx_position()>=348 && mzx_position()<400) { dx =-0.9f; dy =-0.7f; }
            if(mzx_position()>=400 && mzx_position()<432) { dx =-0.9f; dy = 0.8f; }
            if(mzx_position()>=432 && mzx_position()<448) { dx = 0.6f; dy = 0.8f; }
            if(mzx_position()>=448 && mzx_position()<500) { dx = 0.6f; dy =-0.7f; }
            if(mzx_position()>=500 && mzx_position()<532) { dx = 0.6f; dy =-0.7f; }
            if(mzx_position()>=532 && mzx_position()<548) { dx = 0.6f; dy = 0.8f; }
            if(mzx_position()>=548 && mzx_position()<600) { dx =-1.2f; dy =-0.7f; }

            
            glTranslatef(dx,dy,0.0f);
            
            d=(tid-vaihto_tid)/0.5f;
            if (d>1.0f) d=1.0f;
            //glScalef(1.0f/(d*3.0f),1.0f/(d*3.0f),1.0f/(d*3.0f));
            glScalef(musasynk(HIT,tid)+0.3f,musasynk(HIT,tid)+0.3f,musasynk(HIT,tid)+0.3f);

            d=(tid-prev2);
            if(d>1.0f) d=1.0f;          
            d=2.0f-d;
            if(d<1.0f) d=1.0f;
            juttu(tid,d+musasynk(HIT,tid));

            glMatrixMode(GL_MODELVIEW);
            glPopMatrix();


            glMatrixMode(GL_MODELVIEW);         
            glPushMatrix();
            glScalef(0.5,0.5,0.5);
            glTranslatef(0,0,-1);
            if(mzx_position()>=300 && mzx_position()<332) { glTranslatef( 2.0, 1.5,0); }
            if(mzx_position()>=332 && mzx_position()<348) { glTranslatef(-1.0,-1.5,0); }
            if(mzx_position()>=348 && mzx_position()<400) { glTranslatef(-1.0,-1.5,0); }
            if(mzx_position()>=400 && mzx_position()<432) { glTranslatef(-1.0, 1.5,0); }
            if(mzx_position()>=432 && mzx_position()<448) { glTranslatef( 2.0, 1.5,0); }
            if(mzx_position()>=448 && mzx_position()<500) { glTranslatef( 2.0,-1.5,0); }
            if(mzx_position()>=500 && mzx_position()<532) { glTranslatef( 2.0,-1.5,0); }
            if(mzx_position()>=532 && mzx_position()<548) { glTranslatef( 2.0, 1.5,0); }
            if(mzx_position()>=548 && mzx_position()<600) { glTranslatef(-0.5,-1.5,0); }

            draw_string(swahili[hitnum],tid);
            glPopMatrix();
            prev = tid;
        }

        /* Effects on effects */
        if(mzx_position()>=600 && mzx_position()<900)
        {
            tausta(tid,2,0);
            glMatrixMode(GL_MODELVIEW);

            glPushMatrix();
            /*d=fmod(tid*5,4.0)-2.0;
            d=4.0-2.0*d*d;
            glTranslatef(0,d,sin(tid)*10.0-10.0);
            staroja(tid,7,1);*/
            rays(tid,10,0.2);
            glClear(GL_DEPTH_BUFFER_BIT);
            glPopMatrix();

            glPushMatrix();
            d=tid-prev;
            glTranslatef(cos(d/2)*50/(1+d*d),0,0);
            glTranslatef(0,0,-2);

            if(mzx_position()/100!=8)
            {
                glPushMatrix();
                if(mzx_position()%100/16&1)
                    piraali(tid*1.2);
                else
                    piraali(-tid*1.2);
                glPopMatrix();
            }
            glPopMatrix();

            if(mzx_position()/100==8)
            {
                glClear(GL_DEPTH_BUFFER_BIT);
                glPushMatrix();
                glTranslatef(0,0,musasynk(KICKBASS,tid)*6);
                stara(-tid,3,1);
                glPopMatrix();
            }

            glDisable(GL_DEPTH_TEST);
            glPushMatrix();
            glTranslatef(20-(tid-prev)*1.8,-1,-4);
            draw_string("naomba chakula moto haraka",tid);
            glPopMatrix();
            glTranslatef(45-(tid-prev)*2.2,-1,-4);
            draw_string("siwezi kusema kiswahili",tid);
            glEnable(GL_DEPTH_TEST);

            prev2=tid;
        }

        /* greetings */
        if(mzx_position()>=900 && mzx_position()<1200)
        {
            glTranslatef(0,0,musasynk(KICKBASS,tid)/15.0);
            tausta(tid,11,0);
            glMatrixMode(GL_MODELVIEW);
            greetnum = (mzx_position()-900)/26;
            if(greetnum>16) greetnum = 16;
            

            glMatrixMode(GL_MODELVIEW);

            glPushMatrix();         
            glTranslatef(0.7,-0.5,0);
            pallo(tid);
            glMatrixMode(GL_MODELVIEW);
            glPopMatrix();
            glPushMatrix();         
            glTranslatef(-0.9,1.8,-4);
            glScalef(0.8,0.8,0.8);
            draw_string("hakuna matata",tid);
            glMatrixMode(GL_MODELVIEW);
            glPopMatrix();
            
            glMatrixMode(GL_MODELVIEW);
            glTranslatef(grex[greetnum]*2.0f,grey[greetnum],-4);
            glScalef(0.9,0.9,0.9);
            draw_string(greeted[greetnum],tid);
            prev2=tid;
        }

        /* The final part and credits */
        if(mzx_position()>=1200)
        {
            tausta(tid,4,0);
            glMatrixMode(GL_MODELVIEW);

            glPushMatrix();
            glRotatef(sin(tid)*5.0,0,1,0.1);
            if(mzx_position()%100/16&1)
                piraali2(tid);
            else
                piraali2(-tid);
            glPopMatrix();

            if(!finito)
            {
                /*n=(tid-prev2)/1.5-3;
                if(n<0)
                    n=0;
                if(n>7)
                    n=7;*/

                if(mzx_position()<1400)
                    n=mzx_position()%100/16+1;
                if(mzx_position()<1300)
                    n=0;
                if(mzx_position()>=1400)
                    n=7;

                glPushMatrix();
                d=fmod(tid*5,4.0)-2.0;
                d=4.0-2.0*d*d;
                glTranslatef(0,d,sin(tid)*10.0-10.0);

                staroja(tid,n,1);
                glPopMatrix();
            }

            glDisable(GL_DEPTH_TEST);
            glPushMatrix();
            glTranslatef(-30+(tid-prev2)*1.8,-1,-4);
            draw_string("nipatie kinywaji baridi tafadhali",tid);
            glPopMatrix();
            glEnable(GL_DEPTH_TEST);

            if(mzx_position()>=1500)
            {
                if(musasynk(HIT,tid)>0.5)
                    finito=1;
                if(finito)
                    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
                else
                    glClear(GL_DEPTH_BUFFER_BIT);
                glPushMatrix();
                glTranslatef(0,0,musasynk(HIT,tid)*220-200);
                stara((tid-prev2)*3,3,finito);
                glPopMatrix();

                glTranslatef(0.4,1.1,-4);
                glRotatef(10,0,0,1);
                draw_string("marq",tid);
                glTranslatef(1,-1.2,0);
                glRotatef(-25,0,0,1);
                draw_string("ren",tid);
                glTranslatef(-3,-0.9,0);
                glRotatef(3,0,0,1);
                draw_string("yzi",tid);
                glRotatef(-20,0,0,1);
                glTranslatef(2,-0.6,0);
                draw_string("man",tid);
            }
        }

        if(mzx_position()>=1550)
            quit=1;

        musasynk(HIT,tid);
        musasynk(KICKBASS,tid);
        
        SDL_GL_SwapBuffers();
        while(SDL_PollEvent(&e)>0)
        {
            if(e.type==SDL_MOUSEBUTTONDOWN || e.type==SDL_QUIT ||
               e.type==SDL_KEYDOWN)
                quit=1;
        }
    }

    mzx_close();
    SDL_Quit();
    return(EXIT_SUCCESS);
}

void rinkula(float ker)
{
    float   r;

    if(ker<0)
        ker=0;

    glPushMatrix();
    glColor3f(0,0,0);
    glBegin(GL_TRIANGLE_STRIP);
    for(r=0;r<M_PI*2+0.2;r+=0.1)
    {
        glVertex2f(sin(r)*ker,cos(r)*ker);
        glVertex2f(sin(r)*(ker+5),cos(r)*(ker+5));
    }
    glEnd();
    glColor3f(1,1,1);
    glPopMatrix();
}

float musasynk(int instr,float tid)
{
    int n;
    float f;
    static float hit_tid,kick_tid;
    static int kickon=0,hiton=0;

    if(instr==HIT)
    {
        if(LASTRIG[HIT]<6 && !hiton)
        {
            hit_tid=tid;
            hiton=1;
        }

        f=sqrt(15*(tid-hit_tid));
        if(f<M_PI)
            f=sin(f);
        else
        {
            f=0;
            hiton=0;
        }
        return(f);
    }

    if(instr==KICKBASS)
    {
        if(LASTRIG[KICKBASS]<6 && !kickon)
        {
            kick_tid=tid;
            kickon=1;
        }

        f=sqrt(80*(tid-kick_tid));
        if(f<M_PI)
            f=sin(f);
        else
        {
            f=0;
            kickon=0;
        }
        return(f);
    }

    return(0);
}

