#include "include.h"
#include "pallot.h"

extern GLuint tex[];


void draw_sphere(float tim,float xx, float yy, float zz, float rr, int pp);
void draw_odd_sphere(float tim);
void pallo(float tim) {
    glMatrixMode(GL_MODELVIEW);	

	
    glPushMatrix();

	glTranslatef(0,0,-1.0f);
	glRotatef(tim*35.0f,0,1,0);
	glRotatef(tim*25.0f,0,0,1);
	glRotatef(tim*55.0f,1,0,0);


    glDisable(GL_CULL_FACE);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, tex[4]);
	glColor3f(1.0f,1.0f,1.0f);
	glEnable(GL_COLOR_MATERIAL);

		
	draw_odd_sphere(tim);
//	draw_sphere(tim,0,0,0,1.0f,16);

	
	glDisable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
    glPopMatrix();
    glColor3f(1,1,1);

}

void pallo2(float tim,int text) {
    glMatrixMode(GL_MODELVIEW);	

	
	
    glPushMatrix();

	glTranslatef(0,0,-50.0f);
	glRotatef(tim*5.0f,0,1,0);
	glRotatef(tim*7.0f,0,0,1);
	glRotatef(tim*3.0f,1,0,0);


    glDisable(GL_CULL_FACE);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, tex[text]);
	glColor3f(1.0f,1.0f,1.0f);
	glEnable(GL_COLOR_MATERIAL);

		
//	draw_odd_sphere(tim);
	draw_sphere(tim*10,0,0,0,10.0f,64);

	
	glDisable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
    glPopMatrix();
    glColor3f(1,1,1);

}


void draw_odd_sphere(float tim) {

	float x_,y_,z_,r_;
	int p_;

  int i;
  int j;
  double theta1;
  double theta2;
  double theta3;

  double x_e;
  double y_e;
  double z_e;

  double x_p;
  double y_p;
  double z_p;

	x_=0.0f;
	y_=0.0f;
	z_=0.0f;
	r_=1.0f;
	p_=16;

  if ( r_ < 0 )
    r_ = -r_;

  if ( p_ < 0 )
    p_ = -p_;

  if ( p_ < 4 || r_ <= 0) {

    glBegin(GL_POINTS);

    glVertex3f( x_, y_ , z_ );

    glEnd();

    return;

  }

    

  glLineWidth(2);
  
  for ( j = 0; j < p_ / 2; j++ ) {

    theta1 = j * 2*M_PI / p_ - M_PI / 2;
    theta2 = ( j + 1 ) * 2*M_PI / p_ - M_PI / 2;
	glColor3f(1,1,1);
	glEnable (GL_POLYGON_OFFSET_FILL);
    glPolygonOffset (1., 1.);

    glBegin( GL_QUAD_STRIP );

    for ( i = 0; i <= p_; i++ ) {

      theta3 = i * 2*M_PI / p_;

      x_e = cos( theta2 ) * cos( theta3 ) * sin(tim);
      y_e = sin( theta2 );
      z_e = cos( theta2 ) * sin( theta3 ) * sin(tim);
      x_p = x_ + r_ * x_e;
      y_p = y_ + r_ * y_e;
      z_p = z_ + r_ * z_e;

      glNormal3f(x_e, y_e, z_e );
      glTexCoord2f( i / ( double )p_, 2*( j + 1 ) / ( double )p_ );
      glVertex3f( x_p, y_p, z_p );

      x_e = cos( theta1 ) * cos( theta3) * sin(tim+1);
      y_e = sin( theta1 );
      z_e = cos( theta1 ) * sin( theta3) * sin(tim+1);
      x_p = x_ + r_ * x_e;
      y_p = y_ + r_ * y_e;
      z_p = z_ + r_ * z_e;

      glNormal3f( x_e, y_e, z_e );
      glTexCoord2f( i / ( double )p_, 2 * j / ( double )p_ );
      glVertex3f( x_p, y_p, z_p );
    }

    glEnd();
	glColor3f(0,0,0);



    glBegin( GL_LINE_STRIP );

    for ( i = 0; i <= p_; i++ ) {

      theta3 = i * 2*M_PI / p_;

      x_e = cos( theta2 ) * cos( theta3 ) * sin(tim);
      y_e = sin( theta2 );
      z_e = cos( theta2 ) * sin( theta3 ) * sin(tim);
      x_p = x_ + r_ * x_e;
      y_p = y_ + r_ * y_e;
      z_p = z_ + r_ * z_e;

      glNormal3f(x_e, y_e, z_e );
      glTexCoord2f( i / ( double )p_, 2*( j + 1 ) / ( double )p_ );
      glVertex3f( x_p, y_p, z_p );

	}

    glEnd();
    glBegin( GL_LINE_STRIP );

    for ( i = 0; i <= p_; i++ ) {

      theta3 = i * 2*M_PI / p_;

      x_e = cos( theta1 ) * cos( theta3) * sin(tim+1);
      y_e = sin( theta1 );
      z_e = cos( theta1 ) * sin( theta3) * sin(tim+1);
      x_p = x_ + r_ * x_e;
      y_p = y_ + r_ * y_e;
      z_p = z_ + r_ * z_e;

      glNormal3f( x_e, y_e, z_e );
      glTexCoord2f( i / ( double )p_, 2 * j / ( double )p_ );
      glVertex3f( x_p, y_p, z_p );
    }

    glEnd();

	glDisable (GL_POLYGON_OFFSET_FILL); 
  
  }

  glLineWidth(1);
  glColor3f(1,1,1);

}


void draw_sphere(float tim,float xx, float yy, float zz, float rr, int pp) {

	float x_,y_,z_,r_;
	int p_;

	float tid = tim / 30.0f;
  int i;
  int j;
  double theta1;
  double theta2;
  double theta3;

  double x_e;
  double y_e;
  double z_e;

  double x_p;
  double y_p;
  double z_p;

	x_=xx;
	y_=yy;
	z_=zz;
	r_=rr;
	p_=pp;

  if ( r_ < 0 )
    r_ = -r_;

  if ( p_ < 0 )
    p_ = -p_;

  if ( p_ < 4 || r_ <= 0) {

    glBegin(GL_POINTS);

    glVertex3f( x_, y_ , z_ );

    glEnd();

    return;

  }


  glLineWidth(2);
  
  for ( j = 0; j < p_ / 2; j++ ) {

    theta1 = j * 2*M_PI / p_ - M_PI / 2;
    theta2 = ( j + 1 ) * 2*M_PI / p_ - M_PI / 2;
	glColor3f(1,1,1);
	glEnable (GL_POLYGON_OFFSET_FILL);
    glPolygonOffset (1., 1.);
	glEnable(GL_TEXTURE_2D);
    glBegin( GL_QUAD_STRIP );

    for ( i = 0; i <= p_; i++ ) {

      theta3 = i * 2*M_PI / p_;

      x_e = cos( theta2 ) * cos( theta3 );
      y_e = sin( theta2 );
      z_e = cos( theta2 ) * sin( theta3 );
      x_p = x_ + r_ * x_e+ sin(tid*(j/5.0f)*3+theta1*5)*1.0;
      y_p = y_ + r_ * y_e+ sin(tid*(j/5.0f)*2+theta2*6)*1.0;
      z_p = z_ + r_ * z_e+ sin(tid*(j/5.0f)+theta3*7)*1.0;

      glNormal3f(x_e, y_e, z_e );
      glTexCoord2f( i / ( double )p_, 2*( j + 1 ) / ( double )p_ );
      glVertex3f( x_p, y_p, z_p );

      x_e = cos( theta1 ) * cos( theta3);
      y_e = sin( theta1 );
      z_e = cos( theta1 ) * sin( theta3);
      x_p = x_ + r_ * x_e+ sin(tid*(j/5.0f)*3+theta1*5)*1.0;
      y_p = y_ + r_ * y_e+ sin(tid*(j/5.0f)*2+theta2*6)*1.0;
      z_p = z_ + r_ * z_e+ sin(tid*(j/5.0f)+theta3*7)*1.0;

      glNormal3f( x_e, y_e, z_e );
      glTexCoord2f( i / ( double )p_, 2 * j / ( double )p_ );
      glVertex3f( x_p, y_p, z_p );
    }

    glEnd();
	
 
	glDisable (GL_POLYGON_OFFSET_FILL); 

  }

  glLineWidth(1);
  glColor3f(1,1,1);

}