
#include "include.h"

#define ASK 30.0
#define PAXUUS 0.2
#define LEVEYS 0.2

void piraali(float tid)
{
    double  d,dp,r=0,dx,dy,phase,ex=0.15;
    int     n;

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef(0,0,-0.7);
    glRotatef(sin(tid)*20,0,1,0);
    glRotatef(cos(tid*2),1,0,0);
    glDisable(GL_CULL_FACE);
    glEnable(GL_DEPTH_TEST);
    glDisable(GL_TEXTURE_2D);
    glRotatef(sin(tid*0.2)*120.0,0,0,1);

    for(phase=0;phase<5;phase++)
    {
        glPushMatrix();
        if(phase==3 || phase==4)
        {
            glDisable(GL_DEPTH_TEST);
            glLineWidth(2.0);
            glColor3f(0,0,0);
        }
        for(n=0,r=0;n<11;n++,r+=2.2*LEVEYS)
        {
            if(phase==0)
                glColor3f(n/10.0,1-n/10.0,0);
            if(phase==1 || phase==2)
                glColor3f(1-n/10.0,0,0.6);

            dx=cos(tid*4+n/2.0)*LEVEYS*2.15+n*ex-0.6;
            dy=sin(tid*4+n/2.0)*LEVEYS*2.15     -0.6;
            if(phase<3)
                glBegin(GL_TRIANGLE_STRIP);
            else
                glBegin(GL_LINE_STRIP);
            for(d=0;d<=2.0*M_PI+0.2;d+=M_PI*2.0/(double)ASK)
            {
                dp=d+M_PI*2.0/ASK;
                if(phase==0)
                {
                    glVertex3f(sin(d)*r+dx,cos(d)*r+dy,PAXUUS);
                    glVertex3f(sin(d)*(r+LEVEYS)+dx+ex,cos(d)*(r+LEVEYS)+dy,PAXUUS);
                }
                if(phase==1)
                {
                    glVertex3f(sin(d)*r+dx,cos(d)*r+dy,-PAXUUS);
                    glVertex3f(sin(d)*r+dx,cos(d)*r+dy,PAXUUS);
                }
                if(phase==2)
                {
                    glVertex3f(sin(d)*(r+LEVEYS)+dx+ex,cos(d)*(r+LEVEYS)+dy,-PAXUUS);
                    glVertex3f(sin(d)*(r+LEVEYS)+dx+ex,cos(d)*(r+LEVEYS)+dy,PAXUUS);
                }
                if(phase==3)
                    glVertex3f(sin(d)*(r+LEVEYS)+dx+ex,cos(d)*(r+LEVEYS)+dy,PAXUUS);
                if(phase==4)
                    glVertex3f(sin(d)*r+dx,cos(d)*r+dy,PAXUUS);
            }
            glEnd();
        }
        glPopMatrix();
    }
    glDisable(GL_DEPTH_TEST);
    glPopMatrix();
    glColor3f(1,1,1);
}
