
#include "include.h"

#define PAXUUS 0.6
#define LEVEYS 0.3

void piraali2(float tid)
{
    int phase;
    double r,r2,d;

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef(0,0,-3);
    glEnable(GL_DEPTH_TEST);
    glRotatef(-tid*240.0,0,0,1);
    glRotatef(sin(tid*2.0)*10.0,0,1,0);

    for(phase=0;phase<5;phase++)
    {
        glColor3f(1,0,0);
        if(phase<3)
        {
            glBegin(GL_TRIANGLE_STRIP);
        }
        else
        {
            glDisable(GL_DEPTH_TEST);
            glLineWidth(2.0);
            glBegin(GL_LINE_STRIP);
        }
    
        for(r=0;r<120;r+=0.7)
        {
            r2=r/(5+sin(tid*1.1)*3);
            d=r/30;

            if(phase<3)
            {
                if(phase==0)
                    glColor3f(sin(tid*2)*0.5+0.5,1-r/200,
                              sin(r*2.0-tid*10)*0.5+0.5);
                else
                    glColor3f(sin(tid*2)*0.3+0.3,0.5-r/300,
                              sin(r*2.0-tid*10)*0.2+0.2);
            }
            else
                glColor3f(0,0,0);

            if(phase==0)
            {
                glVertex3f(sin(r2)*d,cos(r2)*d,0);
                glVertex3f(sin(r2+0.2)*(d+LEVEYS),cos(r2+0.2)*(d+LEVEYS),0);
            }
            if(phase==1)
            {
                glVertex3f(sin(r2)*d,cos(r2)*d,-PAXUUS);
                glVertex3f(sin(r2)*d,cos(r2)*d,0);
            }
            /*if(phase==2)
            {
                glVertex3f(sin(r2+0.2)*(d+LEVEYS),cos(r2+0.2)*(d+LEVEYS),0);
                glVertex3f(sin(r2+0.2)*(d+LEVEYS),cos(r2+0.2)*(d+LEVEYS),-PAXUUS);
            }*/

            if(phase==4)
                glVertex3f(sin(r2)*d,cos(r2)*d,0);
            if(phase==3)
                glVertex3f(sin(r2+0.2)*(d+LEVEYS),cos(r2+0.2)*(d+LEVEYS),0);
        }
        glEnd();
    }

    glDisable(GL_DEPTH_TEST);
    glPopMatrix();
}
