#include "include.h"

#define PAXUUS 0.5

void rays(float tid,int rays,float thickness)
{
    int phase;
    float   lev=M_PI*2*thickness/(rays);
    double  r,d,r2;

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef(0,0,-2);
    glLineWidth(2);
    glRotatef(sin(tid)*20,0,1,0);
    glShadeModel(GL_SMOOTH);

    for(phase=0;phase<5;phase++)
    {
        for(r=0;r<M_PI*2-0.1;r+=M_PI*2/rays)
        {
            if(phase<3)
            {
                glColor3f(1,1,1);
                glEnable(GL_DEPTH_TEST);
                glBegin(GL_TRIANGLE_STRIP);
            }
            else
            {
                glColor3f(0,0,0);
                glDisable(GL_DEPTH_TEST);
                glBegin(GL_LINE_STRIP);
            }

            for(d=0;d<4;d+=0.1)
            {
                r2=r+sin(d+tid*2.0)+0.2*sin(d*2.1-tid*0.5);

                if(phase<3)
                    if(phase==0)
                        glColor3f(0.4+0.4*sin(r+d*5-tid*5),sin(r+tid)*0.2+0.7,
                                  0.5+0.5*sin(r+tid));
                    else
                        glColor3f(0.5+0.5*sin(r+d*5+tid*5),sin(r-tid)*0.2+0.4,
                                  0.2+0.2*sin(r+tid));
    
                if(phase==0)
                {
                    glVertex2f(sin(r2)*d,cos(r2)*d);
                    glVertex2f(sin(r2+lev)*d,cos(r2+lev)*d);
                }
                if(phase==1)
                {
                    glVertex3f(sin(r2)*d,cos(r2)*d,0);
                    glVertex3f(sin(r2)*d,cos(r2)*d,-PAXUUS);
                }
                if(phase==2)
                {
                    glVertex3f(sin(r2+lev)*d,cos(r2+lev)*d,-PAXUUS);
                    glVertex3f(sin(r2+lev)*d,cos(r2+lev)*d,0);
                }

                if(phase==3)
                    glVertex2f(sin(r2)*d,cos(r2)*d);
                if(phase==4)
                    glVertex2f(sin(r2+lev)*d,cos(r2+lev)*d);
            }
            glEnd();
        }
    }

    glPopMatrix();
}
