
#include "include.h"

#define DEPTH1 6
#define DEPTH2 0
#define LEVEYS 2

void stara(float tid,int num,int rotate)
{
    double  d,dp,r=0,dx,dy,phase,r2,ex;
    int     n,inset;

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glDisable(GL_CULL_FACE);
    glEnable(GL_DEPTH_TEST);
    glDisable(GL_TEXTURE_2D);
    glTranslatef(0,0,-26.0);
    if(rotate)
    {
            glRotatef(tid*80,0,0,1);
            glRotatef(sin(tid*2)*10.0,0,1,0);
    }

    for(phase=0;phase<5;phase++)
    {
        glPushMatrix();
        if(phase==3 || phase==4)
        {
            glDisable(GL_DEPTH_TEST);
            glLineWidth(2.0);
            glColor3f(0,0,0);
        }
        for(n=1,r=0.7;n<=num;n++,r*=1.5,r+=4)
        {
            if(phase==0)
                glColor3f(n/10.0,1-n/10.0,0);
            if(phase==1 || phase==2)
                glColor3f(1-n/10.0,0,0.6);

            glPushMatrix();
            if(rotate)
                glRotatef(sin(-tid*5.0+n)*17.0,0,1,0);
        
            dx=0;
            dy=0;
            if(phase<3)
                glBegin(GL_TRIANGLE_STRIP);
            else
                glBegin(GL_LINE_STRIP);

            for(d=M_PI/5,inset=0;d<=2.0*M_PI+M_PI/4;d+=M_PI*2.0/10,inset++)
            {
                if(inset&1)
                {
                    r2=r;
                    ex=LEVEYS+r/2;
                }
                else
                {
                    r2=r*0.5;
                    ex=(LEVEYS+r/2)*0.5;
                }

                if(phase<3)
                {
                    if(phase==0)
                        glColor3f(0.3+0.3*sin(r),sin(tid)*0.5+0.5,0.7+sin(d+tid));
                    else
                        glColor3f(0.6,sin(d/M_PI)*0.2+0.2,1.0-sin(tid+d/M_PI));
                }

                dp=d+M_PI*2.0/5;
                if(phase==0)
                {
                    glVertex3f(sin(d)*r2+dx,cos(d)*r2+dy,DEPTH1);
                    glVertex3f(sin(d)*(r2+ex)+dx,cos(d)*(r2+ex)+dy,DEPTH1);
                }
                if(phase==1)
                {
                    glVertex3f(sin(d)*r2+dx,cos(d)*r2+dy,DEPTH2);
                    glVertex3f(sin(d)*r2+dx,cos(d)*r2+dy,DEPTH1);
                }
                if(phase==2)
                {
                    glVertex3f(sin(d)*(r2+ex)+dx,cos(d)*(r2+ex)+dy,DEPTH2);
                    glVertex3f(sin(d)*(r2+ex)+dx,cos(d)*(r2+ex)+dy,DEPTH1);
                }
                if(phase==3)
                    glVertex3f(sin(d)*(r2+ex)+dx,cos(d)*(r2+ex)+dy,DEPTH1);
                if(phase==4)
                    glVertex3f(sin(d)*r2+dx,cos(d)*r2+dy,DEPTH1);
            }
            glEnd();

            glPopMatrix();
        }
        glPopMatrix();
    }
    glDisable(GL_DEPTH_TEST);
    glPopMatrix();
    glColor3f(1,1,1);
}

void staroja(float tid,int num,int rings)
{
    int x,y;

    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef(-7.0*num/2.0+3.5,-6*num/2.0+3.0,0);
    for(y=0;y<num;y++)
    {
        for(x=0;x<num;x++)
        {
            glPushMatrix();
            stara(tid+(x+y)/10.0,rings,1);
            glPopMatrix();
            glTranslatef(7,0,0);
        }
        glTranslatef(-num*7,6,0);
    }
    glPopMatrix();
}
