
#include "include.h"
#include "tausta.h"


#define MAX_X 16
#define MAX_Y 16
#define SIZE_X 4.5f
#define SIZE_Y -3.5f
#define DIS 0.1f
#define TEXTUREJA 12
#define SW 0.1f
#define FACT 1.0f

GLuint tex[TEXTUREJA];
char *texs[TEXTUREJA]={
	"data/lionfun.jpg",
	"data/jagfun.jpg",
	"data/girafun.jpg",
	"data/buffun.jpg",
	"data/elefun.jpg",
	"data/flamfun.jpg",
	"data/monkfun.jpg",
	"data/crocfun.jpg",
	"data/zebrfun2.jpg",
	"data/funaf.jpg",
	"data/puu_small.jpg",
	"data/oho_small.jpg"

};

unsigned char *loadJPG(char *path,int *width,int *height);

void init_tausta() {

    int x,y,i;
    unsigned char   *data;

    


	glGenTextures(TEXTUREJA, tex);

	for(i = 0; i<TEXTUREJA; i++) {

		glBindTexture(GL_TEXTURE_2D, tex[i]);
		data=loadJPG(texs[i],&x,&y);

		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	
	    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	
		
		glTexImage2D(GL_TEXTURE_2D,0, 3,x,y,0,GL_RGB,GL_UNSIGNED_BYTE,data);

	
		free(data);	
	}

}

void tausta(float tim,int i,float swirl) {
	int x,y;
	float dx,dy;

	float tid = tim*3.0f;
	float s2,c2;

	swirl *= 5.0f;

    glMatrixMode(GL_MODELVIEW);	

    glPushMatrix();



    glTranslatef(-SIZE_X/2.0f,-SIZE_Y/2.0f,-1.0f);
    glDisable(GL_CULL_FACE);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, tex[i]);
	glDepthMask(0);
	glColor3f(1.0f,1.0f,1.0f);
	glEnable(GL_COLOR_MATERIAL);
	glBegin(GL_QUADS);
	
	for(y = 0; y<MAX_Y; y++) {
		for(x = 0; x<MAX_X; x++) {
			s2 = (float)sin(x+y+swirl)*SW;
			c2 = (float)cos(x+y+swirl)*SW;
			dx = (sin(x+tid)*DIS)+(s2*swirl*DIS*10.0f);
			dy = cos(y+tid)*DIS+(c2*swirl*DIS*10.0f);
			glTexCoord2f((float)x/MAX_X    ,(float)y/MAX_Y); 
			glVertex3f(x*SIZE_X/MAX_X + dx,y*SIZE_Y/MAX_Y  + dy   ,0);
			

			s2 = (float)sin(x+1+y+swirl)*SW;
			c2 = (float)cos(x+1+y+swirl)*SW;
			dx = sin(x+1+tid)*DIS+(s2*swirl*DIS*10.0f);
			dy = cos(y+tid)*DIS+(c2*swirl*DIS*10.0f);
			glTexCoord2f((float)(x+1)/MAX_X,(float)y/MAX_Y);  
			glVertex3f((x+1)*SIZE_X/MAX_X + dx,y*SIZE_Y/MAX_Y  + dy   ,0);

			s2 = sin(x+2+y+swirl)*SW;
			c2 = cos(x+2+y+swirl)*SW;
			dx = sin(x+1+tid)*DIS+(s2*swirl*DIS*10.0f);
			dy = cos(y+1+tid)*DIS+(c2*swirl*DIS*10.0f);
			glTexCoord2f((float)(x+1)/MAX_X,(float)(y+1)/MAX_Y);  
			glVertex3f((x+1)*SIZE_X/MAX_X + dx,(y+1)*SIZE_Y/MAX_Y + dy,0);
		
			s2 = sin(x+1+y+swirl)*SW;
			c2 = cos(x+1+y+swirl)*SW;
			dx = sin(x+tid)*DIS+(s2*swirl*DIS*10.0f);
			dy = cos(y+1+tid)*DIS+(c2*swirl*DIS*10.0f);
			glTexCoord2f((float)x/MAX_X    ,(float)(y+1)/MAX_Y);  
			glVertex3f(x*SIZE_X/MAX_X + dx    ,(y+1)*SIZE_Y/MAX_Y + dy,0);
		}
	}
	glEnd();

	glDisable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
	glDepthMask(1);

    glPopMatrix();

    glColor3f(1,1,1);

//	pallo(tim);

//    glMatrixMode(GL_PROJECTION);

}

