#ifndef _MCUBETABLE_H
#define _MCUBETABLE_H

#define MAXKOLMIOT 15
/*
//
//     4.----.5
//     /|   /|
//    / |  / |
//  0.--+-.1 |
//   |  | |  |
//   | 7.-+--.6
//   | /  | /
//   |/   |/
//  3.----.2
//


//
//     4.-4--.5
//     /|   /|
//    8 7  9 5
//  0.-0+-.1 |
//   |  | |  |
//   | 7.-+6-.6
//   3 /  1 /
//   |11  |10
//  3.-2--.2
//

*/

const int mc_table[256][MAXKOLMIOT] = {
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  0: 0 kulmaa
    { 3, 8, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  1: 1 kulma (0)
    { 1, 0, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  2: 1 kulma (1)
    { 3, 8, 9, 3, 9, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  3: 2 kulmaa(1,0)
    { 2, 1,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  4: 1 kulma (2)
    { 3, 8, 0, 2, 1,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  5: 2 kulmaa(2,0)
    { 0, 9,10, 0,10, 2,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  6: 2 kulmaa(2,1)
    { 9,10, 2, 9, 2, 3, 9, 3, 8,-1,-1,-1,-1,-1,-1} ,  //x  7: 3 kulmaa(2,1,0)
    { 2,11, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  8: 1 kulma (3)
    { 2,11, 8, 2, 8, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  9: 2 kulmaa(3,0)
    { 2,11, 3, 1, 0, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  10: 2 kulmaa(3,1)
    { 8, 9, 1, 8, 1, 2, 8, 2,11,-1,-1,-1,-1,-1,-1} ,  //x  11: 3 kulmaa(3,1,0)
    { 3, 1,10, 3,10,11,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  12: 2 kulmaa(3,2)
    {11, 8, 0,11, 0, 1,11, 1,10,-1,-1,-1,-1,-1,-1} ,  //x  13: 3 kulmaa(3,2,0)
    {10,11, 3,10, 3, 0,10, 0, 9,-1,-1,-1,-1,-1,-1} ,  //x  14: 3 kulmaa(3,2,1)
    { 8, 9,10, 8,10,11,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  15: 4 kulmaa(3,2,1,0)
    { 4, 8, 7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  16: 1 kulma (4)
    { 7, 4, 0, 7, 0, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  17: 2 kulmaa(4,0)
    { 4, 8, 7, 1, 0, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  18: 2 kulmaa(4,1)
    { 3, 7, 4, 3, 4, 9, 3, 9, 1,-1,-1,-1,-1,-1,-1} ,  //x  19: 3 kulmaa(4,1,0)
    { 4, 8, 7, 2, 1,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  20: 2 kulmaa(4,2)
    { 7, 4, 0, 7, 0, 3, 2, 1,10,-1,-1,-1,-1,-1,-1} ,  //x  21: 3 kulmaa(4,2,0)
    { 4, 8, 7, 0, 9,10, 0,10, 2,-1,-1,-1,-1,-1,-1} ,  //x  22: 3 kulmaa(4,2,1)
    { 2, 3, 7, 2, 7, 4, 2, 4, 9, 2, 9,10,-1,-1,-1} ,  //x  23: 4 kulmaa(4,2,1,0)
    { 4, 8, 7, 2,11, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  24: 2 kulmaa(4,3)
    { 0, 2,11, 0,11, 7, 0, 7, 4,-1,-1,-1,-1,-1,-1} ,  //x  25: 3 kulmaa(4,3,0)
    { 4, 8, 7, 2,11, 3, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //x  26: 3 kulmaa(4,3,1)
    { 1, 2,11, 1,11, 7, 1, 7, 9, 9, 7, 4,-1,-1,-1} ,  //x  27: 4 kulmaa(4,3,1,0)
    { 4, 8, 7, 3, 1,10, 3,10,11,-1,-1,-1,-1,-1,-1} ,  //x  28: 3 kulmaa(4,3,2)
    {11, 7, 4,11, 4, 0,11, 0, 1,11, 1,10,-1,-1,-1} ,  //x  29: 4 kulmaa(4,3,2,0)
    { 4, 8, 7,10,11, 3,10, 3, 0,10, 0, 9,-1,-1,-1} ,  //x  30: 4 kulmaa(4,3,2,1)
    {10,11, 7,10, 7, 4,10, 4, 9,-1,-1,-1,-1,-1,-1} ,  //x  31: 5 kulmaa(4,3,2,1,0)
    { 4, 5, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  32: 1 kulma (5)
    { 4, 5, 9, 3, 8, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  33: 2 kulmaa(5,0)
    { 4, 5, 1, 4, 1, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  34: 2 kulmaa(5,1)
    { 1, 3, 8, 1, 8, 4, 1, 4, 5,-1,-1,-1,-1,-1,-1} ,  //x  35: 3 kulmaa(5,1,0)
    { 4, 5, 9, 2, 1,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  36: 2 kulmaa(5,2)
    { 4, 5, 9, 2, 1,10, 3, 8, 0,-1,-1,-1,-1,-1,-1} ,  //x  37: 3 kulmaa(5,2,0)
    { 0, 4, 5, 0, 5,10, 0,10, 2,-1,-1,-1,-1,-1,-1} ,  //x  38: 3 kulmaa(5,2,1)
    { 2, 3, 8, 2, 8, 4, 2, 4,10,10, 4, 5,-1,-1,-1} ,  //x  39: 4 kulmaa(5,2,1,0)
    { 4, 5, 9, 2,11, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  40: 2 kulmaa(5,3)
    { 4, 5, 9, 2,11, 8, 2, 8, 0,-1,-1,-1,-1,-1,-1} ,  //x  41: 3 kulmaa(5,3,0)
    { 4, 5, 1, 4, 1, 0, 2,11, 3,-1,-1,-1,-1,-1,-1} ,  //x  42: 3 kulmaa(5,3,1)
    { 8, 4, 5, 8, 5, 1, 8, 1,11,11, 1, 2,-1,-1,-1} ,  //x  43: 4 kulmaa(5,3,1,0)
    { 4, 5, 9, 3, 1,10, 3,10,11,-1,-1,-1,-1,-1,-1} ,  //x  44: 3 kulmaa(5,3,2)
    { 4, 5, 9,11, 8, 0,11, 0, 1,11, 1,10,-1,-1,-1} ,  //x  45: 4 kulmaa(5,3,2,0)
    {11, 3, 0,11, 0, 4,11, 4,10,10, 4, 5,-1,-1,-1} ,  //x  46: 4 kulmaa(5,3,2,1)
    {11, 8, 4,11, 4, 5,11, 5,10,-1,-1,-1,-1,-1,-1} ,  //x  47: 5 kulmaa(5,3,2,1,0)
    { 8, 7, 5, 8, 5, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  48: 2 kulmaa(5,4)
    { 7, 5, 9, 7, 9, 0, 7, 0, 3,-1,-1,-1,-1,-1,-1} ,  //x  49: 3 kulmaa(5,4,0)
    { 5, 1, 0, 5, 0, 8, 5, 8, 7,-1,-1,-1,-1,-1,-1} ,  //x  50: 3 kulmaa(5,4,1)
    { 3, 7, 5, 3, 5, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  51: 4 kulmaa(5,4,1,0)
    { 8, 7, 5, 8, 5, 9, 2, 1,10,-1,-1,-1,-1,-1,-1} ,  //x  52: 3 kulmaa(5,4,2)
    { 7, 5, 9, 7, 9, 0, 7, 0, 3, 2, 1,10,-1,-1,-1} ,  //x  53: 4 kulmaa(5,4,2,0)
    { 5,10, 2, 5, 2, 0, 5, 0, 7, 0, 8, 7,-1,-1,-1} ,  //x  54: 4 kulmaa(5,4,2,1)
    { 7, 5,10, 7,10, 2, 7, 2, 3,-1,-1,-1,-1,-1,-1} ,  //x  55: 5 kulmaa(5,4,2,1,0)
    { 8, 7, 5, 8, 5, 9, 2,11, 3,-1,-1,-1,-1,-1,-1} ,  //x  56: 3 kulmaa(5,4,3)
    { 7, 2,11, 7, 0, 2, 7, 5, 0, 0, 5, 9,-1,-1,-1} ,  //x  57: 4 kulmaa(5,4,3,0)
    { 5, 1, 0, 5, 0, 8, 5, 8, 7, 2,11, 3,-1,-1,-1} ,  //x  58: 4 kulmaa(5,4,3,1)
    { 5, 1, 2, 5, 2,11, 5,11, 7,-1,-1,-1,-1,-1,-1} ,  //x  59: 5 kulmaa(5,4,3,1,0)
    { 8, 7, 5, 8, 5, 9, 3, 1,10, 3,10,11,-1,-1,-1} ,  //x  60: 4 kulmaa(5,4,3,2)
    { 7, 5, 9, 7, 9, 0, 7, 0,11,11, 0, 1,11, 1,10} ,  //y  61: 5 kulmaa(5,4,3,2,0)
    {10,11, 3,10, 3, 0,10, 0, 5, 5, 0, 8, 5, 8, 7} ,  //y  62: 5 kulmaa(5,4,3,2,1)			y=pitas toimia
    {11, 7, 5,11, 5,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  63: 6 kulmaa(5,4,3,2,1,0)
    { 5, 6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  64: 1 kulma (6)
    { 5, 6,10, 3, 8, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //t  65: 2 kulmaa(6,0)				t=tarkistettava, eli voi toimia hyvinkin
    { 5, 6,10, 1, 0, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  66: 2 kulmaa(6,1)
    { 5, 6,10, 3, 8, 9, 3, 9, 1,-1,-1,-1,-1,-1,-1} ,  //t  67: 3 kulmaa(6,1,0)
    { 6, 2, 1, 6, 1, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  68: 2 kulmaa(6,2)
    { 6, 2, 1, 6, 1, 5, 3, 8, 0,-1,-1,-1,-1,-1,-1} ,  //t  69: 3 kulmaa(6,2,0)
    { 2, 0, 9, 2, 9, 5, 2, 5, 6,-1,-1,-1,-1,-1,-1} ,  //x  70: 3 kulmaa(6,2,1)
    { 2, 3, 8, 2, 8, 9, 2, 9, 6, 6, 9, 5,-1,-1,-1} ,  //x  71: 4 kulmaa(6,2,1,0)
    { 5, 6,10, 2,11, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  72: 2 kulmaa(6,3)
    { 5, 6,10, 2,11, 8, 2, 8, 0,-1,-1,-1,-1,-1,-1} ,  //t  73: 3 kulmaa(6,3,0)
    { 5, 6,10, 2,11, 3, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //x  74: 3 kulmaa(6,3,1)
    { 5, 6,10, 8, 9, 1, 8, 1, 2, 8, 2,11,-1,-1,-1} ,  //t  75: 4 kulmaa(6,3,1,0)
    { 1, 5, 6, 1, 6,11, 1,11, 3,-1,-1,-1,-1,-1,-1} ,  //x  76: 3 kulmaa(6,3,2)
    {11, 8, 0,11, 0, 6, 6, 0, 1, 6, 1, 5,-1,-1,-1} ,  //x  77: 4 kulmaa(6,3,2,0)
    {11, 3, 0,11, 0, 9,11, 9, 6, 6, 9, 5,-1,-1,-1} ,  //x  78: 4 kulmaa(6,3,2,1)
    { 8, 9, 5, 8, 5, 6, 8, 6,11,-1,-1,-1,-1,-1,-1} ,  //x  79: 5 kulmaa(6,3,2,1,0)
    { 5, 6,10, 4, 8, 7,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  80: 2 kulmaa(6,4)
    { 5, 6,10, 7, 4, 0, 7, 0, 3,-1,-1,-1,-1,-1,-1} ,  //t  81: 3 kulmaa(6,4,0)
    { 5, 6,10, 4, 8, 7, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //t  82: 3 kulmaa(6,4,1)
    { 5, 6,10, 3, 7, 4, 3, 4, 9, 3, 9, 1,-1,-1,-1} ,  //t  83: 4 kulmaa(6,4,1,0)
    { 6, 2, 1, 6, 1, 5, 4, 8, 7,-1,-1,-1,-1,-1,-1} ,  //x  84: 3 kulmaa(6,4,2)
    { 6, 2, 1, 6, 1, 5, 7, 4, 0, 7, 0, 3,-1,-1,-1} ,  //x  85: 4 kulmaa(6,4,2,0)
    { 2, 0, 9, 2, 9, 5, 2, 5, 6, 4, 8, 7,-1,-1,-1} ,  //x  86: 4 kulmaa(6,4,2,1)
    { 3, 7, 4, 3, 4, 9, 3, 9, 2, 2, 9, 5, 2, 5, 6} ,  //y  87: 5 kulmaa(6,4,2,1,0)
    { 5, 6,10, 4, 8, 7, 2,11, 3,-1,-1,-1,-1,-1,-1} ,  //t  88: 3 kulmaa(6,4,3)
    { 5, 6,10, 0, 2,11, 0,11, 7, 0, 7, 4,-1,-1,-1} ,  //t  89: 4 kulmaa(6,4,3,0)
    { 5, 6,10, 4, 8, 7, 2,11, 3, 1, 0, 9,-1,-1,-1} ,  //t  90: 4 kulmaa(6,4,3,1)
    { 5, 6,10, 1, 2,11, 1,11, 7, 1, 7, 9, 9, 7, 4} ,  //x  91: 5 kulmaa(6,4,3,1,0)
    { 1, 5, 6, 1, 6,11, 1,11, 3, 4, 8, 7,-1,-1,-1} ,  //x  92: 4 kulmaa(6,4,3,2)
    { 7, 4, 0, 7, 0,11,11, 0, 1, 6, 1, 5,-1,-1,-1} ,  //y  93: 5 kulmaa(6,4,3,2,0)
    {11, 3, 0,11, 0, 9,11, 9, 6, 6, 9, 5, 4, 8, 7} ,  //t  94: 5 kulmaa(6,4,3,2,1)
    { 6,11, 7, 6, 7, 4, 6, 4, 5, 4, 9, 5,-1,-1,-1} ,  //t  95: 6 kulmaa(6,4,3,2,1,0)
    { 4, 6,10, 4,10, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x  96: 2 kulmaa(6,5)
    { 4, 6,10, 4,10, 9, 3, 8, 0,-1,-1,-1,-1,-1,-1} ,  //x  97: 3 kulmaa(6,5,0)
    { 6,10, 1, 6, 1, 0, 6, 0, 4,-1,-1,-1,-1,-1,-1} ,  //x  98: 3 kulmaa(6,5,1)
    { 6,10, 1, 6, 1, 4, 1, 3, 4, 3, 8, 4,-1,-1,-1} ,  //x  99: 4 kulmaa(6,5,1,0)
    { 6, 2, 1, 6, 1, 9, 6, 9, 4,-1,-1,-1,-1,-1,-1} ,  //x 100: 3 kulmaa(6,5,2)
    { 6, 2, 1, 6, 1, 9, 6, 9, 4, 3, 8, 0,-1,-1,-1} ,  //x 101: 4 kulmaa(6,5,2,0)
    { 6, 2, 0, 6, 0, 4,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 102: 4 kulmaa(6,5,2,1)
    { 6, 2, 3, 6, 3, 8, 6, 8, 4,-1,-1,-1,-1,-1,-1} ,  //x 103: 5 kulmaa(6,5,2,1,0)
    { 4, 6,10, 4,10, 9, 2,11, 3,-1,-1,-1,-1,-1,-1} ,  //x 104: 3 kulmaa(6,5,3)
    { 4, 6,10, 4,10, 9, 2,11, 8, 2, 8, 0,-1,-1,-1} ,  //x 105: 4 kulmaa(6,5,3,0)
    { 6,10, 1, 6, 1, 0, 6, 0, 4, 2,11, 3,-1,-1,-1} ,  //x 106: 4 kulmaa(6,5,3,1)
    { 4, 6,10, 4,10, 1, 4, 1, 8, 8, 1, 2, 8, 2,11} ,  //y 107: 5 kulmaa(6,5,3,1,0)
    {11, 3, 1,11, 1, 6, 6, 1, 9, 6, 9, 4,-1,-1,-1} ,  //t 108: 4 kulmaa(6,5,3,2)
    {11, 8, 0,11, 0, 1,11, 1, 6, 6, 1, 9, 6, 9, 4} ,  //y 109: 5 kulmaa(6,5,3,2,0)
    { 4, 6,11, 4,11, 3, 4, 3, 0,-1,-1,-1,-1,-1,-1} ,  //x 110: 5 kulmaa(6,5,3,2,1)
    {11, 8, 4,11, 4, 6,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 111: 6 kulmaa(6,5,3,2,1,0)
    { 9, 8, 7, 9, 7, 6, 9, 6,10,-1,-1,-1,-1,-1,-1} ,  //x 112: 3 kulmaa(6,5,4)
    { 3, 7, 0, 7, 9, 0, 7, 6, 9, 6,10, 9,-1,-1,-1} ,  //x 113: 4 kulmaa(6,5,4,0)
    { 0, 8, 7, 0, 7, 1, 1, 7, 6, 1, 6,10,-1,-1,-1} ,  //x 114: 4 kulmaa(6,5,4,1)
    { 3, 7, 6, 3, 6,10, 3,10, 1,-1,-1,-1,-1,-1,-1} ,  //x 115: 5 kulmaa(6,5,4,1,0)
    { 8, 7, 9, 7, 6, 9, 6, 1, 9, 6, 2, 1,-1,-1,-1} ,  //x 116: 4 kulmaa(6,5,4,2)
    { 3, 7, 0, 7, 9, 0, 7, 6, 9, 6, 1, 9, 6, 2, 1} ,  //t 117: 5 kulmaa(6,5,4,2,0)
    { 2, 0, 8, 2, 8, 7, 2, 7, 6,-1,-1,-1,-1,-1,-1} ,  //x 118: 5 kulmaa(6,5,4,2,1)
    { 2, 3, 7, 2, 7, 6,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 119: 6 kulmaa(6,5,4,2,1,0)
    { 9, 8, 7, 9, 7, 6, 9, 6,10, 2,11, 3,-1,-1,-1} ,  //x 120: 4 kulmaa(6,5,4,3)
    { 0, 2,11, 0,11, 7, 0, 7, 9, 9, 7, 6, 9, 6,10} ,  //x 121: 5 kulmaa(6,5,4,3,0)
    { 0, 8, 7, 0, 7, 1, 1, 7, 6, 1, 6,10, 2,11, 3} ,  //x 122: 5 kulmaa(6,5,4,3,1)
    {11, 7, 6,11, 6, 2,10, 2, 6,10, 1, 2,-1,-1,-1} ,  //x 123: 6 kulmaa(6,5,4,3,1,0)
    { 7, 1, 8, 7, 6, 9, 6, 1, 9, 6,11, 1,11, 3, 1} ,  //t 124: 5 kulmaa(6,5,4,3,2)
    { 7, 6,11, 1, 9, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //t 125: 6 kulmaa(6,5,4,3,2,0)
    { 6,11, 3, 6, 3, 0, 6, 0, 8, 6, 8, 7,-1,-1,-1} ,  //x 126: 6 kulmaa(6,5,4,3,2,1)
    { 7, 6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 127: 7 kulmaa(6,5,4,3,2,1,0)
    {11, 6, 7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 128: 1 kulma (7)
    {11, 6, 7, 3, 8, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 129: 2 kulmaa(7,0)
    {11, 6, 7, 1, 0, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 130: 2 kulmaa(7,1)
    {11, 6, 7, 3, 8, 9, 3, 9, 1,-1,-1,-1,-1,-1,-1} ,  //x 131: 3 kulmaa(7,1,0)
    {11, 6, 7, 2, 1,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 132: 2 kulmaa(7,2)
    {11, 6, 7, 3, 8, 0, 2, 1,10,-1,-1,-1,-1,-1,-1} ,  //y 133: 3 kulmaa(7,2,0)
    {11, 6, 7, 0, 9,10, 0,10, 2,-1,-1,-1,-1,-1,-1} ,  //y 134: 3 kulmaa(7,2,1)
    {11, 6, 7, 9,10, 2, 9, 2, 3, 9, 3, 8,-1,-1,-1} ,  //y 135: 4 kulmaa(7,2,1,0)
    { 2, 6, 7, 2, 7, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 136: 2 kulmaa(7,3)
    { 2, 6, 7, 2, 7, 8, 2, 8, 0,-1,-1,-1,-1,-1,-1} ,  //x 137: 3 kulmaa(7,3,0)
    { 2, 6, 7, 2, 7, 3, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //x 138: 3 kulmaa(7,3,1)
    { 8, 9, 7, 7, 9, 6, 6, 9, 1, 6, 1, 2,-1,-1,-1} ,  //x 139: 4 kulmaa(7,3,1,0)
    { 3, 1,10, 3,10, 6, 3, 6, 7,-1,-1,-1,-1,-1,-1} ,  //x 140: 3 kulmaa(7,3,2)
    { 7, 8, 0, 7, 0, 6, 1, 6, 0, 1,10, 6,-1,-1,-1} ,  //x 141: 4 kulmaa(7,3,2,0)
    { 3, 0, 7, 7, 0, 9, 7, 9, 6, 6, 9,10,-1,-1,-1} ,  //t 142: 4 kulmaa(7,3,2,1)
    { 9,10, 6, 9, 6, 7, 9, 7, 8,-1,-1,-1,-1,-1,-1} ,  //x 143: 5 kulmaa(7,3,2,1,0)
    {11, 4, 8,11, 6, 4,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 144: 2 kulmaa(7,4)
    { 4, 0, 3, 4, 3,11, 4,11, 6,-1,-1,-1,-1,-1,-1} ,  //x 145: 3 kulmaa(7,4,0)
    {11, 4, 8,11, 6, 4, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //t 146: 3 kulmaa(7,4,1)
    { 3,11, 1,11, 6, 1, 1, 6, 9, 4, 9, 6,-1,-1,-1} ,  //x 147: 4 kulmaa(7,4,1,0)
    {11, 4, 8,11, 6, 4, 2, 1,10,-1,-1,-1,-1,-1,-1} ,  //x 148: 3 kulmaa(7,4,2)
    { 4, 0, 3, 4, 3,11, 4,11, 6, 2, 1,10,-1,-1,-1} ,  //t 149: 4 kulmaa(7,4,2,0)
    {11, 4, 8,11, 6, 4, 0, 9,10, 0,10, 2,-1,-1,-1} ,  //y 150: 4 kulmaa(7,4,2,1)
    { 9,10, 2, 9, 2, 3, 9, 3, 4, 4, 3,10, 4,10, 6} ,  //t 151: 5 kulmaa(7,4,2,1,0)
    { 6, 4, 8, 6, 8, 3, 6, 3, 2,-1,-1,-1,-1,-1,-1} ,  //x 152: 3 kulmaa(7,4,3)
    { 0, 2, 6, 0, 6, 4,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 153: 4 kulmaa(7,4,3,0)
    { 6, 4, 8, 6, 8, 3, 6, 3, 2, 1, 0, 9,-1,-1,-1} ,  //x 154: 4 kulmaa(7,4,3,1)
    { 6, 4, 9, 6, 9, 1, 6, 1, 2,-1,-1,-1,-1,-1,-1} ,  //x 155: 5 kulmaa(7,4,3,1,0)
    { 3, 4, 8, 3, 1, 4, 1, 6, 4, 1,10, 6,-1,-1,-1} ,  //x 156: 4 kulmaa(7,4,3,2)
    { 6, 1,10, 6, 0, 1, 6, 4, 0,-1,-1,-1,-1,-1,-1} ,  //t 157: 5 kulmaa(7,4,3,2,0)
    {10, 0, 9,10, 3, 0, 6, 4, 8, 6, 8, 3, 6, 3,10} ,  //t 158: 5 kulmaa(7,4,3,2,1)
    { 4,10, 6, 4, 9,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 159: 6 kulmaa(7,4,3,2,1,0)
    {11, 6, 7, 4, 5, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 160: 2 kulmaa(7,5)
    {11, 6, 7, 4, 5, 9, 3, 8, 0,-1,-1,-1,-1,-1,-1} ,  //y 161: 3 kulmaa(7,5,0)
    {11, 6, 7, 4, 5, 1, 4, 1, 0,-1,-1,-1,-1,-1,-1} ,  //y 162: 3 kulmaa(7,5,1)
    {11, 6, 7, 1, 3, 8, 1, 8, 4, 1, 4, 5,-1,-1,-1} ,  //y 163: 4 kulmaa(7,5,1,0)
    {11, 6, 7, 4, 5, 9, 2, 1,10,-1,-1,-1,-1,-1,-1} ,  //y 164: 3 kulmaa(7,5,2)
    {11, 6, 7, 4, 5, 9, 2, 1,10, 3, 8, 0,-1,-1,-1} ,  //y 165: 4 kulmaa(7,5,2,0)
    {11, 6, 7, 0, 4, 5, 0, 5,10, 0,10, 2,-1,-1,-1} ,  //y 166: 4 kulmaa(7,5,2,1)
    {11, 6, 7, 2, 3, 8, 2, 8, 4, 2, 4,10,10, 4, 5} ,  //y 167: 5 kulmaa(7,5,2,1,0)
    { 2, 6, 7, 2, 7, 3, 4, 5, 9,-1,-1,-1,-1,-1,-1} ,  //y 168: 3 kulmaa(7,5,3)
    { 2, 6, 7, 2, 7, 8, 2, 8, 0, 4, 5, 9,-1,-1,-1} ,  //y 169: 4 kulmaa(7,5,3,0)
    { 2, 6, 7, 2, 7, 3, 4, 5, 1, 4, 1, 0,-1,-1,-1} ,  //y 170: 4 kulmaa(7,5,3,1)
    { 4, 5, 1, 4, 1, 8, 8, 1, 2, 8, 2, 7, 7, 2, 6} ,  //t 171: 5 kulmaa(7,5,3,1,0)
    { 3, 1,10, 3,10, 6, 3, 6, 7, 4, 5, 9,-1,-1,-1} ,  //y 172: 4 kulmaa(7,5,3,2)
    { 7, 8, 0, 7, 0, 6, 1, 6, 0, 1,10, 6, 4, 5, 9} ,  //y 173: 5 kulmaa(7,5,3,2,0)
    { 0, 4, 5, 0, 5,10, 0,10, 3, 3,10, 6, 3, 6, 7} ,  //t 174: 5 kulmaa(7,5,3,2,1)
    { 5,10, 6, 5, 6, 7, 5, 7, 4, 4, 7, 8,-1,-1,-1} ,  //x 175: 6 kulmaa(7,5,3,2,1,0)
    { 8,11, 6, 8, 6, 5, 8, 5, 9,-1,-1,-1,-1,-1,-1} ,  //x 176: 3 kulmaa(7,5,4)
    {11, 0, 3,11, 9, 0,11, 6, 9, 6, 5, 9,-1,-1,-1} ,  //x 177: 4 kulmaa(7,5,4,0)
    {11, 0, 8,11, 6, 0, 6, 1, 0, 6, 5, 1,-1,-1,-1} ,  //x 178: 4 kulmaa(7,5,4,1)
    { 1, 6, 5, 1,11, 6, 1, 3,11,-1,-1,-1,-1,-1,-1} ,  //x 179: 5 kulmaa(7,5,4,1,0)
    { 8,11, 6, 8, 6, 5, 8, 5, 9, 2, 1,10,-1,-1,-1} ,  //y 180: 4 kulmaa(7,5,4,2)
    {11, 0, 3,11, 9, 0,11, 6, 9, 6, 5, 9, 2, 1,10} ,  //y 181: 5 kulmaa(7,5,4,2,0)
    {10, 2, 0,10, 0, 5, 5, 0, 8, 5, 8, 6, 6, 8,11} ,  //t 182: 5 kulmaa(7,5,4,2,1)
    { 5,10, 6, 6,10, 2, 6, 2,11, 2, 3,11,-1,-1,-1} ,  //y 183: 6 kulmaa(7,5,4,2,1,0)
    { 2, 8, 3, 2, 9, 8, 2, 6, 9, 6, 5, 9,-1,-1,-1} ,  //y 184: 4 kulmaa(7,5,4,3)
    { 2, 9, 0, 2, 5, 9, 2, 6, 5,-1,-1,-1,-1,-1,-1} ,  //y 185: 5 kulmaa(7,5,4,3,0)
    { 3, 0, 8, 3, 2, 1, 3, 1, 0, 2, 6, 5, 2, 5, 1} ,  //y 186: 5 kulmaa(7,5,4,3,1)
    { 6, 1, 2, 6, 5, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 187: 6 kulmaa(7,5,4,3,1,0)
    { 5, 6,10, 3, 8, 9, 3, 9, 1, 9, 5,10, 9,10, 1} ,  //t 188: 5 kulmaa(7,5,4,3,2)
    { 5,10, 6, 5, 1,10, 5, 9, 1, 1, 9, 0,-1,-1,-1} ,  //y 189: 6 kulmaa(7,5,4,3,2,0)
    { 5,10, 6, 3, 0, 8,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 190: 6 kulmaa(7,5,4,3,2,1)
    { 5,10, 6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 191: 7 kulmaa(7,5,4,3,2,1,0)
    {11, 5, 7,11,10, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 192: 2 kulmaa(7,6)
    {11, 5, 7,11,10, 5, 3, 8, 0,-1,-1,-1,-1,-1,-1} ,  //y 193: 3 kulmaa(7,6,0)
    {11, 5, 7,11,10, 5, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //y 194: 3 kulmaa(7,6,1)
    {11, 5, 7,11,10, 5, 3, 8, 9, 3, 9, 1,-1,-1,-1} ,  //y 195: 4 kulmaa(7,6,1,0)
    { 5, 2, 1, 5,11, 2, 5, 7,11,-1,-1,-1,-1,-1,-1} ,  //x 196: 3 kulmaa(7,6,2)
    { 5, 2, 1, 5,11, 2, 5, 7,11, 3, 8, 0,-1,-1,-1} ,  //y 197: 4 kulmaa(7,6,2,0)
    { 7,11, 2, 7, 2, 0, 7, 0, 5, 0, 9, 5,-1,-1,-1} ,  //y 198: 4 kulmaa(7,6,2,1)
    { 8, 5, 7, 8, 9, 5, 2, 3,11, 3, 8, 7, 3, 7,11} ,  //t 199: 5 kulmaa(7,6,2,1,0)
    { 7, 3, 2, 7, 2,10, 7,10, 5,-1,-1,-1,-1,-1,-1} ,  //y 200: 3 kulmaa(7,6,3)
    { 5, 2,10, 5, 0, 2, 5, 7, 0, 0, 7, 8,-1,-1,-1} ,  //y 201: 4 kulmaa(7,6,3,0)
    { 7, 3, 2, 7, 2,10, 7,10, 5, 1, 0, 9,-1,-1,-1} ,  //y 202: 4 kulmaa(7,6,3,1)
    { 8, 5, 7, 8, 9, 5, 2,10, 1, 1, 5, 9, 1,10, 5} ,  //t 203: 5 kulmaa(7,6,3,1,0)
    { 3, 5, 7, 3, 1, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 204: 4 kulmaa(7,6,3,2)
    { 5, 0, 1, 5, 8, 0, 5, 7, 8,-1,-1,-1,-1,-1,-1} ,  //y 205: 5 kulmaa(7,6,3,2,0)
    { 7, 9, 5, 7, 0, 9, 7, 3, 0,-1,-1,-1,-1,-1,-1} ,  //y 206: 5 kulmaa(7,6,3,2,1)
    { 8, 5, 7, 8, 9, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 207: 6 kulmaa(7,6,3,2,1,0)
    {11, 4, 8,11, 5, 4,11,10, 5,-1,-1,-1,-1,-1,-1} ,  //x 208: 3 kulmaa(7,6,4)
    {11, 0, 3,11, 4, 0,11,10, 4,10, 5, 4,-1,-1,-1} ,  //x 209: 4 kulmaa(7,6,4,0)
    {11, 4, 8,11, 5, 4,11,10, 5, 1, 0, 9,-1,-1,-1} ,  //y 210: 4 kulmaa(7,6,4,1)
    {11,10, 5,11, 5, 4,11, 4, 3, 3, 4, 9, 3, 9, 1} ,  //t 211: 5 kulmaa(7,6,4,1,0)
    { 8, 5, 4, 8, 1, 5, 8,11, 1,11, 2, 1,-1,-1,-1} ,  //y 212: 4 kulmaa(7,6,4,2)
    { 4, 1, 5, 4, 0, 1, 2, 3,11, 0, 3, 1, 3, 2, 1} ,  //t 213: 5 kulmaa(7,6,4,2,0)
    { 4, 9, 5, 2, 8,11, 2, 0, 8, 8, 0, 9, 8, 9, 4} ,  //t 214: 5 kulmaa(7,6,4,2,1)
    { 4, 9, 5, 2, 3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 215: 6 kulmaa(7,6,4,2,1,0)
    { 2, 8, 3, 2, 4, 8, 2,10, 4,10, 5, 4,-1,-1,-1} ,  //y 216: 4 kulmaa(7,6,4,3)
    { 0, 5, 4, 0,10, 5, 0, 2,10,-1,-1,-1,-1,-1,-1} ,  //y 217: 5 kulmaa(7,6,4,3,0)
    { 4, 9, 5, 2,10, 1, 3, 0, 8,-1,-1,-1,-1,-1,-1} ,  //y 218: 5 kulmaa(7,6,4,3,1)
    { 4, 9, 5, 9, 1,10, 9,10, 5, 2,10, 1,-1,-1,-1} ,  //y 219: 6 kulmaa(7,6,4,3,1,0)
    { 1, 8, 3, 1, 4, 8, 1, 5, 4,-1,-1,-1,-1,-1,-1} ,  //y 220: 5 kulmaa(7,6,4,3,2)
    { 4, 1, 5, 4, 0, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 221: 6 kulmaa(7,6,4,3,2,0)
    { 3, 0, 8, 8, 0, 4, 4, 0, 9, 4, 9, 5,-1,-1,-1} ,  //y 222: 6 kulmaa(7,6,4,3,2,1)
    { 4, 9, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 223: 7 kulmaa(7,6,4,3,2,1,0)
    {10, 7,11,10, 4, 7,10, 9, 4,-1,-1,-1,-1,-1,-1} ,  //x 224: 3 kulmaa(7,6,5)
    {10, 7,11,10, 4, 7,10, 9, 4, 3, 8, 0,-1,-1,-1} ,  //y 225: 4 kulmaa(7,6,5,0)
    {11, 4, 7,11, 0, 4,11, 1, 0,11,10, 1,-1,-1,-1} ,  //y 226: 4 kulmaa(7,6,5,1)
    { 4, 7, 8, 3,10, 1, 3,11,10, 3, 8, 7, 3, 7,11} ,  //t 227: 5 kulmaa(7,6,5,1,0)
    { 1,11, 2, 1, 7,11, 1, 9, 7, 9, 4, 7,-1,-1,-1} ,  //y 228: 4 kulmaa(7,6,5,2)
    { 1,11, 2, 1, 7,11, 1, 9, 7, 9, 4, 7, 3, 8, 0} ,  //y 229: 5 kulmaa(7,6,5,2,0)
    { 0,11, 2, 0, 7,11, 0, 4, 7,-1,-1,-1,-1,-1,-1} ,  //y 230: 5 kulmaa(7,6,5,2,1)
    { 4, 7, 8, 8, 7,11, 8,11, 3, 2, 3,11,-1,-1,-1} ,  //y 231: 6 kulmaa(7,6,5,2,1,0)
    { 2, 7, 3, 2, 4, 7, 2, 9, 4, 2,10, 9,-1,-1,-1} ,  //y 232: 4 kulmaa(7,6,5,3)
    { 4, 7, 8, 0,10, 9, 0, 2,10, 8, 0, 9, 8, 0, 4} ,  //t 233: 5 kulmaa(7,6,5,3,0)
    { 7, 0, 4, 7, 3, 0, 2,10, 1, 0, 3, 1, 3, 2, 1} ,  //t 234: 5 kulmaa(7,6,5,3,1)
    { 4, 7, 8, 2,10, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 235: 6 kulmaa(7,6,5,3,1,0)
    { 3, 4, 7, 3, 9, 4, 3, 1, 9,-1,-1,-1,-1,-1,-1} ,  //y 236: 5 kulmaa(7,6,5,3,2)
    { 4, 7, 8, 4, 8, 9, 8, 7, 9, 1, 9, 0,-1,-1,-1} ,  //y 237: 6 kulmaa(7,6,5,3,2,0)
    { 7, 0, 4, 7, 3, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 238: 6 kulmaa(7,6,5,3,2,1)
    { 4, 7, 8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 239: 7 kulmaa(7,6,5,3,2,1,0)
    { 8,10, 9, 8,11,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //x 240: 4 kulmaa(7,6,5,4)
    {10, 3,11,10, 0, 3,10, 9, 0,-1,-1,-1,-1,-1,-1} ,  //y 241: 5 kulmaa(7,6,5,4,0)
    {11, 0, 8,11, 1, 0,11,10, 1,-1,-1,-1,-1,-1,-1} ,  //y 242: 5 kulmaa(7,6,5,4,1)
    { 3,10, 1, 3,11,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 243: 6 kulmaa(7,6,5,4,1,0)
    { 8, 1, 9, 8, 2, 1, 8,11, 2,-1,-1,-1,-1,-1,-1} ,  //y 244: 5 kulmaa(7,6,5,4,2)
    { 2, 3,11, 1, 9, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 245: 6 kulmaa(7,6,5,4,2,0)
    { 2, 8,11, 2, 0, 8,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 246: 6 kulmaa(7,6,5,4,2,1)
    { 2, 3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 247: 7 kulmaa(7,6,5,4,2,1,0)
    { 9, 2,10, 9, 3, 2, 9, 8, 3,-1,-1,-1,-1,-1,-1} ,  //y 248: 5 kulmaa(7,6,5,4,3)
    { 0,10, 9, 0, 2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 249: 6 kulmaa(7,6,5,4,3,0)
    { 3, 0, 8, 2,10, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 250: 6 kulmaa(7,6,5,4,3,1)
    { 2,10, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 251: 7 kulmaa(7,6,5,4,3,1,0)
    { 3, 9, 8, 3, 1, 9,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 252: 6 kulmaa(7,6,5,4,3,2)
    { 1, 9, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 253: 7 kulmaa(7,6,5,4,3,2,0)
    { 3, 0, 8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //y 254: 7 kulmaa(7,6,5,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}    //x 255: 8 kulmaa(7,6,5,4,3,2,1,0)
};
/*

// vanhempi table missa osa on tyhjia koska ne on negatoitu.
#define MAXKOLMIOT 12
const int table[256][MAXKOLMIOT] = {
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //   0: 0 kulmaa
    { 0, 8, 3,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //   1: 1 kulma (0)
    { 0, 9, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //   2: 1 kulma (1)
    { 1, 3, 8, 1, 8, 9,-1,-1,-1,-1,-1,-1} ,  //   3: 2 kulmaa(1,0)
    { 2, 1,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //   4: 1 kulma (2)
    { 0, 8, 3, 2, 1,10,-1,-1,-1,-1,-1,-1} ,  //   5: 2 kulmaa(2,0)
    { 0, 9,10, 0,10, 2,-1,-1,-1,-1,-1,-1} ,  //   6: 2 kulmaa(2,1)
    { 2, 3, 8, 2, 8, 9, 2, 9,10,-1,-1,-1} ,  //   7: 3 kulmaa(2,1,0)
    { 2, 3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //   8: 1 kulma (3)
    { 2,11, 8, 2, 8, 0,-1,-1,-1,-1,-1,-1} ,  //   9: 2 kulmaa(3,0)
    { 2, 3,11, 0, 9, 1,-1,-1,-1,-1,-1,-1} ,  //  10: 2 kulmaa(3,1)
    { 1, 2,11, 1,11, 8, 1, 8, 9,-1,-1,-1} ,  //  11: 3 kulmaa(3,1,0)
    { 3, 1,10, 3,10,11,-1,-1,-1,-1,-1,-1} ,  //  12: 2 kulmaa(3,2)
    {11, 8, 0,11, 0, 1,11, 1,10,-1,-1,-1} ,  //  13: 3 kulmaa(3,2,0)
    {10,11, 3,10, 3, 0,10, 0, 9,-1,-1,-1} ,  //  14: 3 kulmaa(3,2,1)
    { 8, 9,10, 8,10,11,-1,-1,-1,-1,-1,-1} ,  //  15: 4 kulmaa(3,2,1,0)
    { 8, 4, 7,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  16: 1 kulma (4)
    { 3, 0, 4, 3, 4, 7,-1,-1,-1,-1,-1,-1} ,  //  17: 2 kulmaa(4,0)
    { 8, 4, 7, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //  18: 2 kulmaa(4,1)
    { 3, 1, 9, 3, 9, 4, 3, 4, 7,-1,-1,-1} ,  //  19: 3 kulmaa(4,1,0)
    { 8, 4, 7, 1, 2,10,-1,-1,-1,-1,-1,-1} ,  //  20: 2 kulmaa(4,2)
    { 3, 0, 4, 3, 4, 7, 1, 2,10,-1,-1,-1} ,  //  21: 3 kulmaa(4,2,0)
    { 8, 4, 7, 0, 9,10, 0,10, 2,-1,-1,-1} ,  //  22: 3 kulmaa(4,2,1)
    { 2, 3, 7, 2, 7, 4, 2, 4, 9, 2, 9,10} ,  //  23: 4 kulmaa(4,2,1,0)
    { 8, 4, 7, 2, 3,11,-1,-1,-1,-1,-1,-1} ,  //  24: 2 kulmaa(4,3)
    { 0, 4, 7, 0, 7,11, 0,11, 2,-1,-1,-1} ,  //  25: 3 kulmaa(4,3,0)
    { 8, 4, 7, 2, 3,11, 1, 7, 9,-1,-1,-1} ,  //  26: 3 kulmaa(4,3,1)
    { 1, 2,11, 1,11, 7, 1, 7, 4, 1, 4, 9} ,  //  27: 4 kulmaa(4,3,1,0)
    { 3,11,10, 3,10, 1, 8, 7, 4,-1,-1,-1} ,  //  28: 3 kulmaa(4,3,2)
    {11,10, 1, 1,11, 0, 0,11, 7, 0, 7, 4} ,  // {11,10, 1,11, 1, 0,11, 0, 4,-1,-1,-1} ,  //  29: 4 kulmaa(4,3,2,0)
    { 0, 3,11, 0,11,10, 0,10, 9, 8, 4, 7} ,  //  30: 4 kulmaa(4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  31: 5 kulmaa(4,3,2,1,0)
    { 4, 9, 5,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  32: 1 kulma (5)
    { 4, 9, 5, 0, 8, 3,-1,-1,-1,-1,-1,-1} ,  //  33: 2 kulmaa(5,0)
    { 4, 5, 1, 4, 1, 0,-1,-1,-1,-1,-1,-1} ,  //  34: 2 kulmaa(5,1)
    { 1, 3, 8, 1, 8, 4, 1, 4, 5,-1,-1,-1} ,  //  35: 3 kulmaa(5,1,0)
    { 4, 9, 5, 2, 1,10,-1,-1,-1,-1,-1,-1} ,  //  36: 2 kulmaa(5,2)
    { 4, 9, 5, 2, 1,10, 0, 8, 3,-1,-1,-1} ,  //  37: 3 kulmaa(5,2,0)
    { 0, 4, 5, 0, 5,10, 0,10, 2,-1,-1,-1} ,  //  38: 3 kulmaa(5,2,1)
    { 4, 5,10, 4,10, 2, 4, 2, 3, 4, 3, 8} ,  //  39: 4 kulmaa(5,2,1,0)
    { 4, 9, 5, 2, 3,11,-1,-1,-1,-1,-1,-1} ,  //  40: 2 kulmaa(5,3)
    { 4, 9, 5, 2,11, 8, 2, 8, 0,-1,-1,-1} ,  //  41: 3 kulmaa(5,3,0)
    { 4, 5, 1, 4, 1, 0, 2, 3,11,-1,-1,-1} ,  //  42: 3 kulmaa(5,3,1)
    { 1, 2,11, 1,11, 8, 1, 8, 4, 1, 4, 5} ,  //  43: 4 kulmaa(5,3,1,0)
    { 4, 9, 5, 3, 1,10, 3,10,11,-1,-1,-1} ,  //  44: 3 kulmaa(5,3,2)
    { 4, 9, 5,11, 8, 0,11, 0, 1,11, 1,10} ,  //  45: 4 kulmaa(5,3,2,0)
    {11, 3, 0,11, 0, 4,11, 4, 5,11, 5,10} ,  //  46: 4 kulmaa(5,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  47: 5 kulmaa(5,3,2,1,0)
    { 8, 9, 5, 8, 5, 7,-1,-1,-1,-1,-1,-1} ,  //  48: 2 kulmaa(5,4)
    { 7, 3, 0, 7, 0, 9, 7, 9, 5,-1,-1,-1} ,  //  49: 3 kulmaa(5,4,0)
    { 5, 1, 0, 5, 0, 8, 5, 8, 7,-1,-1,-1} ,  //  50: 3 kulmaa(5,4,1)
    { 3, 7, 5, 3, 5, 1,-1,-1,-1,-1,-1,-1} ,  //  51: 4 kulmaa(5,4,1,0)
    { 8, 9, 5, 8, 5, 7, 1, 2,10,-1,-1,-1} ,  //  52: 3 kulmaa(5,4,2)
    { 7, 3, 0, 7, 0, 9, 7, 9, 5, 1, 2,10} ,  //  53: 4 kulmaa(5,4,2,0)
    {10, 2, 0,10, 0, 8,10, 8, 7,10, 7, 5} ,  //  54: 4 kulmaa(5,4,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  55: 5 kulmaa(5,4,2,1,0)
    { 8, 9, 5, 8, 5, 7, 2, 3,11,-1,-1,-1} ,  //  56: 3 kulmaa(5,4,3)
    { 0, 9, 5, 0, 5, 7, 0, 7,11, 0,11, 2} ,  //  57: 4 kulmaa(5,4,3,0)
    { 5, 1, 0, 5, 0, 8, 5, 8, 7, 2, 3,11} ,  //  58: 4 kulmaa(5,4,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  59: 5 kulmaa(5,4,3,1,0)
    { 8, 9, 5, 8, 5, 7, 3, 1,10, 3,10,11} ,  //  60: 4 kulmaa(5,4,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  61: 5 kulmaa(5,4,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  62: 5 kulmaa(5,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  63: 6 kulmaa(5,4,3,2,1,0)
    { 6, 5,10,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  64: 1 kulma (6)
    { 6, 5,10, 0, 3, 8,-1,-1,-1,-1,-1,-1} ,  //  65: 2 kulmaa(6,0)
    { 6, 5,10, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  //  66: 2 kulmaa(6,1)
    { 6, 5,10, 1, 3, 8, 1, 8, 9,-1,-1,-1} ,  //  67: 3 kulmaa(6,1,0)
    { 6, 5, 1, 6, 1, 2,-1,-1,-1,-1,-1,-1} ,  //  68: 2 kulmaa(6,2)
    { 6, 5, 1, 6, 1, 2, 0, 8, 3,-1,-1,-1} ,  //  69: 3 kulmaa(6,2,0)
    { 2, 0, 9, 2, 9, 5, 2, 5, 6,-1,-1,-1} ,  //  70: 3 kulmaa(6,2,1)
    { 8, 9, 5, 8, 5, 6, 8, 6, 2, 8, 2, 3} ,  //  71: 4 kulmaa(6,2,1,0)
    { 6, 5,10, 2, 3,11,-1,-1,-1,-1,-1,-1} ,  //  72: 2 kulmaa(6,3)
    { 6, 5,10, 2,11, 8, 2, 8, 0,-1,-1,-1} ,  //  73: 3 kulmaa(6,3,0)
    { 6, 5,10, 2, 3,11, 0, 1, 9,-1,-1,-1} ,  //  74: 3 kulmaa(6,3,1)
    { 6, 5,10, 1, 2,11, 1,11, 8, 1, 8, 9} ,  //  75: 4 kulmaa(6,3,1,0)
    { 1, 3,11, 1,11, 6, 1, 6, 5,-1,-1,-1} ,  //  76: 3 kulmaa(6,3,2)
    {11, 8, 0,11, 0, 1,11, 1, 5,11, 5, 6} ,  //  77: 4 kulmaa(6,3,2,0)
    { 9, 5, 6, 9, 6,11,11, 3, 0,11, 0, 9} ,  //  78: 4 kulmaa(6,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  79: 5 kulmaa(6,3,2,1,0)
    { 6, 5,10, 8, 4, 7,-1,-1,-1,-1,-1,-1} ,  //  80: 2 kulmaa(6,4)
    { 6, 5,10, 3, 0, 4, 3, 4, 7,-1,-1,-1} ,  //  81: 3 kulmaa(6,4,0)
    { 6, 5,10, 8, 4, 7, 1, 0, 9,-1,-1,-1} ,  //  82: 3 kulmaa(6,4,1)
    { 6, 5,10, 3, 1, 9, 3, 9, 4, 3, 4, 7} ,  //  83: 4 kulmaa(6,4,1,0)
    { 6, 5, 1, 6, 1, 2, 8, 4, 7,-1,-1,-1} ,  //  84: 3 kulmaa(6,4,2)
    { 6, 5, 1, 6, 1, 2, 3, 0, 4, 3, 4, 7} ,  //  85: 4 kulmaa(6,4,2,0)
    { 2, 0, 9, 2, 9, 5, 2, 5, 6, 8, 4, 7} ,  //  86: 4 kulmaa(6,4,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  87: 5 kulmaa(6,4,2,1,0)
    { 6, 5,10, 8, 4, 7, 2, 3,11,-1,-1,-1} ,  //  88: 3 kulmaa(6,4,3)
    { 6, 5,10, 0, 4, 7, 0, 7,11, 0,11, 2} ,  //  89: 4 kulmaa(6,4,3,0)
    { 6, 5,10, 8, 4, 7, 2, 3,11, 1, 0, 9} ,  //  90: 4 kulmaa(6,4,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  91: 5 kulmaa(6,4,3,1,0)
    { 1, 3,11, 1,11, 6, 1, 6, 5, 8, 4, 7} ,  //  92: 4 kulmaa(6,4,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  93: 5 kulmaa(6,4,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  94: 5 kulmaa(6,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  //  95: 6 kulmaa(6,4,3,2,1,0)
    { 6, 4, 9, 6, 9,10,-1,-1,-1,-1,-1,-1} ,  //  96: 2 kulmaa(6,5)
    { 6, 4, 9, 6, 9,10, 8, 0, 3,-1,-1,-1} ,  //  97: 3 kulmaa(6,5,0)
    { 6,10, 1, 6, 1, 0, 6, 0, 4,-1,-1,-1} ,  //  98: 3 kulmaa(6,5,1)
    { 1, 6,10, 1, 4, 6, 1, 3, 4, 3, 8, 4} ,  //  99: 4 kulmaa(6,5,1,0)
    { 6, 2, 1, 6, 1, 9, 6, 9, 4,-1,-1,-1} ,  // 100: 3 kulmaa(6,5,2)
    { 6, 2, 1, 6, 1, 9, 6, 9, 4, 8, 0, 3} ,  // 101: 4 kulmaa(6,5,2,0)
    { 6, 2, 0, 6, 0, 4,-1,-1,-1,-1,-1,-1} ,  // 102: 4 kulmaa(6,5,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 103: 5 kulmaa(6,5,2,1,0)
    { 6, 4, 9, 6, 9,10, 2, 3,11,-1,-1,-1} ,  // 104: 3 kulmaa(6,5,3)
    { 6, 4, 9, 6, 9,10, 2,11, 8, 2, 8, 0} ,  // 105: 4 kulmaa(6,5,3,0)
    { 6,10, 1, 6, 1, 0, 6, 0, 4, 2, 3,11} ,  // 106: 4 kulmaa(6,5,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 107: 5 kulmaa(6,5,3,1,0)
    {11, 3, 1,11, 1, 6, 1, 6, 9, 6, 9, 4} ,  // 108: 4 kulmaa(6,5,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 109: 5 kulmaa(6,5,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 110: 5 kulmaa(6,5,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 111: 6 kulmaa(6,5,3,2,1,0)
    { 9,10, 6, 9, 6, 7, 9, 7, 8,-1,-1,-1} ,  // 112: 3 kulmaa(6,5,4)
    { 3, 0, 7, 7, 0, 9, 7, 9, 6, 6, 9,10} ,  // 113: 4 kulmaa(6,5,4,0)
    { 0, 8, 7, 0, 7, 1, 1, 7, 6, 1, 6,10} ,  // 114: 4 kulmaa(6,5,4,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 115: 5 kulmaa(6,5,4,1,0)
    { 8, 7, 9, 7, 6, 9, 6, 9, 1, 2, 6, 1} ,  // 116: 4 kulmaa(6,5,4,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 117: 5 kulmaa(6,5,4,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 118: 5 kulmaa(6,5,4,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 119: 6 kulmaa(6,5,4,2,1,0)
    { 9,10, 6, 9, 6, 7, 9, 7, 8, 2, 3,11} ,  // 120: 4 kulmaa(6,5,4,3)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 121: 5 kulmaa(6,5,4,3,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 122: 5 kulmaa(6,5,4,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 123: 6 kulmaa(6,5,4,3,1,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 124: 5 kulmaa(6,5,4,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 125: 6 kulmaa(6,5,4,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 126: 6 kulmaa(6,5,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 127: 7 kulmaa(6,5,4,3,2,1,0)
    {11, 7, 6,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 128: 1 kulma (7)
    {11, 7, 6, 8, 0, 3,-1,-1,-1,-1,-1,-1} ,  // 129: 2 kulmaa(7,0)
    {11, 7, 6, 1, 0, 9,-1,-1,-1,-1,-1,-1} ,  // 130: 2 kulmaa(7,1)
    {11, 7, 6, 1, 3, 8, 1, 8, 9,-1,-1,-1} ,  // 131: 3 kulmaa(7,1,0)
    {11, 7, 6, 1, 2,10,-1,-1,-1,-1,-1,-1} ,  // 132: 2 kulmaa(7,2)
    {11, 7, 6, 1, 2,10, 8, 0, 3,-1,-1,-1} ,  // 133: 3 kulmaa(7,2,0)
    {11, 7, 6, 0, 9,10, 0,10, 2,-1,-1,-1} ,  // 134: 3 kulmaa(7,2,1)
    {11, 7, 6, 2, 3, 8, 2, 8, 9, 2, 9,10} ,  // 135: 4 kulmaa(7,2,1,0)
    { 2, 3, 7, 2, 7, 6,-1,-1,-1,-1,-1,-1} ,  // 136: 2 kulmaa(7,3)
    { 2, 0, 8, 2, 8, 7, 2, 7, 6,-1,-1,-1} ,  // 137: 3 kulmaa(7,3,0)
    { 2, 3, 7, 2, 7, 6, 1, 0, 9,-1,-1,-1} ,  // 138: 3 kulmaa(7,3,1)
    { 8, 7, 9, 7, 6, 9, 6, 1, 9, 6, 1, 2} ,  // 139: 4 kulmaa(7,3,1,0)
    { 3, 7, 6, 3, 6,10, 3,10, 1,-1,-1,-1} ,  // 140: 3 kulmaa(7,3,2)
    { 7, 0, 8, 7, 0, 6, 1, 0, 6, 1, 6,10} ,  // 141: 4 kulmaa(7,3,2,0)
    { 3, 7, 0, 7, 0, 9, 7, 6, 9, 6, 9,10} ,  // 142: 4 kulmaa(7,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 143: 5 kulmaa(7,3,2,1,0)
    {11, 8, 4,11, 4, 6,-1,-1,-1,-1,-1,-1} ,  // 144: 2 kulmaa(7,4)
    { 4, 0, 3, 4, 3,11, 4,11, 6,-1,-1,-1} ,  // 145: 3 kulmaa(7,4,0)
    {11, 8, 4,11, 4, 6, 1, 0, 9,-1,-1,-1} ,  // 146: 3 kulmaa(7,4,1)
    { 3, 1,11,11, 1, 6, 1, 6, 9, 4, 6, 9} ,  // 147: 4 kulmaa(7,4,1,0)
    {11, 8, 4,11, 4, 6, 1, 2,10,-1,-1,-1} ,  // 148: 3 kulmaa(7,4,2)
    { 4, 0, 3, 4, 3,11, 4,11, 6, 1, 2,10} ,  // 149: 4 kulmaa(7,4,2,0)
    {11, 8, 4,11, 4, 6, 0, 9,10, 0,10, 2} ,  // 150: 4 kulmaa(7,4,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 151: 5 kulmaa(7,4,2,1,0)
    { 6, 2, 3, 6, 3, 8, 6, 8, 4,-1,-1,-1} ,  // 152: 3 kulmaa(7,4,3)
    { 0, 4, 6, 0, 6, 2,-1,-1,-1,-1,-1,-1} ,  // 153: 4 kulmaa(7,4,3,0)
    { 6, 2, 3, 6, 3, 8, 6, 8, 4, 1, 0, 9} ,  // 154: 4 kulmaa(7,4,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 155: 5 kulmaa(7,4,3,1,0)
    { 3, 8, 1, 1, 8, 4, 1, 4, 6, 1, 6,10} ,  // 156: 4 kulmaa(7,4,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 157: 5 kulmaa(7,4,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 158: 5 kulmaa(7,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 159: 6 kulmaa(7,4,3,2,1,0)
    {11, 7, 6, 4, 5, 9,-1,-1,-1,-1,-1,-1} ,  // 160: 2 kulmaa(7,5)
    {11, 7, 6, 4, 5, 9, 0, 3, 8,-1,-1,-1} ,  // 161: 3 kulmaa(7,5,0)
    {11, 7, 6, 4, 5, 1, 4, 1, 0,-1,-1,-1} ,  // 162: 3 kulmaa(7,5,1)
    {11, 7, 6, 1, 3, 8, 1, 8, 4, 1, 4, 5} ,  // 163: 4 kulmaa(7,5,1,0)
    {11, 7, 6, 4, 5, 9, 1, 2,10,-1,-1,-1} ,  // 164: 3 kulmaa(7,5,2)
    {11, 7, 6, 4, 5, 9, 1, 2,10, 0, 3, 8} ,  // 165: 4 kulmaa(7,5,2,0)
    {11, 7, 6, 0, 4, 5, 0, 5,10, 0,10, 2} ,  // 166: 4 kulmaa(7,5,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 167: 5 kulmaa(7,5,2,1,0)
    { 2, 3, 7, 2, 7, 6, 4, 5, 9,-1,-1,-1} ,  // 168: 3 kulmaa(7,5,3)
    { 2, 0, 8, 2, 8, 7, 2, 7, 6, 4, 5, 9} ,  // 169: 4 kulmaa(7,5,3,0)
    { 2, 3, 7, 2, 7, 6, 4, 5, 1, 4, 1, 0} ,  // 170: 4 kulmaa(7,5,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 171: 5 kulmaa(7,5,3,1,0)
    { 3, 7, 6, 3, 6,10, 3,10, 1, 4, 5, 9} ,  // 172: 4 kulmaa(7,5,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 173: 5 kulmaa(7,5,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 174: 5 kulmaa(7,5,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 175: 6 kulmaa(7,5,3,2,1,0)
    { 8, 9, 5, 8, 5, 6, 8, 6,11,-1,-1,-1} ,  // 176: 3 kulmaa(7,5,4)
    {11, 3, 0,11, 0, 6, 6, 0, 9, 6, 9, 5} ,  // 177: 4 kulmaa(7,5,4,0)
    {11, 8, 0,11, 0, 1,11, 1, 5,11, 5, 6} ,  // { 8, 0,10,10, 0, 1,10, 1, 6, 1, 6, 5} ,  // 178: 4 kulmaa(7,5,4,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 179: 5 kulmaa(7,5,4,1,0)
    { 8, 9, 5, 8, 5, 6, 8, 6,11, 1, 2,10} ,  // 180: 4 kulmaa(7,5,4,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 181: 5 kulmaa(7,5,4,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 182: 5 kulmaa(7,5,4,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 183: 6 kulmaa(7,5,4,2,1,0)
    { 2, 3, 8, 2, 8, 6, 6, 8, 9, 6, 9, 5} ,  // 184: 4 kulmaa(7,5,4,3)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 185: 5 kulmaa(7,5,4,3,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 186: 5 kulmaa(7,5,4,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 187: 6 kulmaa(7,5,4,3,1,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 188: 5 kulmaa(7,5,4,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 189: 6 kulmaa(7,5,4,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 190: 6 kulmaa(7,5,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 191: 7 kulmaa(7,5,4,3,2,1,0)
    {11, 7, 5,11, 5,10,-1,-1,-1,-1,-1,-1} ,  // 192: 2 kulmaa(7,6)
    {11, 7, 5,11, 5,10, 0, 3, 8,-1,-1,-1} ,  // 193: 3 kulmaa(7,6,0)
    {11, 7, 5,11, 5,10, 1, 0, 9,-1,-1,-1} ,  // 194: 3 kulmaa(7,6,1)
    {11, 7, 5,11, 5,10, 1, 3, 8, 1, 8, 9} ,  // 195: 4 kulmaa(7,6,1,0)
    { 5, 1, 2, 5, 2,11, 5,11, 7,-1,-1,-1} ,  // 196: 3 kulmaa(7,6,2)
    { 5, 1, 2, 5, 2,11, 5,11, 7, 8, 0, 3} ,  // 197: 4 kulmaa(7,6,2,0)
    { 9, 5, 7, 9, 7, 0, 7, 0,11,11, 2, 0} ,  // 198: 4 kulmaa(7,6,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 199: 5 kulmaa(7,6,2,1,0)
    { 7, 5,10, 7,10, 2, 7, 2, 3,-1,-1,-1} ,  // 200: 3 kulmaa(7,6,3)
    { 2,10, 5, 2, 5, 0, 5, 0, 7, 7, 0, 8} ,  // 201: 4 kulmaa(7,6,3,0)
    { 7, 3, 0, 7, 0, 9, 7, 9, 5, 2, 7,10} ,   //{ 7, 5,10, 7,10, 2, 7, 2, 3, 8, 0, 3} ,  // 202: 4 kulmaa(7,6,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 203: 5 kulmaa(7,6,3,1,0)
    { 3, 7, 5, 3, 5, 1,-1,-1,-1,-1,-1,-1} ,  // 204: 4 kulmaa(7,6,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 205: 5 kulmaa(7,6,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 206: 5 kulmaa(7,6,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 207: 6 kulmaa(7,6,3,2,1,0)
    {11, 8, 4,11, 4, 5,11, 5,10,-1,-1,-1} ,  // 208: 3 kulmaa(7,6,4)
    { 3, 0,11, 0,11,10,10, 0, 4,10, 4, 5} ,  // 209: 4 kulmaa(7,6,4,0)
    {11, 8, 4,11, 4, 5,11, 5,10, 1, 0, 9} ,  // 210: 4 kulmaa(7,6,4,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 211: 5 kulmaa(7,6,4,1,0)
    { 8, 4, 5, 5,11, 8, 5, 1,11, 1, 2,11} ,  // 212: 4 kulmaa(7,6,4,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 213: 5 kulmaa(7,6,4,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 214: 5 kulmaa(7,6,4,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 215: 6 kulmaa(7,6,4,2,1,0)
    { 2, 3, 8, 2, 8, 4, 2, 4,10, 4, 5,10} ,  // 216: 4 kulmaa(7,6,4,3)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 217: 5 kulmaa(7,6,4,3,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 218: 5 kulmaa(7,6,4,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 219: 6 kulmaa(7,6,4,3,1,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 220: 5 kulmaa(7,6,4,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 221: 6 kulmaa(7,6,4,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 222: 6 kulmaa(7,6,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 223: 7 kulmaa(7,6,4,3,2,1,0)
    {10,11, 7,10, 7, 4,10, 4, 9,-1,-1,-1} ,  // 224: 3 kulmaa(7,6,5)
    {10,11, 7,10, 7, 4,10, 4, 9, 8, 0, 3} ,  // 225: 4 kulmaa(7,6,5,0)
    {11,10, 1, 1,11, 0, 0,11, 7, 0, 7, 4} ,  // 226: 4 kulmaa(7,6,5,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 227: 5 kulmaa(7,6,5,1,0)
    { 1, 2,11, 1,11, 7, 1, 7, 4, 1, 4, 9} ,  // 228: 4 kulmaa(7,6,5,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 229: 5 kulmaa(7,6,5,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 230: 5 kulmaa(7,6,5,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 231: 6 kulmaa(7,6,5,2,1,0)
    { 2, 3, 7, 2, 7, 4, 2, 4, 9, 2, 9,10} ,  // 232: 4 kulmaa(7,6,5,3)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 233: 5 kulmaa(7,6,5,3,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 234: 5 kulmaa(7,6,5,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 235: 6 kulmaa(7,6,5,3,1,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 236: 5 kulmaa(7,6,5,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 237: 6 kulmaa(7,6,5,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 238: 6 kulmaa(7,6,5,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 239: 7 kulmaa(7,6,5,3,2,1,0)
    { 8, 9,10, 8,10,11,-1,-1,-1,-1,-1,-1} ,  // 240: 4 kulmaa(7,6,5,4)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 241: 5 kulmaa(7,6,5,4,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 242: 5 kulmaa(7,6,5,4,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 243: 6 kulmaa(7,6,5,4,1,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 244: 5 kulmaa(7,6,5,4,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 245: 6 kulmaa(7,6,5,4,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 246: 6 kulmaa(7,6,5,4,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 247: 7 kulmaa(7,6,5,4,2,1,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 248: 5 kulmaa(7,6,5,4,3)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 249: 6 kulmaa(7,6,5,4,3,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 250: 6 kulmaa(7,6,5,4,3,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 251: 7 kulmaa(7,6,5,4,3,1,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 252: 6 kulmaa(7,6,5,4,3,2)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 253: 7 kulmaa(7,6,5,4,3,2,0)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1} ,  // 254: 7 kulmaa(7,6,5,4,3,2,1)
    {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}    // 255: 8 kulmaa(7,6,5,4,3,2,1,0)
};
  */

#endif