/*
  fx.c - part of intro
  Copyright (C) 2001, Bekir Osman Keskin <spectre@portent.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "intro.h"

char text_tab[PAGES][10][16] = { {" the flare crew ",
                                  "is back after a ",
                                  "  few years of  ",
                                  "    silence!    ",
                                  "we are back this",
                                  "time under linux",
                                  "with a new intro",
                                  "called          ",
                                  "                ",
                                  "*  bounce it!  *"},
                                 {"code     spectre",
                                  "gfx     violator",
                                  "music  muztanger",
                                  "                ",
                                  "                ",
                                  "it feels good to",
                                  " be back on the ",
                                  "   scene again  ",
                                  "                ",
                                  "                "},
                                 {"  this time we  ",
                                  "will stay alive ",
                                  "  and keep on   ",
                                  "releasing intros",
                                  "demos and other ",
                                  " stuff so keep  ",
                                  "your eyes open  ",
                                  "    people!     ",
                                  "                ",
                                  "                "},
                                 {"greetings fly   ",
                                  "          out to",
                                  " *ecfh*         ",
                                  "        *bliss* ",
                                  "                ",
                                  "altemark.zandman",
                                  " wolfgar.decice ",
                                  "  smoke.avoozl  ",
                                  "   zarq.warp    ",
                                  "                "},
                                 {"and to the rest ",
                                  " of flare crew  ",
                                  "vindicator doze ",
                                  "    and duet    ",
                                  "                ",
                                  " special thanks ",
                                  " to *smoke* who ",
                                  "helped much and ",
                                  "made this intro ",
                                  "   possible!    "},
                                 {" to exit press  ",
                                  "the very magical",
                                  "    any key     ",
                                  "                ",
                                  "or else it will ",
                                  "   now loop!    ",
                                  "                ",
                                  "smile and shine!",
                                  "                ",
                                  "                "}};

char schmap[6] = { '.', '*', ',', '!', '?', '\'' };
uchar text_tcol;
picture *text_font;

float tile_color[3][3] = { { 52.0f, 26.0f, 35.0f },
                           { 42.0f, 22.0f, 33.0f },
                           { 31.0f, 18.0f, 29.0f } };

void fix_tile (picture *tile)
{
  int i, j;

  for (i = 0; i < 4; i++)
  {
    tile->lbuf[i] = (ulong *) malloc (320 * (200 + tile->h) + 4);
  }

  for (j = 0; j < 200 + tile->h; j++)
  {
    for (i = 0; i < 320; i += 20)
    {
      memcpy (((uchar *) tile->lbuf[0]) + (j * 320) + i,
              tile->buffer + (tile->w * (j % tile->h)), tile->w);
    }
  }

  for (i = 1; i < 4; i++)
  {
    memcpy (((uchar *) tile->lbuf[i]) + i, ((uchar *) tile->lbuf[0]),
            320 * (200 + tile->h));
  }
}

void tile (picture *tile, int ofx, int ofy)
{
  int vs, pvs, pao, i = 0, j = 0;

  pvs = (ofy % 20) * 320 + (ofx % 20);
  pao = 3 - (pvs % 4);
  pvs >>= 2;

  memcpy (video.lvscr, tile->lbuf[pao] + pvs, 320 * 200);
}

void tile_fade (int phase)
{
  int i;

  for (i = 0; i < 3; i++)
  {
    video_setcolor (&video, i + 1, (int)((tile_color[i][0] / 64.0f) * phase),
                                   (int)((tile_color[i][1] / 64.0f) * phase),
                                   (int)((tile_color[i][2] / 64.0f) * phase));
  }
}

void show_page (int page, int xofs, int yofs, int ang, int ax, int xr, int yr)
{
  int i, j = 0, k = 0, c = 0;
  uchar ch;

  for (j = 0; j < 10; j++)
  {
    for (i = 0; i < 16; i++)
    {
      ch = text_tab [page][j][i];

      if (ch < 'a' || ch > 'z')
      {
        for (c = 0; c < 6; c++)
        {
          if (ch == schmap[c])
          {
            ch = 97 + 26 + c;
            break;
          }
        }
      }

      ang += ax;
      ang %= 360;

      if (ch != 32)
      {
        copy_shadow_box (xofs - 4 + i * 15 + (int) (costab[ang] * xr),
                         yofs + 8 + j * 13 + (int) (sintab[ang] * yr),
                         ((ch - 97) * 16), 0, 15, 15, text_font);

        copy_box (xofs + i * 15 + (int) (sintab[ang] * xr),
                  yofs + j * 13 + (int) (costab[ang] * yr),
                  ((ch - 97) * 16), 0, 16, 15, text_font);
      }
    }
  }
}
