/*
  intro.c - part of intro
  Copyright (C) 2001, Bekir Osman Keskin <spectre@portent.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#ifdef REALTIME
#include <sched.h>
#endif
#include "intro.h"
#ifdef SOUND_MIKMOD
#include <mikmod.h>
#elif SOUND_FXMP
#include "fxmp/fxmp.h"
#include "fxmp/drv_dsp.h"
#endif

t_video video;

#ifdef REALTIME
/* from ecfh :D */
int go_realtime ()
{
  struct sched_param sp;

  sp.sched_priority = sched_get_priority_min (SCHED_RR);
  if (sched_setscheduler (0, SCHED_RR, &sp))
  {
    printf ("could not enable realtime scheduling, continuing.\n");
    return -1;
  }

  return 0;
}
#endif

int main (int argc, char *argv[])
{
  picture *p_whole, *p_logo, *p_tile, *p_font;
  int nosound = 0, i, a, b, c, pax = 0, ex = 0;
  int page = 0, nextpage = -1, ft = 1;
  float pos = 320.0f, swinglen = 320.0f;
  float pofs = -170.0f, pac = 0.0f;
  ulong frames = 0, phase = 0;
#ifdef SOUND_MIKMOD
  MODULE *xm;
#elif SOUND_FXMP
  xm_module *xm;
#endif

  printf ("\nbOUNCE iT! 1.0  -  flare\n");
  printf ("Copyright (C) 2001, Bekir Osman Keskin, Lars Djerf, Johan Ostrand\n\n");
  printf ("This program is free software; you may redistribute it under the terms of\n");
  printf ("the GNU General Public License. (See the file COPYING for more details).\n");
  printf ("This program has absolutely no warranty.\n\n");

  go_realtime ();
  setenv ("MM_FRAGSIZE", "8", 0);

  video_init (&video);
  make_tabs (320, 200);
  p_whole = load_pcx ("whole.pcx");
  p_font = make_buffer (p_whole, 0, 0, 512, 15, 1);
  p_logo = make_buffer (p_whole, 0, 15, 232, 72, 1);
  p_tile = make_buffer (p_whole, 0, 100, 20, 20, 0);
  fix_tile (p_tile);

  text_tcol = 50;
  text_font = p_font;
  a = 15;
  b = 75;
  c = 90;

  video_setcolor (&video, 1, 0, 0, 0);
  video_setcolor (&video, 2, 0, 0, 0);
  video_setcolor (&video, 3, 0, 0, 0);

#ifdef SOUND_MIKMOD
  MikMod_RegisterAllDrivers ();
  MikMod_RegisterAllLoaders ();
  MikMod_Init ("");
  xm = Player_Load ("music.xm", 8, 0);
  if (!xm) exit (1);
  md_reverb = 0;
  md_mode = DMODE_16BITS | DMODE_STEREO;
  md_mixfreq = 44100;
  xm->wrap = 1;
  Player_Start (xm);
#elif SOUND_FXMP
  if (fxmp_init (&dsp, 0) != 0) nosound = 1;
  if (!nosound)
  {
    xm = xm_load ("music.xm");
    fxmp_load_patches (xm);
    fxmp_play (xm);
  }
#endif

  phase = 400;
  while (!ex || frames > 0)
  {
    if (!ex && ggiKbhit (video.visual))
    {
      ex = 1;
      if (frames > 256) frames = 256;
    }

    a += 1; if (a >= 360) a -= 360;
    b += 2; if (b >= 360) b -= 360;
    c += 2; if (c >= 360) c -= 360;

    tile (p_tile, sintab[a] * 25 + 25 + costab[b] * 25 + 25,
          sintab[b] * 50 + 50 + costab[c] * 20 + 20);

    copy_pic (p_logo, 10 + (int) pos, 120);

    if (frames < 256)
    {
      tile_fade (frames / 4);

      if (ex)
      {
        pofs += (pac += 0.07f);
#ifdef SOUND_MIKMOD
        if (md_musicvolume > 0) md_musicvolume--;
#endif
      }
    }

    if (swinglen > 0.0f)
    {
      pos = sintab[c] * swinglen;
      swinglen -= 0.7f;
    }

    if (pax > 0)
    {
      pofs += sintab[pax--] * 1.746f; /* our magic number */
    }

    if (nextpage >= 0)
    {
      show_page (nextpage, 30, pofs - 200, a * 5, 20, 3, 5);
    }

    show_page (page, 30, pofs, a * 5, 20, 3, 5);

    if (phase == 500 && !ex)
    {
      nextpage = page + 1;
      if (nextpage > PAGES - 1) nextpage = 0;
      pax = 180;
    }
    else if (phase >= 860 && !ex)
    {
      phase = 0;
      if (!ft)
      {
        page = nextpage;
        nextpage = -1;
      }
      else ft = 0;
      pofs = 30.0f;
    }

    phase++;
#ifdef SOUND_MIKMOD
    MikMod_Update ();
#elif SOUND_FXMP
    if (!nosound) fxmp_poll (xm);
#endif
    video_flip (&video);
    if (!ex) frames++; else frames--;
  }

#ifdef SOUND_MIKMOD
  MikMod_Exit ();
#elif SOUND_FXMP
  if (!nosound) fxmp_deinit ();
#endif

  video_deinit (&video);
  return 0;
}
