/*
  pic.h - part of intro
  Copyright (C) 2001, Bekir Osman Keskin <spectre@portent.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PIC_H__
#define __PIC_H__

#include "intro.h"

typedef struct picture
{
  int w, h;
  uchar *buffer;
  ulong *lbuf[4];
}
picture;

picture *load_pcx (char *fn);
picture *make_buffer (picture *source, int x, int y, int w, int h, int multi);
void copy_pic (picture *pic, int x, int y);
void copy_box (int x, int y, int sx, int sy, int sw, int sh, picture *pic);
void copy_shadow_box (int x, int y, int sx, int sy, int sw, int sh,
                      picture *pic);

#endif
