/*
  video.c - part of intro
  Copyright (C) 2001, Bekir Osman Keskin <spectre@portent.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "intro.h"

void video_init (t_video *vid)
{
  if (ggiInit () != 0)
    ggiPanic ("unable to initialize ggi.\n");

  if ((vid->visual = ggiOpen (NULL)) == NULL)
    ggiPanic ("unable to open default visual, exiting.\n");

  if (ggiSetGraphMode (vid->visual, 320, 200, 320, 200, GT_8BIT) < 0)
    ggiPanic ("unable to set mode.\n");

  ggiSetFlags (vid->visual, GGIFLAG_ASYNC);

  if (ggiMiscInit () != 0)
    ggiPanic ("couldn't initialize misc extension\n");

  if (ggiMiscAttach (vid->visual) < 0)
    ggiPanic ("couldn't attach misc extension\n");

  if (!(vid->dbuf = ggiDBGetBuffer (vid->visual, 0)))
  {
    vid->usedb = 0;
  }

  vid->lvscr = (ulong *) malloc (320 * 200);
  vid->vscr = (uchar *) vid->lvscr;
  vid->ggi_rp_x = GGI_RP_DONTCARE;
  vid->ggi_rp_y = GGI_RP_SYNC;
}

void video_flip (t_video *vid)
{
  ggiWaitRayPos (vid->visual, &vid->ggi_rp_x, &vid->ggi_rp_y);
  ggiPutBox (vid->visual, 0, 0, 320, 200, vid->vscr);
  ggiFlush (vid->visual);
}

void video_deinit (t_video *vid)
{
  ggiClose (vid->visual);
  ggiMiscExit ();
  ggiExit ();
}

void video_setcolor (t_video *vid, uchar color, ulong r, ulong g, ulong b)
{
  ggi_color c;
  c.r = r << 10;
  c.g = g << 10;
  c.b = b << 10;
  ggiSetPalette (vid->visual, color, 1, &c);
}
