/*
  video.h - part of intro
  Copyright (C) 2001, Bekir Osman Keskin <spectre@portent.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __VIDEO_H__
#define __VIDEO_H__

#include "intro.h"

typedef struct t_video
{
  ggi_visual_t visual;
  ggi_color palette[256];
  const ggi_directbuffer *dbuf;
  char usedb;
  int ggi_rp_x, ggi_rp_y; 
  uchar *vscr;
  ulong *lvscr; 
  int vsx, vsy;
}
t_video;

void video_init (t_video *vid);
void video_flip (t_video *vid);
void video_deinit (t_video *vid);
void video_setcolor (t_video *vid, uchar color, ulong r, ulong g, ulong b);

#endif
