#!/bin/bash

set -e

function exec {
        echo
        echo $*
        $*
}

export PATH=":$PATH"

CFLAGS="-std=c99" # i use c66 here
CFLAGS="$CFLAGS -Oz -mdynamic-no-pic -fomit-frame-pointer" # basic size opt flags
CFLAGS="$CFLAGS -ffast-math -mfpmath=387 -fsingle-precision-constant" # smaller floating point code & data
CFLAGS="$CFLAGS -fno-optimize-register-move -mtune=i386 -floop-optimize2" # optimizes for compression
CXXFLAGS="$CFLAGS -fno-exceptions -fno-rtti" # not used here but are a must for c++

# Compile
exec gcc $CFLAGS -c main.c -o ngon4k.o

# Default linker
exec gcc ngon4k.o -framework Carbon -framework CoreAudio -framework OpenGL -o ngon4k.unpacked

LSIZE=`wc -c < ngon4k.unpacked`

PERCENT=`bc<<EOF
scale = 2
EOF
`

cat <<EOF

Size uncompressed:
      ld: $LSIZE
EOF
