//TrimDitty

#include <stdlib.h>
#include <stdio.h>

int main(int argc,char *argv[]) {
	char dh[1024];
	char *dd;
	int l;
	FILE * inf;
	FILE * outf;
	printf("TrimDitty Version 1.0\n");
	if (argc<2) {
		printf("\nTrims a save file from the Ditty Editor to the size of the data.\n");
		printf("\nUsage: TrimDitty <inputfile> <outputfile>\n");
		return;
	}
	inf=fopen(argv[1],"rb");
	if(inf==NULL) {
		printf("Cannot open file '%s'!\n",argv[1]);
		return;
	}
	if(fread(dh,1,1024,inf)<1024) {
		printf("Cannot read header.\n");
		fclose(inf);
		return;
	}
	if((*(long *)dh)!=0x59544944) {
		printf("File is not a Ditty.\n");
		fclose(inf);
		return;
	}
	l=*(long *)(dh+4);
	dd=(char*)malloc(l);
	if(dd==NULL) {
		printf("Unable to allocate data buffer.\n");
		fclose(inf);
		return;
	}
	if(fread(dd,1,l,inf)<l) {
		printf("Cannot read data.\n");
		free(dd);
		fclose(inf);
		return;
	}
	fclose(inf);
	outf=fopen(argv[2],"wb");
	if(outf==NULL) {
		printf("Cannot create file '%s'!\n",argv[2]);
		free(dd);
		return;
	}
	if(fwrite(dh,1,1024,outf)<1024) {
		printf("Cannot write header.\n");
		free(dd);
		fclose(outf);
		return;
	}
	if(fwrite(dd, 1, (l + 3) & ~3 , outf) < l) {
		printf("Cannot write data.\n");
		fclose(outf);
		free(dd);
		return;
	}
	free(dd);
	fclose(outf);	
	printf("%i bytes copied from '%s' to '%s'",l+1024,argv[1],argv[2]);
	if(l & 3) printf(" (padded to %i)",(l + 1027) & ~3);
	printf(".\n");
}
