        opt h-
        opt ae+
        opt w-


        MAXPOS:     equ Options       ;MAX. Options



PATCH_GAME            equ $Start Address  ;START ADRESS OF GAME
TRAIN_PATCH           equ $80000210     ;ADRESS OU LE TRAINER EST COPIER
HI_TRAIN_PATCH        equ $8000         ;HI
LOW_TRAIN_PATCH       equ $0210         ;LOW




PATCH_OSVI      equ OSWrite.   ==>> error hab nen fehler gemacht


START_ADD   equ $80310000
        org START_ADD

        li      t0,$Instruction 1         ; Here I Replace the First 4 instructions 
        sw      t0,($)     ; located a 80000400, because it's there
        li      t0,$Instruction 2         ; that I have put the jump in ROM
        sw      t0,($)
        li      t0,$Instruction 3
        sw      t0,($)
        li      t0,$Instruction 4
        sw      t0,($)


;***********************************************************
;Let's go..
;***********************************************************
start:
        li  sp,$80400000        ;Get some Stackspace
        sub sp,sp,512

        li t0, 8
        la  at,$bfc00000
        sw  t0,$7fc(at)     ; PIF Init! IMPORTANT!
        nop

        jal init_vi         ; Init the VideoInterface
        nop

;***********************************************************
;Copy the  (in this case the background-shit) to the
;Videobuffer
;***********************************************************
        la  a0,VIDEOBUFFER+$20000000
        la a1, logo
        la a2, logo_end
logoloop:
        lhu t9, (a1)
        nop
        sh t9, (a0)
        nop
        Add a0, a0, 2
        Add a1, a1, 2
        bne a2, a1, logoloop
        nop

            li  s7,6            ; Init some
            li  s6,0            ; Scroll variables.
            li s1, 0
            li s2, 0
        li s5, 0

        jal scrolly2        ; First call of the
        nop             ; scroll-routine for
                        ; Init stuff..

        la  a1,text1        ; Get the first text.
        jal printtext       ; now print it into the
        nop             ; Videobuffer.


        lhu s0,linesave     ; Draw the Line for
        jal line            ; the option-stuff!
        nop             ; And print it!

   
       
;***********************************************************
;Main Intro-Loop.
;***********************************************************
introloop:
            la      t0,datapad-$80000000    ; Joypad-routine taken
            sw      t0,($a4800000)      ; from Titanik/CZN!
            li      t0,$1fc007c0
            sw      t0,($a4800010)

        jal scrolly2        ; Update scroller.
        nop
        
        jal VSync           ; Do a nice VSync.
        nop

        lw  t0,optdelay     ; Delay the Joypad-routine
        nop             ; Reason: The Optionbar
        add t0,t0,1         ; would be to fast.
        sw t0, optdelay
        nop
        bne t0, 7, introloop
        nop

        sw zero, optdelay
            la      t2,datapad2-$80000000   ; Again some Joypad stuff..
            sw      t2,($a4800000)      ; Getting Pad-Information.
            li      t2,$1fc007c0
            sw      t2,($a4800004)
            lbu     t1,($bfc007ff)
            lhu     t0,($bfc007c4)
            bne t1, zero, loop_reset
            nop
            bne t0, zero, keypress
            nop

            li t2, 1
            sw t2, nokey
keypress:
            lw t2, nokey
            sync
            beq     t2,zero,joy_start      ;noreadkey
            nop

            andi    t1,t0,$0400            ; down ?
        beq t1, zero, w1
        nop

        lhu s0, printftp
        nop
        beq s0, 1, introloop
        nop


        jal linedown


        nop
        beq zero, zero, introloop
        nop
w1:
            andi    t1,t0,$0800            ; up ?
        beq t1, zero, w2
        nop
        lhu s0, printftp
        nop
        beq s0, 1, introloop
        nop

        jal lineup

        nop
        beq zero, zero, introloop
        nop

w2:
            andi    t1,t0,$8100             ; left,B
            beq t1, zero, w3
        nop
       lhu s0, printftp
        nop
        beq s0, 1, introloop
        nop
        jal printyes
        nop
        beq zero, zero, introloop
        nop
w3:
           andi    t1,t0,$4200             ; left,A
            beq t1, zero, w4
        nop
        lhu s0, printftp
        nop
        beq s0, 1, introloop
        nop
        jal printno
        nop
        beq zero, zero, introloop
        nop
w4:
joy_start:
            andi    t1,t0,$1000            ; start ?
            bne     t1,zero,end_intro      ; yes - then QUIT Intro.!
        nop
nokeypress:
            beq     zero,zero,introloop ; Always branch to introloop
            nop
end_intro:

    la   t1,start_add-$30000
        sw   t1,$a4400004

        li   t1,$400
        sw   t1,$a4400034


        
fix_trainer_word
        li t0, 0
        la t1, opt_on_off
        li t4, 0
        li   t5,patch_game ;$80000400
loop_fix_bit
        Add t2, t1, t0
        lbu  t3,0(t2)
        sync
        sll t3, t3, t0
        addu t4, t4, t3
        bne t0, MAXPOS, loop_fix_bit
        Add t0, 1
        sw   t4,0(t5)





;;-----------------------------------------

;- copie la trainroutine
        la t0, TRAIN_ROUTINE_START
        la   t1,TRAIN_PATCH+$20000000
        la t2, TRAIN_ROUTINE_END - TRAIN_ROUTINE_START + 4
copytrain:
        lw   t3,0(t0)
        sync
        sw   t3,0(t1)
        Add t0, 4
        Add t1, 4
        bne t2, zero, copytrain
        subu t2, 4



;-------------------------------------
;patch le jump de osviswap  (normal)

        li   t0,PATCH_OSVI+$20000000
        lui  t1,$3c08
        ori t1, t1, HI_TRAIN_PATCH
        sw   t1,0(t0)
        lui  t1,$3508
        ori t1, t1, LOW_TRAIN_PATCH
        sw   t1,4(t0)
        li   t1,$01000008
        sw   t1,8(t0)

    li  t0,$               ; here we jump to the game, it's
        jr  t0                         ; the entrypoint. the jump to the rom
        nop                            ; was there, but we replaced it at the
                                       ; beginning of the code remember!



;-----------------------------------------------------------------
TRAIN_ROUTINE_START
;-----------------------------------------------------------------
        sub     sp,28       ;Get som Stackspace
            sw      s0,0(sp)    ;Better save this regs
            sw      t0,4(sp)    ;coz our routine below
            sw      t9,8(sp)    ;will trash them!
            sw      t2,12(sp)   ;t1 and t2 is for additional stuff

start_option:

    lw s0, patch_game

TRN_1
        and  t0,s0,$1
        beq t0, zero, TRN_2


TRN_2:
        and  t0,s0,$2
        beq t0, zero, TRN_3


TRN_3:
        and  t0,s0,$4
        beq t0, zero, TRN_4


TRN_4:
        and  t0,s0,$8
        beq t0, zero, TRN_5


TRN_5:
        and  t0,s0,$10
        beq t0, zero, TRN_6


TRN_6:
        and  t0,s0,$20
        beq t0, zero, TRN_7


TRN_7:
            lw      s0,0(sp)    ;Okay.. lets restore the
            lw      t0,4(sp)    ;regs..!
            lw      t9,8(sp)
            lw      t2,12(sp)
            add     sp,28       ;Free our Stackspace!
        nop
        jr  ra              ;This will jump back
        nop                     ;to osWriteBackDCacheAll!





TRAIN_ROUTINE_END



loop_reset
            la      t1,START_ADD-$30000
            sw      t1,$a4400004
            li      t1,$400
            sw      t1,$a4400034
loop_r

            j loop_r
            nop

;***********************************************************
;This is the Optionbar stuff!
;***********************************************************
linedown:

        lw s0, linepos
        nop
        beq s0, MAXPOS, introloop
        nop


        sw  ra,4(sp)
        lhu s0, linesave
        jal line2
        nop
        lw  ra,4(sp)
        lw s0, linepos
        Add s0, 1
        sw s0, linepos
        nop
        lhu s0, linesave
        Add s0, s0, 9
        sh s0, linesave
        nop
        beq zero, zero, line
        nop
lineup:
        lw s0, linepos
        nop
        beq s0, 0, introloop
        nop

        sw  ra,4(sp)
        lhu s0, linesave
        jal line2
        nop
        lw  ra,4(sp)
        lw s0, linepos
        sub s0,1
        sw s0, linepos
        nop
        lhu s0, linesave
       sub s0,s0,9
        sh s0, linesave
        nop
line:
        la  t0,VIDEOBUFFER+$20000000
        li s1, 640
        mult s0, s1
        nop
        nop
        nop
        mflo s0
        nop
        nop
        nop
        Add t0, s0
        nop
        li s0, 320 * 8
lineloop:
        li  s1,$0000        ;farbe balken
        lhu s2, (t0)
        sync
        beq s2,$ffff,donormal5  ;farbe anders
        nop
        Move s1, s2
donormal5:
        sh s1, (t0)
        nop
        Add t0, t0, 2
        bne s0, zero, lineloop
        sub s0,s0,1

        jr ra
        nop
line2:
        la  t0,VIDEOBUFFER+$20000000
        li s1, 640
        mult s0, s1
        nop
        nop
        nop
        mflo s0
        nop
        nop
        nop
        Add t0, s0
        nop
        li s0, 320 * 8
lineloop2:
        li  s1,$ffff            ;farbe weiss
        lhu s2, (t0)
        sync
        beq s2,$0000,donormal6      ;farbe grau
        nop
        Move s1, s2
donormal6:
        sh s1, (t0)
        nop
        Add t0, t0, 2
        bne s0, zero, lineloop2
        sub s0,s0,1

        jr ra
        nop
;***********************************************************
;Print the yes/no string..!!
;***********************************************************
printyes:
    
        lw t2, linepos
            la t3, opt_on_off
            Add t3, t2
            lbu  t1,0(t3)
            sync
            beq t1, 0, yeson
        nop
            jr ra

yeson:
        la a1, yes
        beq zero, zero, printtext2

        
printno:
        lw t2, linepos
            la t3, opt_on_off
            Add t3, t2
            lbu  t1,0(t3)
            sync
            beq t1, 1, noon
            nop
            jr ra

noon:
        la a1, no
        nop


printtext2:
        xor  t1,1
            sb   t1,0(t3)
        
        lhu s0, linesave
        nop
       la  a0,VIDEOBUFFER+$20000000
        li s1, 640
        li s2, 512
        mult s0, s1
        nop
        nop
        nop
        mflo s0
        nop
        nop
        nop
        Add a0, s0
        nop
        Add a0, s2
        nop
        li t6, 3
prttxtloop3:
        la a2, fntcmp
        la t1, Font
prttxtcmp2:
        lb t0, (a1)
        lb t2, (a2)
        beq t0, t2, txtout2
        nop
        Add a2, a2, 1
        Add t1, t1, 128
        beq t0, t0, prttxtcmp2
        nop

txtout2:
        PRINTX2:             equr t8
        PRINTY2:             equr t9
        POSs42:             equr a0

        li t5, 0
        li  a3,$ffff    ;$400a  background yes/no

displetter2:
            li      PRINTY2,7   ;7
_yloop2:
            li      PRINTX2,7   ;7
_xloop2:
            lhu     t3,0(t1)
            bne t3, t5, notcol02
            nop
            Move t3, a3
notcol02:
        bne t3,$ffff,notcol03   :farbe weiss
        nop
        li  t3,$0000        ;farbe grau
        nop
notcol03:
            sh      t3,0(POSs42)
            Add POSs42, 2
            Add t1, 2
                

            bne     PRINTX2,zero,_xloop2
            subu PRINTX2, 1

            Add POSs42, (320 - 8) * 2

           bne     PRINTY2,zero,_yloop2
            subu PRINTY2, 1

            sub     POSs42,320*8*2-16
        
        Add a1, a1, 1

        bne t6, zero, prttxtloop3
        sub t6,t6,1

        Add a0, a0, 320 * 8 * 2 + 16

        jr ra
        nop




;***********************************************************
;Write the Option-text to Videobuffer..
;***********************************************************
printtext:
        la a0, textbuffer + 2 * 320 * 35
        li t7, 13
prtlineloop2:
        li t6, 38

prttxtloop2:
        la a2, fntcmp
        la t1, Font
prttxtcmp:
        lb t0, (a1)
        lb t2, (a2)
        beq t0, t2, txtout
        nop
        Add a2, a2, 1
        Add t1, t1, 128
        beq t0, t0, prttxtcmp
        nop

txtout:
PRINTX:             equr t8
PRINTY:             equr t9
POSs4:             equr a0
  
        li t5, 1
        li a3, 1

displetter:
            li PRINTY, 7
_yloop:
            li PRINTX, 7
_xloop:
            lhu     t3,0(t1)
            bne     t3,t5,notcol0       ;nicht bermalen
            nop
            Move t3, a3
notcol0:
            sh      t3,0(POSs4)
            Add POSs4, 2
            Add t1, 2
                

            bne     PRINTX,zero,_xloop
           subu PRINTX, 1

            Add POSs4, (320 - 8) * 2

            bne     PRINTY,zero,_yloop
            subu PRINTY, 1

            sub     POSs4,320*8*2-16
        
       Add a1, a1, 1

        bne t6, zero, prttxtloop2
        sub t6,t6,1

        Add a0, a0, 320 * 8 * 2 + 16

        bne t7, zero, prtlineloop2
        sub t7,t7,1

        nop

        la  t1,VIDEOBUFFER+$20000000
        la t3, textbuffer
        li t4, 320 * 200
        li s1, 0
cpyloop3:
        lhu s0, (t3)
        nop
        bne s0, zero, donormal3
        nop
        lhu s0, (t1)
        nop
donormal3:
        sh s0, (t1)
        nop
        Add s1, s1, 1
        Add t1, t1, 2
        Add t3, t3, 2
        bne s1, 2, donormal4
        nop
        lhu s2, printftp
        nop
        beq s2, 1, donormal4
        nop
        li s1, 0
        sw  t1,4(sp)
        sw  t3,8(sp)
        sw  t4,12(sp)
        sw  s0,16(sp)
        sw  s1,20(sp)
        sw  ra,24(sp)

        jal VSync
        nop

        lw  t1,4(sp)
        lw  t3,8(sp)
        lw  t4,12(sp)
        lw  s0,16(sp)
        lw  s1,20(sp)
        lw  ra,24(sp)
        nop
donormal4:
        bne t4, zero, cpyloop3
        sub t4,t4,1
    
        jr ra
        nop


;***********************************************************
;This is the Scroller!!!!!!!!
;***********************************************************
scrolly2:
        la  s4,scrollbuffer+2*320*1; VIDEOBUFFER+(320*50*2)+$20000000
            Move t5, s4

        lhu s0,fntwait      ; Delay-Function...
        sync
        beq s0, zero, donotwait2
        nop
        sub s0,s0,1
       nop
        sh s0, fntwait
        nop
        beq zero, zero, cpyscroll
        nop
donotwait2:
            li t0, 320 * 8 - 2
scroll:     lw      t1,4(s4)
            sw      t1,0(s4)
            addiu s4, 4
            bne t0, zero, scroll
            subu t0, 2

        la a3, texte
            addu a3, a3, s5
            lbu     a3,0(a3)

        
        li  t0,$23          ;  - If this is true -> DELAY
        bne t0, a3, donotwait
        nop
        li s0, 240
        sh s0, fntwait
        nop
        Add s5, s5, 1
        nop
donotwait:
        li  t0,$40          ;  - END of the scrolltext.
        bne t0, a3, txtloop2
        nop

            li s6, 0

            li s1, 0
            li s2, 0
        li s5, 0

        la a3, texte
            addu    a3,a3,s5    ; t0=address of the letter to display
            lbu     a3,0(a3)            ; t0=letter to display
            
txtloop2:
        la a2, fntcmp
        la t1, font
txtcmp:
        lb t2, (a2)
        beq a3, t2, nofin
        nop
        Add a2, a2, 1
        Add t1, t1, 128
        beq zero, zero, txtcmp
        nop

nofin:
            Add t0, t1, s6
            Add t0, t0, s6
            li t1, 8
y_loop:
            Add t5, 320 * 2
            lw      t3,0(t0)
            and     t3,$fffefffe        ;farbe weiss
            sw      t3,0(t5)
            Add t0, 16
            bne t1, zero, y_loop
            subu t1, 1

            bne     s6,s7,nope      ; next letter?
            Add s6, 2
nextletter:                                 ; yes...
            or      s6,zero,zero
            Add s5, 1
nope:


; This scrollbuffer is only usefull if you do sinus-stuff or if
; you just want to scroll through a little  in the
; Videobuffer...
; Bah anyway.. i wont change it.. i dont have any slowdowns.
cpyscroll:
        la  t1,VIDEOBUFFER+(2*(320*179))+62+$20000000
        la t3, scrollbuffer + (2 * (320 * 1)) + 62
        li  t4,8 ;y
cpyloop2:
        li  t2,265 ;x
cpyloop:
        lhu s1, (t3)
        nop
       bne s1, zero, donormal
        nop
        li  s1,$0000fffe    ;3008
        nop
donormal:
        bne s1,$4002,donormal2
        nop
        li  s1,$0000fffe    ;3008
donormal2:
        sh s1, (t1)
        nop
        Add t3, t3, 2
        Add t1, t1, 2
        bne t2, zero, cpyloop
        sub t2,t2,1

        sub t1,t1,532
        SUB t3,t3,532
        Add t1, t1, 640
        Add t3, t3, 640
        bne t4, zero, cpyloop2
        sub t4,t4,1


; Mix the shit together with a nice Copperbar!

        la  t1,VIDEOBUFFER+(2*(320*179))+$20000000
        la a0, copper
        li t2, 320 * 13
coploop:
        lhu t0, (t1)
        nop
        bne t0,$0066,nocop      ;farbe weiss wird bermalt
        nop
        lhu t0, (a0)
        sync
        sh t0, (t1)
        nop
nocop:
        Add t1, t1, 2
        Add a0, a0, 2
        bne t2, zero, coploop
        sub t2,t2,1

        jr ra
        nop

;***********************************************************
;The VSync-Routine!
;***********************************************************
VSync:
        lui     t0,$a440
        li  t2,$200
vwait:      lw  t1,$10(t0)
        sync
        and     t1,$200
        bne t1, t2, vwait
        nop
        jr ra
        nop

;***********************************************************
;Here we initialize the Video Inteface!
;***********************************************************
init_vi:
        la  t2,$A4400000        ; Start VI Registers.
        nop
        li  t0,$320e
        sw  t0,0(t2)
        nop
        la  t0,VIDEOBUFFER      ; Our Videobuffer
        sw  t0,4(t2)
        nop
        li  t0,$140
        sw  t0,8(t2)
        nop
        li  t0,$2
        sw  t0,12(t2)
        nop
        li  t0,$0
        sw  t0,16(t2)
        nop
        li  t0,$03e52239
        sw  t0,20(t2)
        nop
        li  t0,$20d
        sw  t0,24(t2)
        nop
        li  t0,$c15
        sw  t0,28(t2)
        nop
        li  t0,$0c150c15
        sw  t0,32(t2)
        nop
        li  t0,$006c02ec
        sw  t0,36(t2)
        nop
        li  t0,$002501ff
        sw  t0,40(t2)
        nop
        li  t0,$000e0204
        sw  t0,44(t2)
        nop
        li  t0,$200
        sw  t0,48(t2)
        nop
        li  t0,$400
        sw  t0,52(t2)
        nop
        jr  ra      ; Ready to go..
        nop


cxc3          dcb ((((cxc3)/64)+1)*64)-(cxc3),0     ;(c) Wildfire:)

datapad       db $ff,$01,$04,$01,$00,$00,$00,$00    ; Pad-Stuff
              db $ff,$01,$04,$01,$00,$00,$00,$00
              db $ff,$01,$04,$01,$00,$00,$00,$00
              db $ff,$01,$04,$01,$00,$00,$00,$00
              db $fe,$00,$00,$00,$00,$00,$00,$00
              db $00,$00,$00,$00,$00,$00,$00,$00
              db $00,$00,$00,$00,$00,$00,$00,$00
              db $00,$00,$00,$00,$00,$00,$00,$01
datapad2      dcb      64,0                     ; SI DMA buffer.
copper:     incbin  copper              ; The copper for the Scroll
font:       incbin  pdyfnt.raw          ; The font..
fntwait:    dh 0
linesave:   dh 97
linepos:    dw 0

option:     dh  0,0,0,0,0,0

opt_on_off:      dcb 8 * 4, 0

nokey       dw  0
optdelay:   dw 0
printftp:   dw  0   ; 1     2         3     4
            ;123456789012345678901234567890123456789012345678
fntcmp:     db " abcdefghijklmnopqrstuvwxyz0123456789!:?()-+.'*
texte:      include scroll.txt          ; Include the scrolltext.
text1:
yes:        db " yes"
no:         db " no!"
cxc5; dcb((((cxc5) / 64) + 1) * 64) - (cxc5), 0
logo:
incbin; back.raw; the; logodat
; its; BGR, 16; Bit
logo_end:
cxc2; dcb((((cxc2) / 64) + 1) * 64) - (cxc2), 0
textbuffer: dch 320*240,0           ; All the buffershit.
VIDEOBUFFER:    dch 320 * 240, 0
scrollbuffer:   dch 320 * 15, 0

