/******************************************************************************
 * Linker script for arm-elf-ld v0.2 (w) Groepaz/Hitmen
 * Target CPU: Arm/T7  Machine: Gameboy Advanced
 *****************************************************************************/

OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)                                                  /* code entry point */

/********************* memory layout *****************************************/

MEMORY {

    /******* agb internal *******/

    bootrom   : ORIGIN = 0x00000000, LENGTH = 0x00004000       /* 16k bootrom */
    exwram    : ORIGIN = 0x02000000, LENGTH = 0x00040000       /* 256k external ram */

    inwram    : ORIGIN = 0x03000000, LENGTH = 0x00003f00       /* 32k internal ram */
    sysram    : ORIGIN = 0x03003f00, LENGTH = 0x00000100
    stacktop  : ORIGIN = 0x03003efc, LENGTH = 0x00000004

    hwregs    : ORIGIN = 0x04000000, LENGTH = 0x00000300       /* hardware register */
    palette   : ORIGIN = 0x05000000, LENGTH = 0x00000400       /* color palettes */
    vram      : ORIGIN = 0x06000000, LENGTH = 0x00018000       /* 96k videoram */
    oam       : ORIGIN = 0x07000000, LENGTH = 0x00000400       /* object memory */

    /******* gamepak ********/

    /* rom waitstate 0 */
    rombank0  : ORIGIN = 0x08000000, LENGTH = 0x01fe0000       /* 32mb gamepak rom */
    flashrom0 : ORIGIN = 0x09fe0000, LENGTH = 0x00020000       /* 128k flash */

    /* rom waitstate 1 */
    rombank1  : ORIGIN = 0x0a000000, LENGTH = 0x01fe0000       /* 32mb gamepak rom */
    flashrom1 : ORIGIN = 0x0bfe0000, LENGTH = 0x00020000       /* 128k flash */

    /* rom waitstate 2 */
    rombank2  : ORIGIN = 0x0c000000, LENGTH = 0x01fe0000       /* 32mb gamepak rom */
    flashrom2 : ORIGIN = 0x0dfe0000, LENGTH = 0x00020000       /* 128k flash */

    rambank   : ORIGIN = 0x0e000000, LENGTH = 0x00010000       /* 64k sram */

}

/********************* output layout *****************************************/

SECTIONS {

	/* ? */

  .interp        : { *(.interp)         }
  .hash          : { *(.hash)           }

  .dynsym        : { *(.dynsym)         }
  .dynstr        : { *(.dynstr)         }

	/* gnu version information */

  .gnu.version   : { *(.gnu.version)    }
  .gnu.version_d : { *(.gnu.version_d)  }
  .gnu.version_r : { *(.gnu.version_r)  }

  	/* relocation information */

  .rel.text      : { *(.rel.text)
                     *(.rel.text.*)
                     *(.rel.gnu.linkonce.t*) }
  .rela.text     : { *(.rela.text)
                     *(.rela.text.*)
                     *(.rela.gnu.linkonce.t*) }
  .rel.data      : { *(.rel.data)
                     *(.rel.data.*)
                     *(.rel.gnu.linkonce.d*) }
  .rela.data     : { *(.rela.data)
                     *(.rela.data.*)
                     *(.rela.gnu.linkonce.d*) }
  .rel.rodata    : { *(.rel.rodata)
                     *(.rel.rodata.*)
                     *(.rel.gnu.linkonce.r*) }
  .rela.rodata   : { *(.rela.rodata)
                     *(.rela.rodata.*)
                     *(.rela.gnu.linkonce.r*) }
  .rel.got       : { *(.rel.got) }
  .rela.got      : { *(.rela.got) }
  .rel.ctors     : { *(.rel.ctors) }
  .rela.ctors    : { *(.rela.ctors) }
  .rel.ctors     : { *(.rel.ctors) }
  .rela.ctors    : { *(.rela.ctors) }
  .rel.init      : { *(.rel.init) }
  .rela.init     : { *(.rela.init) }
  .rel.fini      : { *(.rel.fini) }
  .rela.fini     : { *(.rela.fini) }
  .rel.bss       : { *(.rel.bss) }
  .rela.bss      : { *(.rela.bss) }
  .rel.plt       : { *(.rel.plt) }
  .rela.plt      : { *(.rela.plt) }

  /* ? */

  .init          : { *(.init) }
  .plt           : { *(.plt) }

  /************************ executeable layout information **************************/

  /* program code field */
  .text : {  /* CONTENTS, ALLOC, LOAD, RELOC, READONLY, CODE */

                *(.text)                           /* code */
		*(.text.*)
		*(.stub)                           /* debug-stub code */
		*(.gnu.warning)
		*(.gnu.linkonce.t*)
		*(.glue_7t);                       /* ? */
		*(.glue_7);                        /* ? */

		_etext = ABSOLUTE(.) ;             /* => provide adr. of end of text */

  		PROVIDE (etext = .);

    } > rombank0

  .fini : { *(.fini) }

  .got : { *(.got.plt)                   /* ? */
           *(.got)     }

  .dynamic : { *(.dynamic) }             /* ? */

  .tors : {  /* CONTENTS, ALLOC, LOAD, RELOC, READONLY, DATA */

		/* .ctors */
		. = ALIGN(4);
                __ctors = ABSOLUTE(.) ;
                *(.ctors)                          /* c++ constructors */
                __ctors_end = ABSOLUTE(.) ;

		/* .dtors */
                . = ALIGN(4);
                __dtors = ABSOLUTE(.) ;
                *(.dtors)                          /* c++ destructors */
                __dtors_end = ABSOLUTE(.) ;

  } > rombank0

  /* short initialized data field (writeable ?!) */
  .sdata : {
		*(.sdata)
		*(.sdata.*)
  } > rombank0

  /* read only data field */
  .rodata : {  /* CONTENTS, ALLOC, LOAD, RELOC, READONLY, DATA */

                . = ALIGN(32 / 8);

                *(.rodata)                         /* initialized data */
		*(.rodata.*)
		*(.gnu.linkonce.r*)
		*(.rodata1)

		_erodata = ABSOLUTE(.) ;
		_romdata = ABSOLUTE(.) ;

		PROVIDE(romdata = .);

   } > rombank0


  /* initialized data field (writeable) */
  .data1   : {
                *(.data1)
  } > exwram

  .data : AT (_romdata) {  /* CONTENTS, ALLOC, LOAD, DATA */

		_bdata = ABSOLUTE(.) ;
  		PROVIDE (bdata = .);

                *(.data)          /* CONTENTS, ALLOC, LOAD, DATA */
		*(.data.*)
		*(.gnu.linkonce.d*)

		_edata = ABSOLUTE(.) ;
  		PROVIDE (edata = .);

  } > exwram

  _bss_start__ = ABSOLUTE(.) ;
  __bss_start__ = ABSOLUTE(.) ;

  _bstart = ABSOLUTE(.) ;

  PROVIDE(bstart = .);

  /* short bss data field (not initialized/writeable) */
  .sbss (NOLOAD) : {
		*(.sbss)
		*(.scommon)
  } > exwram

  /* bss data field (not initialized/writeable) */
  .bss (NOLOAD) : {                            /* non-initialized data */

		*(dynbss)
		*(.bss)
		*(.bss.*)
		*(COMMON)
		*(.COMMON)
		*(common)
		*(.common)

    } > exwram

  	. = ALIGN(32 / 8);

        _end = ABSOLUTE(.) ;
        end = ABSOLUTE(.) ;                    /* needed for screwed up _sbrk ?! */
	_bss_end__ = ABSOLUTE(.) ;
	__bss_end__ = ABSOLUTE(.) ;

        _bend = ABSOLUTE(.) ;

        PROVIDE(bend = .);
	PROVIDE (end = .);

                                               /* the heap will be here */

  /* stack area (not initialized/writeable) */
  .stack (NOLOAD) : {
    	*(.stack)                              /* cpu-stack */
    	_stack = ABSOLUTE(.) ;
    } > stacktop


  /**************************** debug information ****************************/


  /* Stabs debugging sections.  */
  .stab            0 : { *(.stab)          }             /* ? */
  .stabstr         0 : { *(.stabstr)       }             /* ? */
  .stab.excl 	   0 : { *(.stab.excl) 	 }               /* ? */
  .stab.exclstr    0 : { *(.stab.exclstr)  }             /* ? */
  .stab.index 	   0 : { *(.stab.index)    }             /* ? */
  .stab.indexstr   0 : { *(.stab.indexstr) }             /* ? */
  .comment         0 : { *(.comment)       }             /* ? */
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug           0 : { *(.debug)         }             /* ? */
  .line            0 : { *(.line)          }             /* ? */
  /* GNU DWARF 1 extensions */
  .debug_srcinfo   0 : {  *(.debug_srcinfo)   }          /* ? */
  .debug_sfnames   0 : {  *(.debug_sfnames)   }          /* ? */
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges   0 : {  *(.debug_aranges)   }          /* ? */
  .debug_pubnames  0 : {  *(.debug_pubnames)  }          /* ? */
  /* DWARF 2 */
  .debug_info      0 : {  *(.debug_info)      }          /* ? */
  .debug_abbrev    0 : {  *(.debug_abbrev)    }          /* ? */
  .debug_line      0 : {  *(.debug_line)      }          /* ? */
  .debug_frame     0 : {  *(.debug_frame)     }          /* ? */
  .debug_str       0 : {  *(.debug_str)       }          /* ? */
  .debug_loc       0 : {  *(.debug_loc)       }          /* ? */
  .debug_macinfo   0 : {  *(.debug_macinfo)   }          /* ? */
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : {  *(.debug_weaknames) }          /* ? */
  .debug_funcnames 0 : {  *(.debug_funcnames) }          /* ? */
  .debug_typenames 0 : {  *(.debug_typenames) }          /* ? */
  .debug_varnames  0 : {  *(.debug_varnames)  }          /* ? */

}
