#include <iostream>
#include <math.h>
#include <vector>
#include <time.h>
#include <stdlib.h>
#include <string>

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>

/* Defines for library initializations etc */
#define S_WIDTH 800
#define S_HEIGHT 600
#define BPP 32
#define S_FLAGS SDL_HWSURFACE | SDL_DOUBLEBUF | SDL_FULLSCREEN

#include "main.h"
#include "FPS_Limit.h"
#include "kommando.h"
#include "font.h"
#include "hitler.h"


void InitStuff(); /* screen initialization functions, misc. variables' values assigned, the particle engine's initialization functions called here */

void Events();
SDL_Event event;
Uint8* pressed_key;

bool running;
/* */

SDL_Surface *screen;

static void skene1();
int temppeli;
static void skene2();

int skene;

kommando *Kommando;
pissapaska *Pissapaska;

int kakka;

int main()
{	
	
	kakka = 0;
	
	void (*skenet[2])(void)  = {skene1, skene2};
	
	temppeli = 0;
	
	skene = 0;
	InitStuff();

	kommando tempk;
	tempk.audio();
	Kommando = &tempk;
	
	pissapaska tempp;
	Pissapaska = &tempp;
	
	FPS_Limiter FPS_Limit;
	
	int TEST_REMOVE = SDL_GetTicks();
	int TEST_REMOVE2 = 0;
	int FPS_REMOVE = 0;
	
	while (running)
	{
// 		SDL_FillRect(screen, NULL, 0);
		
		Events();
		
		skenet[skene]();
		
		if (skene == 2)
			running = 0;
		
		SDL_Flip(screen);
		FPS_Limit.Limit();
		
		if (SDL_GetTicks() - TEST_REMOVE > 1000)
		{
			
			std::cout<<FPS_REMOVE<<"\n";
			cout<<SDL_GetTicks()/1000<<"\n";
			
			FPS_REMOVE = 0;
			TEST_REMOVE = SDL_GetTicks();
		}
		FPS_REMOVE++;
		
		if (SDL_GetTicks() > 43000)
			running = 0;
	}
	
	Mix_CloseAudio();
	SDL_Quit();
	return 0;
}

void skene1()
{

	if ((SDL_GetTicks() - Kommando->beginning) % 6000 < 2000 && Pissapaska->kerrat < 6)		
	{
		kakka = 0;
		Kommando->run();
	}
	else
	{
		if (kakka == 0)
		{
			kakka = 1;
			Pissapaska->kerrat++;
		}
		Pissapaska->run();
	}
}

void skene2()
{
	
}

void InitStuff()
{
	/* Particle engine and misc. variables */
	running = 1;
	
	/* Random generator */
	time_t seed;
    time(&seed);

    srand(seed);
    /* .. */
	
	/* Library, screen initializations */
	SDL_Init(0);
	screen = SDL_SetVideoMode(S_WIDTH, S_HEIGHT, BPP, S_FLAGS);
	
	SDL_ShowCursor(0);
	
	Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 1024);
}

void Events()
{	
	SDL_PollEvent(&event);
	if ( event.type == SDL_QUIT )
		running = 0;

	pressed_key = SDL_GetKeyState(NULL);
	if ( pressed_key[SDLK_ESCAPE] )
		running = 0;
}


