// gravityparticle is different from motherparticle in that it doesn't have a constant 
// fading time and it is pulled towards "ground" by gravitation. It also "aims" upwards

#include "main.h"

class GravityParticle : public MotherParticle
{
	public:
		void Run();
		void ColorBurnInit();
		void AddGrav();
		void LocationInit();
};

void GravityParticle::ColorBurnInit()
{
	this->fading_speed = 0.04 + ((rand()%400)*0.00005);
	
	this->burning = 0.75 + (((rand()%400) - 200)/400.0);
		
	this->color[0] = (rand()%100)/100.0;
	this->color[1] = (rand()%100)/100.0;
	this->color[2] = (rand()%100)/100.0;
}

void GravityParticle::AddGrav()
{
	this->a_y -= 0.0005;
}

void GravityParticle::Run()
{
	if (this->burning <= 0)
	{	
		this->LocationInit();
		SpeedInit();
		AccInit();
		
		this->ColorBurnInit();
	}
	
	this->AddGrav();
	Burn();
	AddAcceleration();
	AddVelocity();
	Draw();
}

void GravityParticle::LocationInit()
{
	l_x = 1.5;
	l_y = 1.5;
	l_z = 0;
}

