require 'luagl'
require 'luaglut'
require 'memarray'
local fi = require 'luafreeimage'

local splif_version = 'SPACETIME SPECIAL'
local splif_titletext = 'Trilobit ScriPtable Lua Interactive MultiplatForm (SPLIF) version ' .. splif_version
local debugmode = -1
local res_w = 0
local res_h = 0
local res_override = 0

local quit = false
local fps = 60
local fps_str = ''
local msec = 1000 / fps
local frames = 0
local cur_fps = 0
local start_time
local fps_time
local elapsed_time
local millis = 0
local timedelta = 0
local last_frame = 0
local ppm, width, height
local debug_pause = 1
local seeked = 0
local song_time_end = 0
local load_number
local loading = 1
local init_done = 0
do_seekeffect = 0
local picnum = 0
local spectrum = {}

local mouse_x = 0
local mouse_y = 0
local song_time_end = 0

local mouse_over_slider = 0

local slider_x = 10
local slider_y = 10
local slider_w = 20
local slider_h = 10
local slider_bar_pos = 0

--

local width = 0
local height = 0

local effect_time = 0 -- time spent on this effect
local effect_endtime = 0 -- time to end the effect
local effect_params = {0,0,0,0,0,0,0,0,0,0,0} -- variable list of parameters for randomizer initialization
local effect_layercount = 0 -- how many layers to render for this effect (1-3)
local effect_layers = {0,0,0,0,0,0,0,0,0,0,0} -- list of effect numbers for layers
local effect_blendmodes = {0,0,0,0,0,0,0,0,0,0,0}
local effect_max = 9 -- number of last effect, UPDATE THIS WHEN YOU ADD EFFECTS

local next_effect = 0 -- debug

local millis = 0

local function glutBitmapString(font, str)
        for i = 1, string.len(str) do
                glutBitmapCharacter(font, string.byte(str, i))
        end
end

function engine_spectrum() 
	
	temp = song_spectrum()
	for i = 0, 511 do
		spectrum[i] = ( spectrum[i] * 0.3 ) + (temp[i] *0.7)
	end

	return spectrum;
end

function engine_main() 

	res_override, res_w, res_h, res_hz, res_windowed = demo_getresolution()
	
	for i = 0, 511 do
		spectrum[i] = 0.5
	end

	glutInit(arg)

	if res_override == 1 then
		if res_windowed >= 1 then glutInitWindowSize(res_w, res_h)
		else glutGameModeString(res_w .. "x" .. res_h .. ":32" .. "@" .. res_hz)
		end
	end

	local jit_version = "(N/A)"

	if jit then
		if jit.version then
			jit_version = jit.version
		end
	end

	print('[ ' .. splif_titletext .. ' ]')
	print('[ Running on Lua: "' .. _VERSION .. '" LuaJIT: "' .. jit_version .. '" LuaGL: "' .. luagl.VERSION .. '" LuaGLUT: "' .. luaglut.VERSION .. '" FMOD Ex: "' .. song_getfmodversion() .. '" ]')
	freeimage_version, freeimage_copyright = fi.getInfo()
	print('[ FreeImage: "' .. freeimage_version .. '" (' .. freeimage_copyright .. ') ]')

	glutInitDisplayMode(GLUT_RGB + GLUT_DOUBLE + GLUT_DEPTH + GLUT_MULTISAMPLE)
	if arg then title = arg[0] else title = splif_titletext end
	if res_windowed >= 1 then window = glutCreateWindow(title)
	else window = glutEnterGameMode()
	end

	if res_windowed == 2 then glutFullScreen() end
	
	glutSetCursor(GLUT_CURSOR_NONE)

	glutDisplayFunc(display_func)
	glutKeyboardFunc(keyboard_func)
	glutReshapeFunc(resize_func)
	glutTimerFunc(msec, timer_func, 0)
	
	-- rodent stuff
	glutMouseFunc(mouse_func)
	glutMotionFunc(mouse_motion)
	glutPassiveMotionFunc(mouse_motion)
	
	-- hack for osx tearing and other misc inits

	demosystem_init()

	if res_override == 1 and res_windowed == 0 then
		print('[ Requested screen mode: ' .. res_w .. 'x' .. res_h .. ' ('  .. res_hz .. 'Hz) ]')
	end
	if res_windowed == 0 then print ("[ Screen mode: " .. glutGameModeGet(GLUT_GAME_MODE_WIDTH) .. "x" .. glutGameModeGet(GLUT_GAME_MODE_HEIGHT) .. "x" .. glutGameModeGet(GLUT_GAME_MODE_PIXEL_DEPTH) .. " (" .. glutGameModeGet(GLUT_GAME_MODE_REFRESH_RATE) .. "Hz) ]") end
	start_time = glutGet(GLUT_ELAPSED_TIME)
	fps_time = start_time

	math.randomseed(os.time())

	print("Are you experienced?")

	load_textures()

	song_play()
	song_time_end = song_getlength()
	glutMainLoop()
	
end

local ior_textures = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
local text_texture = 0
local buck_texture = 0

function load_textures()
	for i = 1, 32 do
		ior_textures[i] = load_texture("data/ior" .. i .. ".png", 0)
	end

	text_texture = load_texture("data/text.png", 1)
	buck_texture = load_texture("data/buck.png", 1)
end

function load_texture(fname)
	load_texture(fname, 0)
end

function load_texture(fname, clamp)
	io.write("Loading texture " .. fname .. "...")
	local dib = fi.bitmap()
	assert(dib:load("png", fname))
	assert(dib:convertTo32Bits(dib))
	width = dib:getWidth()
	height = dib:getHeight()
	local ppm = memarray('uchar', width * height * 3)
	i = 0
   for y = 1, height do
      local dst_idx = (height - y) * width * 3
      for x = 0, width - 1 do
	 iR, iG, iB, iA = dib:getRGBA(x,height-y)
         
         ppm[dst_idx + 3*x + 0] = iR
         ppm[dst_idx + 3*x + 1] = iG
         ppm[dst_idx + 3*x + 2] = iB
	 i = i + 3
      end
   end
	if loading == 1 then 
		picnum = picnum + 1
	end

	texnum = memarray('uchar', 1)

	glGenTextures(1, texnum:ptr())
	texture_number = texnum[0]
	glBindTexture(GL_TEXTURE_2D, texture_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, width, height, 0, GL_RGB, GL_UNSIGNED_BYTE, ppm:ptr())

	if clamp == 0 then
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
	else
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
	end
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

	print("done. (texture id #" .. texture_number .. ")")
	return texture_number
end

function load_texture_RGBA(fname)
	local dib = fi.bitmap()
	assert(dib:load("png", fname))
	assert(dib:convertTo32Bits(dib))
	width = dib:getWidth()
	height = dib:getHeight()
	local ppm = memarray('uchar', width * height * 4)
	i = 0
   for y = 1, height do
      local dst_idx = (height - y) * width * 4
      for x = 0, width - 1 do
	 iR, iG, iB, iA = dib:getRGBA(x,height-y)
         
         ppm[dst_idx + 4*x + 0] = iR
         ppm[dst_idx + 4*x + 1] = iG
         ppm[dst_idx + 4*x + 2] = iB
         ppm[dst_idx + 4*x + 3] = iA
	 i = i + 4
      end
   end
	return ppm, width, height
end


function load_texture_ALPHA(fname)
   local f
   local width = 0
   local height = 0
   local depth = 0
   local data

   f = assert(io.open(fname, 'rb'))
   assert(f:read('*l') == 'P6')
   width = f:read('*n')
   height = f:read('*n')
   depth = f:read('*l')
   depth = f:read('*l')
   data = f:read('*a')
   f:close()

   local ppm = memarray('uchar', width * height * 4)
   for y = 1, height do
      local dst_idx = (height - y) * width * 4
      local src_idx = (y - 1) * width * 3
      for x = 0, width - 1 do
         ppm[dst_idx + 4*x + 0] = string.byte(data, src_idx + 3*x + 1)
         ppm[dst_idx + 4*x + 1] = string.byte(data, src_idx + 3*x + 2)
         ppm[dst_idx + 4*x + 2] = string.byte(data, src_idx + 3*x + 3)

	 colvalue = ppm[dst_idx + 4*x + 0] + ppm[dst_idx + 4*x + 1] + ppm[dst_idx + 4*x + 2]
	 colvalue = colvalue / 3

         if colvalue == 0 then ppm[dst_idx + 4*x + 3] = 1
	 else
		ppm[dst_idx + 4*x + 3] = 0
	 end
      end
   end

   return ppm, width, height
end

function debug()
	glDisable(GL_BLEND)
	glDisable(GL_TEXTURE_2D)
	glMatrixMode(GL_PROJECTION)
	glPushMatrix()
	glLoadIdentity()
	glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -3, 3)
	if debugmode == 1 then
		fps_str = 'fps: [' .. cur_fps .. ']'
		glColor3d(1,1,1)
		glRasterPos2d(2,glutGet(GLUT_WINDOW_HEIGHT)-16)
		glutBitmapString(GLUT_BITMAP_8_BY_13, fps_str) 
		glColor3d(0.2,0.2,0.2)
		glRasterPos2d(2,glutGet(GLUT_WINDOW_HEIGHT)-30)
		glutBitmapString(GLUT_BITMAP_8_BY_13, fps_str )
	end
	glPopMatrix()
end

local iorcount = 0
local iorcount2 = 0

function display_func()
	amillis = song_getmillis()
	if amillis >= song_time_end then
		quit = true
		if res_windowed == 0 then glutLeaveGameMode() end
		glutDestroyWindow(window)
		os.exit(0)
	end

	if quit then return end

	elapsed_time = glutGet(GLUT_ELAPSED_TIME) - fps_time

	spectrum = engine_spectrum()

	width = glutGet(GLUT_WINDOW_WIDTH)
	height = glutGet(GLUT_WINDOW_HEIGHT)

	local textend = 17000
	local flashstart = textend
	local flashend = 17500



	beat = 0

	for i = 0, 50 do
		beat = beat + spectrum[i]
	end

	beat = beat / 51

	if amillis >= flashstart and amillis < flashend then
		flash = beat * 40
		glClearColor(flash,flash/2,flash,1);
		glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)
	else
		glClearColor(0,0,0,1);
		glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)
	end

	glPushMatrix()
		glEnable(GL_MULTISAMPLE)
		glLoadIdentity()
		glOrtho(0, width, 0, height, -100, 100)
		glMatrixMode(GL_MODELVIEW)

		-- time stuff

		millis = glutGet(GLUT_ELAPSED_TIME)


		if amillis >= 0 and amillis < flashstart then
			iorcount2 = iorcount2 + beat*2+amillis*0.0000001
			iornum = ior_textures[(math.ceil(iorcount2)%32)+1]
			renderior2(iornum)
		end

		if amillis >= flashend and amillis < song_time_end then
			glEnable(GL_TEXTURE_2D)
		glEnable(GL_BLEND)

		glBlendFunc(GL_SRC_COLOR, GL_ONE_MINUS_SRC_ALPHA)


			iorcount2 = iorcount2 + beat*10
			iornum = ior_textures[(math.ceil(iorcount2)%32)+1]
			renderior2(iornum)
			renderior3(iornum)

		glBlendFunc(GL_SRC_ALPHA, GL_ONE)
			iorcount = iorcount + beat*20+amillis*0.000001
			iornum = ior_textures[(math.ceil(iorcount)%32)+1]
			renderior(iornum)

		glDisable(GL_BLEND)

		end
		glEnable(GL_BLEND)

		-- effu

		if (amillis >= 0 and amillis < textend) or beat*10 > 0.2 then
			glPushMatrix()
				fs = beat * 10
				glClearColor(fs/3,fs/2,fs/5+math.cos(millis*0.001)*0.2,0.2);
				glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

				glTranslated(0,0,0)
				glEnable(GL_TEXTURE_2D)
				glEnable(GL_BLEND)
				glBlendFunc(GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR)
				if (amillis < 60000) then glBindTexture(GL_TEXTURE_2D, buck_texture)
				else glBindTexture(GL_TEXTURE_2D, text_texture)
				end

				zspeed = amillis*0.000025 + beat*2

				zoomx1 = 0.5-zspeed
				zoomy1 = 0.5-zspeed
				zoomx2 = 0.5+zspeed
				zoomy2 = 0.5+zspeed

				glColor4d(1,1,1,1)
				glBegin(GL_QUADS)
					glTexCoord2d(zoomx1,zoomy1)
					glVertex3d(0,0,0)
					glTexCoord2d(zoomx2,zoomy1)
					glVertex3d(width,0,0)
					glTexCoord2d(zoomx2,zoomy2)
					glVertex3d(width,height,0)
					glTexCoord2d(zoomx1,zoomy2)
					glVertex3d(0,height,0)					
				glEnd()

			glPopMatrix()
		end


		
	glPopMatrix()

	-- RENDERING END

	debug()

	glutSwapBuffers()

	frames = frames + 1
	if elapsed_time > 1000 then
		cur_fps = frames * 1000 / elapsed_time
		fps_time = fps_time + elapsed_time
		frames = 0
	end

end

function renderior(iornum) 
		glPushMatrix()
			glBindTexture(GL_TEXTURE_2D, iornum)

			zspeed = math.cos(amillis*0.00004+iornum)*math.sin(amillis*0.000065+iornum)

			zoomx1 = 0.5-zspeed
			zoomy1 = 0.5-zspeed
			zoomx2 = 0.5+zspeed
			zoomy2 = 0.5+zspeed

			glColor4d(0.5+math.sin(millis*0.0001+iornum)*0.3,0.6+math.sin(millis*0.00015+iornum),0.5+math.sin(millis*0.0001+iornum),0.8+math.cos(millis*0.0001)*0.2)
			glBegin(GL_QUADS)
				glTexCoord2d(zoomx1,zoomy1)
				glVertex3d(0,0,0)
				glTexCoord2d(zoomx2,zoomy1)
				glVertex3d(width,0,0)
				glTexCoord2d(zoomx2,zoomy2)
				glVertex3d(width,height,0)
				glTexCoord2d(zoomx1,zoomy2)
				glVertex3d(0,height,0)					
			glEnd()
		glPopMatrix()
end
function renderior2(iornum) 
		glPushMatrix()
			glBindTexture(GL_TEXTURE_2D, iornum)

			zoomx1 = amillis*0.0001
			zoomy1 = 0
			zoomx2 = amillis*0.0001
			zoomy2 = 1

			glColor4d(0.5+math.cos(millis*0.00014+iornum)*0.3,0.5+math.sin(millis*0.00018+iornum),0.5+math.cos(millis*0.0001+iornum),0.5+math.cos(millis*0.0001)*0.3)
			glBegin(GL_QUADS)
				glTexCoord2d(zoomx1,zoomy1)
				glVertex3d(0,0,0.1)
				glTexCoord2d(zoomx2,zoomy1)
				glVertex3d(width,0,0.1)
				glTexCoord2d(zoomx2,zoomy2)
				glVertex3d(width,height,0.1)
				glTexCoord2d(zoomx1,zoomy2)
				glVertex3d(0,height,0.1)					
			glEnd()
		glPopMatrix()
end
function renderior3(iornum) 
		glPushMatrix()
			glBindTexture(GL_TEXTURE_2D, iornum)

			xo = math.cos(amillis*0.0001+beat*2)*4
			yo = math.sin(amillis*0.00015+beat*3)*4

			zoomx1 = amillis*0.0001-xo
			zoomy1 = amillis*0.0001+xo
			zoomx2 = 1+amillis*0.0001-yo
			zoomy2 = 1+amillis*0.0001+yo
			glTranslated(width/2,height/2,0)
			if amillis > 79000 then glRotated(math.cos(millis*0.0001)*720, 0,0,1) end
			glTranslated(-width/2,-height/2,0)

			glColor4d(0.5+math.cos(millis*0.00014+iornum)*0.3,0.5+math.sin(millis*0.00018+iornum),0.5+math.cos(millis*0.0001+iornum),0.7+math.cos(millis*0.0001)*0.2)
			glBegin(GL_QUADS)
				glTexCoord2d(zoomx1,zoomy1)
				glVertex3d(0,0,0.2)
				glTexCoord2d(zoomx2,zoomy1)
				glVertex3d(width,0,0.2)
				glTexCoord2d(zoomx2,zoomy2)
				glVertex3d(width,height,0.2)
				glTexCoord2d(zoomx1,zoomy2)
				glVertex3d(0,height,0.2)					
			glEnd()
		glPopMatrix()
end

function resize_func(w, h)
	local ratio = w / h
	glMatrixMode(GL_PROJECTION)
	glLoadIdentity()
	if w < h then
		glViewport(0,0,w,w)
		ratio = w/w
	else
		local center_x = 0
		if w > 2560 then 
			center_x = (w / 2) - (2560/2)
			w = 2560
		end
		if h > 1440 then h = 1440
		end
		
		ratio = w / h
		glViewport(center_x,0,w,h)
	end
	gluPerspective(45,ratio,1,10000)
	glMatrixMode(GL_MODELVIEW)
	glLoadIdentity()
	glEnable(GL_DEPTH_TEST)
	glEnable(GL_NORMALIZE)
end

function timer_func()
	if quit then return end

	glutSetWindow(window)
	glutTimerFunc(msec, timer_func, 0)
	glutPostRedisplay()
end

function keyboard_func(key,x,y)
	if key == 27 then
		quit = true
		if res_windowed == 0 then glutLeaveGameMode() end
		glutDestroyWindow(window)
		os.exit(0)
	end
end

function mouse_func(button, state, x , y) 
	--print ("mouse_func button = " .. button .. " state = " .. state .. " x = " .. x .. " y = " .. y)
	mouse_x = x
	mouse_y = y
end

function mouse_entry(state) 
	--print ("mouse_entry state=" .. state)
end

function mouse_motion(x, y) 
	--print ("mouse move x = " .. x .. " y = " .. y)
	mouse_x = x
	mouse_y = y
	
	if debugmode == 1 then
		mouse_over_slider = 0
		
		-- glunproject mouse coordz
	
	end
end

engine_main()




