#include <stdio.h>
#include <malloc.h>
#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>	


int   NP,NF;
int   N,N2;
float **F,**FR,**FG,**FB;
float VAL;
int   fcur,pcur;
int   *VCUBE1,*VCUBE1b;
int   *VCUBE2,*VCUBE2b;
int   *VCUBE3,*VCUBE3b;
float *TP;
int   *TF;
float *RGBP;
float *RGBF;
float *NO;
float TRANSX,TRANSY,TRANSZ;
char  *NEG;

int Envmap1,Envmap2;

int   CONFIG[256][15]=
{
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
/*P0*/    {0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
/*P1*/    {0, 1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 8, 3, 9, 8, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
/*P2*/    {1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 8, 3, 1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {9, 2, 10, 0, 2, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {2, 8, 3, 2, 10, 8, 10, 9, 8, -1, -1, -1, -1, -1, -1},
 /*P3*/   {3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 11, 2, 8, 11, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 9, 0, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 11, 2, 1, 9, 11, 9, 8, 11, -1, -1, -1, -1, -1, -1},
    {3, 10, 1, 11, 10, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 10, 1, 0, 8, 10, 8, 11, 10, -1, -1, -1, -1, -1, -1},
    {3, 9, 0, 3, 11, 9, 11, 10, 9, -1, -1, -1, -1, -1, -1},
    {9, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1},
/*P4*/  {4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 3, 0, 7, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 1, 9, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 1, 9, 4, 7, 1, 7, 3, 1, -1, -1, -1, -1, -1, -1},
    {1, 2, 10, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {3, 4, 7, 3, 0, 4, 1, 2, 10, -1, -1, -1, -1, -1, -1},
    {9, 2, 10, 9, 0, 2, 8, 4, 7, -1, -1, -1, -1, -1, -1},
    {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4, -1, -1, -1},
    {8, 4, 7, 3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {11, 4, 7, 11, 2, 4, 2, 0, 4, -1, -1, -1, -1, -1, -1},
    {9, 0, 1, 8, 4, 7, 2, 3, 11, -1, -1, -1, -1, -1, -1},
    {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1, -1, -1, -1},
    {3, 10, 1, 3, 11, 10, 7, 8, 4, -1, -1, -1, -1, -1, -1},
    {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4, -1, -1, -1},
    {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3, -1, -1, -1},
    {4, 7, 11, 4, 11, 9, 9, 11, 10, -1, -1, -1, -1, -1, -1},
 /*P5*/   {9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {9, 5, 4, 0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 5, 4, 1, 5, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {8, 5, 4, 8, 3, 5, 3, 1, 5, -1, -1, -1, -1, -1, -1},
    {1, 2, 10, 9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {3, 0, 8, 1, 2, 10, 4, 9, 5, -1, -1, -1, -1, -1, -1},
    {5, 2, 10, 5, 4, 2, 4, 0, 2, -1, -1, -1, -1, -1, -1},
    {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8, -1, -1, -1},
    {9, 5, 4, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 11, 2, 0, 8, 11, 4, 9, 5, -1, -1, -1, -1, -1, -1},
    {0, 5, 4, 0, 1, 5, 2, 3, 11, -1, -1, -1, -1, -1, -1},
    {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5, -1, -1, -1},
    {10, 3, 11, 10, 1, 3, 9, 5, 4, -1, -1, -1, -1, -1, -1},
    {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10, -1, -1, -1},
    {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3, -1, -1, -1},
    {5, 4, 8, 5, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1},
    {9, 7, 8, 5, 7, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {9, 3, 0, 9, 5, 3, 5, 7, 3, -1, -1, -1, -1, -1, -1},
    {0, 7, 8, 0, 1, 7, 1, 5, 7, -1, -1, -1, -1, -1, -1},
    {1, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {9, 7, 8, 9, 5, 7, 10, 1, 2, -1, -1, -1, -1, -1, -1},
    {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3, -1, -1, -1},
    {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2, -1, -1, -1},
    {2, 10, 5, 2, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1},
    {7, 9, 5, 7, 8, 9, 3, 11, 2, -1, -1, -1, -1, -1, -1},
    {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11, -1, -1, -1},
    {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7, -1, -1, -1},
    {11, 2, 1, 11, 1, 7, 7, 1, 5, -1, -1, -1, -1, -1, -1},
    {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11, -1, -1, -1},
    {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0},
    {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0},
    {11, 10, 5, 7, 11, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1},
 /*P6*/   {10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 8, 3, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {9, 0, 1, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 8, 3, 1, 9, 8, 5, 10, 6, -1, -1, -1, -1, -1, -1},
    {1, 6, 5, 2, 6, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 6, 5, 1, 2, 6, 3, 0, 8, -1, -1, -1, -1, -1, -1},
    {9, 6, 5, 9, 0, 6, 0, 2, 6, -1, -1, -1, -1, -1, -1},
    {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8, -1, -1, -1},
    {2, 3, 11, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {11, 0, 8, 11, 2, 0, 10, 6, 5, -1, -1, -1, -1, -1, -1},
    {0, 1, 9, 2, 3, 11, 5, 10, 6, -1, -1, -1, -1, -1, -1},
    {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11, -1, -1, -1},
    {6, 3, 11, 6, 5, 3, 5, 1, 3, -1, -1, -1, -1, -1, -1},
    {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6, -1, -1, -1},
    {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9, -1, -1, -1},
    {6, 5, 9, 6, 9, 11, 11, 9, 8, -1, -1, -1, -1, -1, -1},
    {5, 10, 6, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 3, 0, 4, 7, 3, 6, 5, 10, -1, -1, -1, -1, -1, -1},
    {1, 9, 0, 5, 10, 6, 8, 4, 7, -1, -1, -1, -1, -1, -1},
    {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4, -1, -1, -1},
    {6, 1, 2, 6, 5, 1, 4, 7, 8, -1, -1, -1, -1, -1, -1},
    {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7, -1, -1, -1},
    {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6, -1, -1, -1},
    {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9},
    {3, 11, 2, 7, 8, 4, 10, 6, 5, -1, -1, -1, -1, -1, -1},
    {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11, -1, -1, -1},
    {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6, -1, -1, -1},
    {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6},
    {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6, -1, -1, -1},
    {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11},
    {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7},
    {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9, -1, -1, -1},
    {10, 4, 9, 6, 4, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 10, 6, 4, 9, 10, 0, 8, 3, -1, -1, -1, -1, -1, -1},
    {10, 0, 1, 10, 6, 0, 6, 4, 0, -1, -1, -1, -1, -1, -1},
    {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10, -1, -1, -1},
    {1, 4, 9, 1, 2, 4, 2, 6, 4, -1, -1, -1, -1, -1, -1},
    {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4, -1, -1, -1},
    {0, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {8, 3, 2, 8, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1},
    {10, 4, 9, 10, 6, 4, 11, 2, 3, -1, -1, -1, -1, -1, -1},
    {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6, -1, -1, -1},
    {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10, -1, -1, -1},
    {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1},
    {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3, -1, -1, -1},
    {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1},
    {3, 11, 6, 3, 6, 0, 0, 6, 4, -1, -1, -1, -1, -1, -1},
    {6, 4, 8, 11, 6, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {7, 10, 6, 7, 8, 10, 8, 9, 10, -1, -1, -1, -1, -1, -1},
    {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10, -1, -1, -1},
    {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0, -1, -1, -1},
    {10, 6, 7, 10, 7, 1, 1, 7, 3, -1, -1, -1, -1, -1, -1},
    {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7, -1, -1, -1},
    {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9},
    {7, 8, 0, 7, 0, 6, 6, 0, 2, -1, -1, -1, -1, -1, -1},
    {7, 3, 2, 6, 7, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7, -1, -1, -1},
    {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7},
    {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11},
    {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1, -1, -1, -1},
    {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6},
    {0, 9, 1, 11, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0, -1, -1, -1},
    {7, 11, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {3, 0, 8, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 1, 9, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {8, 1, 9, 8, 3, 1, 11, 7, 6, -1, -1, -1, -1, -1, -1},
    {10, 1, 2, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 2, 10, 3, 0, 8, 6, 11, 7, -1, -1, -1, -1, -1, -1},
    {2, 9, 0, 2, 10, 9, 6, 11, 7, -1, -1, -1, -1, -1, -1},
    {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8, -1, -1, -1},
    {7, 2, 3, 6, 2, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {7, 0, 8, 7, 6, 0, 6, 2, 0, -1, -1, -1, -1, -1, -1},
    {2, 7, 6, 2, 3, 7, 0, 1, 9, -1, -1, -1, -1, -1, -1},
    {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6, -1, -1, -1},
    {10, 7, 6, 10, 1, 7, 1, 3, 7, -1, -1, -1, -1, -1, -1},
    {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8, -1, -1, -1},
    {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7, -1, -1, -1},
    {7, 6, 10, 7, 10, 8, 8, 10, 9, -1, -1, -1, -1, -1, -1},
    {6, 8, 4, 11, 8, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {3, 6, 11, 3, 0, 6, 0, 4, 6, -1, -1, -1, -1, -1, -1},
    {8, 6, 11, 8, 4, 6, 9, 0, 1, -1, -1, -1, -1, -1, -1},
    {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6, -1, -1, -1},
    {6, 8, 4, 6, 11, 8, 2, 10, 1, -1, -1, -1, -1, -1, -1},
    {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6, -1, -1, -1},
    {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9, -1, -1, -1},
    {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3},
    {8, 2, 3, 8, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1},
    {0, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8, -1, -1, -1},
    {1, 9, 4, 1, 4, 2, 2, 4, 6, -1, -1, -1, -1, -1, -1},
    {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1, -1, -1, -1},
    {10, 1, 0, 10, 0, 6, 6, 0, 4, -1, -1, -1, -1, -1, -1},
    {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3},
    {10, 9, 4, 6, 10, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 9, 5, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 8, 3, 4, 9, 5, 11, 7, 6, -1, -1, -1, -1, -1, -1},
    {5, 0, 1, 5, 4, 0, 7, 6, 11, -1, -1, -1, -1, -1, -1},
    {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5, -1, -1, -1},
    {9, 5, 4, 10, 1, 2, 7, 6, 11, -1, -1, -1, -1, -1, -1},
    {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5, -1, -1, -1},
    {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2, -1, -1, -1},
    {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6},
    {7, 2, 3, 7, 6, 2, 5, 4, 9, -1, -1, -1, -1, -1, -1},
    {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7, -1, -1, -1},
    {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0, -1, -1, -1},
    {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8},
    {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7, -1, -1, -1},
    {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4},
    {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10},
    {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10, -1, -1, -1},
    {6, 9, 5, 6, 11, 9, 11, 8, 9, -1, -1, -1, -1, -1, -1},
    {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5, -1, -1, -1},
    {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11, -1, -1, -1},
    {6, 11, 3, 6, 3, 5, 5, 3, 1, -1, -1, -1, -1, -1, -1},
    {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6, -1, -1, -1},
    {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10},
    {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5},
    {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3, -1, -1, -1},
    {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2, -1, -1, -1},
    {9, 5, 6, 9, 6, 0, 0, 6, 2, -1, -1, -1, -1, -1, -1},
    {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8},
    {1, 5, 6, 2, 1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6},
    {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0, -1, -1, -1},
    {0, 3, 8, 5, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {10, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {11, 5, 10, 7, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {11, 5, 10, 11, 7, 5, 8, 3, 0, -1, -1, -1, -1, -1, -1},
    {5, 11, 7, 5, 10, 11, 1, 9, 0, -1, -1, -1, -1, -1, -1},
    {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1, -1, -1, -1},
    {11, 1, 2, 11, 7, 1, 7, 5, 1, -1, -1, -1, -1, -1, -1},
    {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11, -1, -1, -1},
    {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7, -1, -1, -1},
    {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2},
    {2, 5, 10, 2, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1},
    {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5, -1, -1, -1},
    {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2, -1, -1, -1},
    {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2},
    {1, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 8, 7, 0, 7, 1, 1, 7, 5, -1, -1, -1, -1, -1, -1},
    {9, 0, 3, 9, 3, 5, 5, 3, 7, -1, -1, -1, -1, -1, -1},
    {9, 8, 7, 5, 9, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {5, 8, 4, 5, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1},
    {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0, -1, -1, -1},
    {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5, -1, -1, -1},
    {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4},
    {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8, -1, -1, -1},
    {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11},
    {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5},
    {9, 4, 5, 2, 11, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4, -1, -1, -1},
    {5, 10, 2, 5, 2, 4, 4, 2, 0, -1, -1, -1, -1, -1, -1},
    {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9},
    {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2, -1, -1, -1},
    {8, 4, 5, 8, 5, 3, 3, 5, 1, -1, -1, -1, -1, -1, -1},
    {0, 4, 5, 1, 0, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5, -1, -1, -1},
    {9, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 11, 7, 4, 9, 11, 9, 10, 11, -1, -1, -1, -1, -1, -1},
    {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11, -1, -1, -1},
    {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11, -1, -1, -1},
    {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4},
    {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2, -1, -1, -1},
    {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3},
    {11, 7, 4, 11, 4, 2, 2, 4, 0, -1, -1, -1, -1, -1, -1},
    {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4, -1, -1, -1},
    {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9, -1, -1, -1},
    {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7},
    {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10},
    {1, 10, 2, 8, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 9, 1, 4, 1, 7, 7, 1, 3, -1, -1, -1, -1, -1, -1},
    {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1, -1, -1, -1},
    {4, 0, 3, 7, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {4, 8, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {9, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {3, 0, 9, 3, 9, 11, 11, 9, 10, -1, -1, -1, -1, -1, -1},
    {0, 1, 10, 0, 10, 8, 8, 10, 11, -1, -1, -1, -1, -1, -1},
    {3, 1, 10, 11, 3, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 2, 11, 1, 11, 9, 9, 11, 8, -1, -1, -1, -1, -1, -1},
    {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9, -1, -1, -1},
    {0, 2, 11, 8, 0, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {3, 2, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {2, 3, 8, 2, 8, 10, 10, 8, 9, -1, -1, -1, -1, -1, -1},
    {9, 10, 2, 0, 9, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8, -1, -1, -1},
    {1, 10, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {1, 3, 8, 9, 1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 9, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {0, 3, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1} 
};



void gradiant(int i,int j,int k,float *N1)
{
  static off;

  if(i+1 >=N) i=N-2;
  if(i-1 <0 ) i=1;
  if(j+1 >=N) j=N-1;
  if(j-1 <0 ) j=1;
  if(k+1 >=N) k=N-2;
  if(k-1 <0 ) k=1;

  off=i+(j<<N2);

  N1[0]=-F[k  ][off+1] + F[k  ][off-1];
  N1[1]=-F[k  ][off+N] + F[k  ][off-N];
  N1[2]=-F[k+1][off  ] + F[k-1][off  ];
}



void init_metalibNEG(int Nshl,int MaxPoints,int MaxFaces,int Env1,int Env2)
{
  int i;
 


     N2  =Nshl;
     N   =1<<Nshl;
     
     /*
     NP  =MaxPoints;
     NF  =MaxFaces;
     TP =(float *)malloc(NP*3*sizeof(float));
     TF =(int   *)malloc(NF*3*sizeof(int  ));
     NEG =(char   *)malloc(NF*sizeof(char  ));     
     N2  =Nshl;
     N   =1<<Nshl;
     */

     F   =(float **)malloc(N*sizeof(float *));
     for(i=0;i<N;i++) {F[i]=(float *)malloc(N*N*sizeof(float));}
     
     /*
     VCUBE1 =(int *)malloc(4*sizeof(int));
     for(i=0;i<4;i++) {VCUBE1[i]=-1;}
     VCUBE1b=(int *)malloc(4*sizeof(int));
     for(i=0;i<4;i++) {VCUBE1b[i]=-1;}
     VCUBE2 =(int *)malloc(4*sizeof(int)*(N-1));
     for(i=0;i<4*(N-1);i++) {VCUBE2[i]=-1;}
     VCUBE2b=(int *)malloc(4*sizeof(int)*(N-1));
     for(i=0;i<4*(N-1);i++) {VCUBE2b[i]=-1;}
     VCUBE3 =(int *)malloc(4*sizeof(int)*(N-1)*(N-1));
     for(i=0;i<4*(N-1)*(N-1);i++) {VCUBE3[i]=-1;}
     VCUBE3b=(int *)malloc(4*sizeof(int)*(N-1)*(N-1));
     for(i=0;i<4*(N-1)*(N-1);i++) {VCUBE3b[i]=-1;}
     */

     Envmap1=Env1;
     Envmap2=Env2;


     TRANSX=(float)N/2.0f;
     TRANSY=(float)N/2.0f;
     TRANSZ=(float)N/2.0f;
         
}



void add_pointNEG_DRAW(int a,int i,int j,int k,float *P,float *No)
{
  static int p,off;
  static float t,Nt;
  static float N1[3],N2[3];

  
     Nt=(float)(N>>1);
     
     off=j*N+i;
     switch(a)
	{
	 case 3  : 
                               t=((float)(-VAL-F[k][off]))/((float)(F[k][off+N]-F[k][off]));
                               P[0]  = (    (float)i - TRANSX)/Nt ;
                               P[1]  = (t + (float)j - TRANSY)/Nt;
                               P[2]  = (    (float)k - TRANSZ)/Nt;
			       gradiant(i,j  ,k,N1);
                               gradiant(i,j+1,k,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);


	           break;
	 case 11 : 
                               t=((float)(-VAL-F[k][off+N]))/((float)(F[k+1][off+N]-F[k][off+N]));
                               P[0]  = (    (float)i  - TRANSX)/Nt;
                               P[1]  = (1 + (float)j  - TRANSY)/Nt;
                               P[2]  = (t + (float)k  - TRANSZ)/Nt;
                               gradiant(i,j+1,k  ,N1);
                               gradiant(i,j+1,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);

                   
	           break;
	 case 7  : 
                               t=((float)(-VAL-F[k+1][off]))/((float)(F[k+1][off+N]-F[k+1][off]));
                               P[0]  = (    (float)i  - TRANSX)/Nt;
                               P[1]  = (t + (float)j  - TRANSY)/Nt;
                               P[2]  = (1 + (float)k  - TRANSZ)/Nt;
                               gradiant(i,j  ,k+1,N1);
                               gradiant(i,j+1,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);

                   
	           break;
	 case 8  : 
                               t=((float)(-VAL-F[k][off]))/((float)(F[k+1][off]-F[k][off]));
                               P[0]  = (   (float)i  - TRANSX)/Nt;
                               P[1]  = (   (float)j  - TRANSY)/Nt;
                               P[2]  = (t + (float)k  - TRANSZ)/Nt;
                               gradiant(i,j  ,k ,N1);
                               gradiant(i,j  ,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);			       

	           break;
	 case 0  : 
                               t=((float)(-VAL-F[k][off]))/((float)(F[k][off+1]-F[k][off]));
                               P[0]  = (t + (float)i  - TRANSX)/Nt;
                               P[1]  = (    (float)j  - TRANSY)/Nt;
                               P[2]  = (    (float)k  - TRANSZ)/Nt;
                               gradiant(i  ,j  ,k  ,N1);
                               gradiant(i+1,j  ,k  ,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       



	           break;
	 case 9  :   t=((float)(-VAL-F[k][off+1]))/((float)(F[k+1][off+1]-F[k][off+1]));
                               P[0]  = (1 + (float)i  - TRANSX)/Nt;
                               P[1]  = (    (float)j  - TRANSY)/Nt;
                               P[2]  = (t + (float)k  - TRANSZ)/Nt;
                               gradiant(i+1,j  ,k,N1);
                               gradiant(i+1,j  ,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);


	           break;
	 case 4  : 
                               t=((float)(-VAL-F[k+1][off]))/((float)(F[k+1][off+1]-F[k+1][off]));
                               P[0]  = (t + (float)i  - TRANSX)/Nt;
                               P[1]  = (    (float)j  - TRANSY)/Nt;
                               P[2]  = (1 + (float)k  - TRANSZ)/Nt;
                               gradiant(i  ,j  ,k+1,N1);
                               gradiant(i+1,j  ,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       

	           break;
 	 case 1  : 
                               t=((float)(-VAL-F[k][off+1]))/((float)(F[k][off+N+1]-F[k][off+1]));
                               P[0]  = (1 + (float)i  - TRANSX)/Nt;
                               P[1]  = (t + (float)j  - TRANSY)/Nt;
                               P[2]  = (    (float)k  - TRANSZ)/Nt;
                               gradiant(i+1,j  ,k,N1);
                               gradiant(i+1,j+1,k,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       

                   break;
 	 case 2  : 
                               t=((float)(-VAL-F[k][off+N]))/((float)(F[k][off+N+1]-F[k][off+N]));
                               P[0]  = (t + (float)i  - TRANSX)/Nt;
                               P[1]  = (1 + (float)j  - TRANSY)/Nt;
                               P[2]  = (    (float)k  - TRANSZ)/Nt;
                               gradiant(i  ,j+1,k,N1);
                               gradiant(i+1,j+1,k,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       

                   break;
	case 10 :  
		     t=((float)(-VAL-F[k][off+N+1]))/((float)(F[k+1][off+N+1]-F[k][off+N+1]));
		     P[0] = (1 + (float)i  - TRANSX)/Nt;
		     P[1] = (1 + (float)j  - TRANSY)/Nt;
		     P[2] = (t + (float)k  - TRANSZ)/Nt;
                     gradiant(i+1,j+1,k  ,N1);
                     gradiant(i+1,j+1,k+1,N2);
                     No[0]=N1[0] + t*(N2[0]-N1[0]);
                     No[1]=N1[1] + t*(N2[1]-N1[1]);
                     No[2]=N1[2] + t*(N2[2]-N1[2]);       
		     

                   break;
	case 5  : 
                   t=((float)(-VAL-F[k+1][off+1]))/((float)(F[k+1][off+N+1]-F[k+1][off+1]));
                   P[0]   = (1 + (float)i  - TRANSX)/Nt;
                   P[1]   = (t + (float)j  - TRANSY)/Nt;
                   P[2]   = (1 + (float)k  - TRANSZ)/Nt;
                   gradiant(i+1,j  ,k+1,N1);
                   gradiant(i+1,j+1,k+1,N2);
                   No[0]=N1[0] + t*(N2[0]-N1[0]);
                   No[1]=N1[1] + t*(N2[1]-N1[1]);
                   No[2]=N1[2] + t*(N2[2]-N1[2]);         
		   
                  break;
	case 6  : 
                   t=((float)(-VAL-F[k+1][off+N]))/((float)(F[k+1][off+N+1]-F[k+1][off+N]));
                   P[0]  = (t + (float)i  - TRANSX)/Nt;
                   P[1]  = (1 + (float)j  - TRANSY)/Nt;
                   P[2]  = (1 + (float)k  - TRANSZ)/Nt;
                   gradiant(i  ,j+1,k+1,N1);
                   gradiant(i+1,j+1,k+1,N2);
                   No[0]=N1[0] + t*(N2[0]-N1[0]);
                   No[1]=N1[1] + t*(N2[1]-N1[1]);
                   No[2]=N1[2] + t*(N2[2]-N1[2]);         
		   

                   break;
	}	
    
}





void add_point_DRAW(int a,int i,int j,int k,float *P,float *No)
{
  static int p,off;
  static float t,Nt;
  static float N1[3],N2[3];
  
  Nt=(float)(N>>1);   


     off=j*N+i;
     switch(a)
	{
	 case 3  : 
                               t=((float)(VAL-F[k][off]))/((float)(F[k][off+N]-F[k][off]));
                               P[0]  = (    (float)i - TRANSX)/Nt ;
                               P[1]  = (t + (float)j - TRANSY)/Nt;
                               P[2]  = (    (float)k - TRANSZ)/Nt;
			       gradiant(i,j,k,N1);
                               gradiant(i,j+1,k,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);


	           break;
	 case 11 : 
                               t=((float)(VAL-F[k][off+N]))/((float)(F[k+1][off+N]-F[k][off+N]));
                               P[0]  = (    (float)i  - TRANSX)/Nt;
                               P[1]  = (1 + (float)j  - TRANSY)/Nt;
                               P[2]  = (t + (float)k  - TRANSZ)/Nt;
                               gradiant(i,j+1,k,N1);
                               gradiant(i,j+1,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);

                   
	           break;
	 case 7  : 
                               t=((float)(VAL-F[k+1][off]))/((float)(F[k+1][off+N]-F[k+1][off]));
                               P[0]  = (    (float)i  - TRANSX)/Nt;
                               P[1]  = (t + (float)j  - TRANSY)/Nt;
                               P[2]  = (1 + (float)k  - TRANSZ)/Nt;
                               gradiant(i,j  ,k+1,N1);
                               gradiant(i,j+1,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);

                   
	           break;
	 case 8  : 
                               t=((float)(VAL-F[k][off]))/((float)(F[k+1][off]-F[k][off]));
                               P[0]  = (    (float)i  - TRANSX)/Nt;
                               P[1]  = (    (float)j  - TRANSY)/Nt;
                               P[2]  = (t + (float)k  - TRANSZ)/Nt;
                               gradiant(i,j  ,k ,N1);
                               gradiant(i,j  ,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);			       

	           break;
	 case 0  : 
                               t=((float)(VAL-F[k][off]))/((float)(F[k][off+1]-F[k][off]));
                               P[0]  = (t + (float)i  - TRANSX)/Nt;
                               P[1]  = (    (float)j  - TRANSY)/Nt;
                               P[2]  = (    (float)k  - TRANSZ)/Nt;
                               gradiant(i  ,j  ,k  ,N1);
                               gradiant(i+1,j  ,k  ,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       



	           break;
	 case 9  :   t=((float)(VAL-F[k][off+1]))/((float)(F[k+1][off+1]-F[k][off+1]));
                               P[0]  = (1 + (float)i  - TRANSX)/Nt;
                               P[1]  = (    (float)j  - TRANSY)/Nt;
                               P[2]  = (t + (float)k  - TRANSZ)/Nt;
                               gradiant(i+1,j  ,k,N1);
                               gradiant(i+1,j  ,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);


	           break;
	 case 4  : 
                               t=((float)(VAL-F[k+1][off]))/((float)(F[k+1][off+1]-F[k+1][off]));
                               P[0]  = (t + (float)i  - TRANSX)/Nt;
                               P[1]  = (    (float)j  - TRANSY)/Nt;
                               P[2]  = (1 + (float)k  - TRANSZ)/Nt;
                               gradiant(i  ,j  ,k+1,N1);
                               gradiant(i+1,j  ,k+1,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       

	           break;
 	 case 1  : 
                               t=((float)(VAL-F[k][off+1]))/((float)(F[k][off+N+1]-F[k][off+1]));
                               P[0]  = (1 + (float)i  - TRANSX)/Nt;
                               P[1]  = (t + (float)j  - TRANSY)/Nt;
                               P[2]  = (    (float)k  - TRANSZ)/Nt;
                               gradiant(i+1,j  ,k,N1);
                               gradiant(i+1,j+1,k,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       

                   break;
 	 case 2  : 
                               t=((float)(VAL-F[k][off+N]))/((float)(F[k][off+N+1]-F[k][off+N]));
                               P[0]  = (t  + (float)i  - TRANSX)/Nt;
                               P[1]  = (1  + (float)j  - TRANSY)/Nt;
                               P[2]  = (     (float)k  - TRANSZ)/Nt;
                               gradiant(i  ,j+1,k,N1);
                               gradiant(i+1,j+1,k,N2);
                               No[0]=N1[0] + t*(N2[0]-N1[0]);
                               No[1]=N1[1] + t*(N2[1]-N1[1]);
                               No[2]=N1[2] + t*(N2[2]-N1[2]);
			       

                   break;
	case 10 :  
		     t=((float)(VAL-F[k][off+N+1]))/((float)(F[k+1][off+N+1]-F[k][off+N+1]));
		     P[0] = (1 + (float)i  - TRANSX)/Nt;
		     P[1] = (1 + (float)j  - TRANSY)/Nt;
		     P[2] = (t + (float)k  - TRANSZ)/Nt;
                     gradiant(i+1,j+1,k  ,N1);
                     gradiant(i+1,j+1,k+1,N2);
                     No[0]=N1[0] + t*(N2[0]-N1[0]);
                     No[1]=N1[1] + t*(N2[1]-N1[1]);
                     No[2]=N1[2] + t*(N2[2]-N1[2]);       
		     

                   break;
	case 5  : 
                   t=((float)(VAL-F[k+1][off+1]))/((float)(F[k+1][off+N+1]-F[k+1][off+1]));
                   P[0]   = (1 + (float)i  - TRANSX)/Nt;
                   P[1]   = (t + (float)j  - TRANSY)/Nt;
                   P[2]   = (1 + (float)k  - TRANSZ)/Nt;
                   gradiant(i+1,j  ,k+1,N1);
                   gradiant(i+1,j+1,k+1,N2);
                   No[0]=N1[0] + t*(N2[0]-N1[0]);
                   No[1]=N1[1] + t*(N2[1]-N1[1]);
                   No[2]=N1[2] + t*(N2[2]-N1[2]);         
		   
                  break;
	case 6  : 
                   t=((float)(VAL-F[k+1][off+N]))/((float)(F[k+1][off+N+1]-F[k+1][off+N]));
                   P[0]  = (t + (float)i  - TRANSX)/Nt;
                   P[1]  = (1 + (float)j  - TRANSY)/Nt;
                   P[2]  = (1 + (float)k  - TRANSZ)/Nt;
                   gradiant(i  ,j+1,k+1,N1);
                   gradiant(i+1,j+1,k+1,N2);
                   No[0]=N1[0] + t*(N2[0]-N1[0]);
                   No[1]=N1[1] + t*(N2[1]-N1[1]);
                   No[2]=N1[2] + t*(N2[2]-N1[2]);         
		   

                   break;
	}

     
}


void cubeNEG(int i,int j,int k)
{
  int    index1,index2;
  int    off;
  int    a1,a2,a3,l;
  char   neg;
  static float P1[3],P2[3],P3[3];
  static float No1[3],No2[3],No3[3];
  
  index1=0;
  neg=0;
  off  =j<<N2;
  if(F[k  ][i + off        ]>VAL) index1   |= 0x01;
  if(F[k  ][i + off + 1    ]>VAL) index1   |= 0x02;
  if(F[k  ][i + off + N + 1]>VAL) index1   |= 0x04;
  if(F[k  ][i + off + N    ]>VAL) index1   |= 0x08;
  if(F[k+1][i + off        ]>VAL) index1   |= 0x10;
  if(F[k+1][i + off + 1    ]>VAL) index1   |= 0x20;
  if(F[k+1][i + off + N + 1]>VAL) index1   |= 0x40;
  if(F[k+1][i + off + N    ]>VAL) index1   |= 0x80;

  index2=0;
  if(F[k  ][i + off        ]<-VAL) index2   |= 0x01;
  if(F[k  ][i + off + 1    ]<-VAL) index2   |= 0x02;
  if(F[k  ][i + off + N + 1]<-VAL) index2   |= 0x04;
  if(F[k  ][i + off + N    ]<-VAL) index2   |= 0x08;
  if(F[k+1][i + off        ]<-VAL) index2   |= 0x10;
  if(F[k+1][i + off + 1    ]<-VAL) index2   |= 0x20;
  if(F[k+1][i + off + N + 1]<-VAL) index2   |= 0x40;
  if(F[k+1][i + off + N    ]<-VAL) index2   |= 0x80;

  
/*printf("VAL=%f,\n",VAL);*/

/*  if (index!=0) printf("index=%d  [%d,%d,%d],\n",index,i,j,k);*/

  l=0; 
  //glColor3f(1.0,0.0,0.0);
  
  glBindTexture(GL_TEXTURE_2D, Envmap1);
  
  glBegin(GL_TRIANGLES);
  
  
 
  while(CONFIG[index1][l]!=-1)
    {
         a1=CONFIG[index1][l  ];
         a2=CONFIG[index1][l+1];
         a3=CONFIG[index1][l+2];      

	 add_point_DRAW(a1,i,j,k,P1,No1);
	 add_point_DRAW(a2,i,j,k,P2,No2);
	 add_point_DRAW(a3,i,j,k,P3,No3);
	 
         glNormal3fv(No1);
         glVertex3fv(P1);
         glNormal3fv(No2);
         glVertex3fv(P2);
         glNormal3fv(No3);
         glVertex3fv(P3);

/*	 printf("%d %d %d\n",a1,a2,a3);
	 printf("%f %f %f\n",x2,y2,z2);
	 printf("%f %f %f\n",x3,y3,z3);*/
        	
         l+=3;
    }
  

  glEnd();
  
  l=0;
  //glColor3f(0.0,1.0,0.0);

  
  glBindTexture(GL_TEXTURE_2D, Envmap2);


  //glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
  
  glBegin(GL_TRIANGLES);

  
  while(CONFIG[index2][l]!=-1)
    {
         a1=CONFIG[index2][l  ];
         a2=CONFIG[index2][l+1];
         a3=CONFIG[index2][l+2];      
		

	 add_pointNEG_DRAW(a1,i,j,k,P1,No1);
	 add_pointNEG_DRAW(a2,i,j,k,P2,No2);
	 add_pointNEG_DRAW(a3,i,j,k,P3,No3);
	 
         glNormal3fv(No1);	 
         glVertex3fv(P1);
         glNormal3fv(No2);	 
         glVertex3fv(P2);
         glNormal3fv(No3);	 
         glVertex3fv(P3);

	 l+=3;
    }

    glEnd();
    
    glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
}


void meta_objectNEG(float **Tp,int **Tf,int *Nf,char **Neg,int *Np, void ( *f)(float **,int),float iso)
{
  int    i,j,k;
  float min,max;

  
      min=99999999.0f;
     max=-1;
     fcur=0;
     pcur=0;     
     VAL=iso;
   
     f(F,N2);
     /*
     dt=2.0/(float)(N-1);
     x=-1;y=-1;z=-1;
     for(k=0;k<N;k++)
       {
         y=-1;
	 for(j=0;j<N;j++)
	   {
             off=j<<N2;
             x=-1;
             for(i=0;i<N;i++)
	       {
		 F[k][off+i]=f(x,y,z);
                 
                 x+=dt;
                 if(F[k][off+i]>max) max=F[k][off+i];
                 if(F[k][off+i]<min) min=F[k][off+i];

	       }
             y+=dt;
	   }
         z+=dt;
       }
     */
     
     
     

/*printf("min=%f\n",min);
printf("max=%f\n",max);*/


     for(k=0;k<N-1;k++)
       {

          for(j=0;j<N-1;j++)
	   {


             for(i=0;i<N-1;i++)
	       {

               /*printf("cube %d %d %d\n",i,j,k);*/
                 cubeNEG(i,j,k);

	       }

	   }

       }
     *Tp=TP;
     *Tf=TF;
     *Nf=fcur;
     *Np=pcur;
     *Neg=NEG;
 
}






