#ifndef __VERTEX_H__
#define __VERTEX_H__


#define PI 3.1415926535897932

#define BEHIND		0
#define INTERSECTS	1
#define FRONT		2



//===================================================================
//		Class CVertex
//===================================================================


class CVertex
{
	public:

		float x, y, z;						

		CVertex(void);
		~CVertex(void);

		CVertex(float num);
		CVertex(float X, float Y, float Z);

		void operator = (float num);
		void operator = (CVertex vVector);

		CVertex operator + (float num);
		CVertex operator + (CVertex vVector);
		void operator += (float num);
		void operator += (CVertex vVector);

		CVertex operator - (float num);
		CVertex operator - (CVertex vVector);
		void operator -= (float num);
		void operator -= (CVertex vVector);
	
		CVertex operator * (float num);
		CVertex operator * (CVertex vVector);
		void operator *= (float num);
		void operator *= (CVertex vVector);

		CVertex operator / (float num);
		CVertex operator / (CVertex vVector);
		void operator /= (float num);
		void operator /= (CVertex vVector);

		bool operator == (CVertex vVector);
		bool operator != (CVertex vVector);
};



//===================================================================
//		ASM Vertexes transformations - voids declarations
//===================================================================


float ASMDotProduct(CVertex & a_cVec1, CVertex & a_cVec2);
void  ASMComputeNormal(CVertex & a_cVec0, CVertex & a_cVec1, CVertex & a_cVec2, CVertex & a_vDest);
void  ASMCrossProduct(CVertex & a_vP0, CVertex & a_vP1, CVertex & a_vDest);
float ASMAngleOfSeperation(CVertex & a_vP0, CVertex & a_vP1);
void  ASMCalculate3dRotation(float a_fPitch, float a_fYaw, CVertex & a_vPt);


#endif
