#include "kexplo.h"

GLuint TexSky[6];

// Frustum de la cam
CFrustum *frustum;

// Rayon du balayage des fichiers
int View_Max;



CRepertoire::CRepertoire(char *dir)
{
	HANDLE find;
	WIN32_FIND_DATA file;
	
	Taille_Fichier = 20.0f;
	View_Max = 10;

	Nb_Fichiers = Dir_Count_Items(dir);
	
	chdir(dir);

	// Allocate les tableaux
	Fichiers = new Fichier[Nb_Fichiers];
	Size_x = (int)(sqrt(Nb_Fichiers));
	Size_z = (int)(Nb_Fichiers/Size_x);
	if(Size_x*Size_z<Nb_Fichiers) Size_z++;

	if(Size_x*Size_z<Nb_Fichiers)
	{
		Error("File allocation error");
		K_EXIT = true;
		return;
	}

	Tableau = new int[Size_x*Size_z];

	V_Order = new int[(View_Max*2)*(View_Max*2)];
	Z_Order = new float[(View_Max*2)*(View_Max*2)];

	pos = new CVertex[(View_Max*2)*(View_Max*2)];

	// Initialisation du tableau (le tri sera  placer ici)
	long i, j = 0;

	while(j<Size_z)
	{
		i = 0;
		
		while(i<Size_x)
		{
			if(j*Size_x+i<Nb_Fichiers)
				Tableau[j*Size_x+i] = j * Size_x + i;
			else Tableau[j*Size_x+i] = -1;
			i++;
		}

		j++;
	}
	

	// Mmorisation des structures des fichiers
	int n, m, k = 0;
	find = FindFirstFile("*.*", &file);
	
	if(find==INVALID_HANDLE_VALUE)
	{
		Error("Directory corrupted");
		Nb_Fichiers = 0;
		return;
	}

    do
    {
		if(!(strlen(file.cFileName)<=2 && file.cFileName[0]=='.'))
		{

		// Mmorisation du nom
		m = 0;
		n = strlen(file.cFileName);
		char *c;
		
		Fichiers[k].name = new char[n+1];

		while(m<n)
		{
			c = strlwr(&file.cFileName[m]);
			Fichiers[k].name[m] = c[0];
			m++;
		}
		
		Fichiers[k].name[n] = '\0';
					
		// Mmorisation du type
		Fichiers[k].att = Make_Attrib(file.dwFileAttributes);
		Fichiers[k].col = Calc_color(&Fichiers[k].att);

		// Mmorisation des dates
		FILETIME tmp;

		tmp = file.ftCreationTime;
		FileTimeToSystemTime(&tmp, &Fichiers[k].born);
		tmp = file.ftLastAccessTime;
		FileTimeToSystemTime(&tmp, &Fichiers[k].writ);
		tmp = file.ftLastWriteTime;
		FileTimeToSystemTime(&tmp, &Fichiers[k].seen);
		
		// Mmorisation de la taille
		Fichiers[k].size = file.nFileSizeLow;


		// Calcul de la hauteur du bloc suivant la taille et le type 
		if(Fichiers[k].att.dir==true)
		{
			Fichiers[k].y = Taille_Fichier * 6.0f;
		}
		else
		{
			Fichiers[k].y = Taille_Fichier + Fichiers[k].size / 60000.0f;
			if(Fichiers[k].y>Taille_Fichier * 14.0f)
				Fichiers[k].y = Taille_Fichier * 14.0f;
		}

		k++;
		}
	}
	while(FindNextFile(find, &file) && k<Nb_Fichiers);
	
	FindClose(find);

	if(k!=Nb_Fichiers)
	{
		Error("Bad files count"); 
		Nb_Fichiers = 0;
		K_EXIT = true;
	}

	if(Nb_Fichiers == 0) Error("Pas de fichier");

}



CRepertoire::~CRepertoire()
{
	for(int i=0 ; i<Nb_Fichiers ; i++)
		delete[] Fichiers[i].name;

	Nb_visible = 0;
	Nb_Fichiers = 0;
	Size_x = 0;
	Size_z = 0;
	delete[] Tableau;
	delete[] Fichiers;
	delete[] V_Order;
	delete[] Z_Order;
	delete[] pos;
}





int CRepertoire::Draw(float scale)
{
	if(Nb_Fichiers==0) return -1;

	float x_c, z_c;
	int i=0, j=0;
	float deg=1.0f;
	int ret = -1;
	float dist = 2000.0f;
	CVertex inter;

	if(cam->m_vPosition.y<4.0f)
	{
		cam->m_vView.y += (4.0f - cam->m_vPosition.y);
		cam->m_vPosition.y = 4.0f;
	}

	// Recherche des fichiers visibles

	Nb_visible = 0;

	x_c = cam->m_vPosition.x / (Taille_Fichier*3.0f*scale);
	z_c = cam->m_vPosition.z / (Taille_Fichier*3.0f*scale);

	for(j=(z_c-View_Max) ; j<(z_c+View_Max) ; j++)
	if(j>=0 && j<Size_z)
	for(i=(x_c-View_Max) ; i<(x_c+View_Max) ; i++)
	{
		if(i>=0 && i<Size_x)
		if(Tableau[j*Size_x+i]>=0 && Tableau[j*Size_x+i]<Nb_Fichiers)
		if(frustum->CubeInFrustum(i*(Taille_Fichier*3.0f)*scale, Fichiers[Tableau[j*Size_x+i]].y*scale/2.0f, j*(Taille_Fichier*3.0f)*scale, Fichiers[Tableau[j*Size_x+i]].y*scale))
		if(Nb_visible<(View_Max*2)*(View_Max*2))
		{
			V_Order[Nb_visible] = Tableau[j*Size_x+i];
			Z_Order[Nb_visible] = (float)( sqrt( pow(j-z_c,2) + pow(i-x_c,2) ) );
			pos[Nb_visible].x = i*(Taille_Fichier*3.0f*scale);
			pos[Nb_visible].z = j*(Taille_Fichier*3.0f*scale);
			Nb_visible++;
		}
	}

	
	// Tri des fichiers visible suivant leur distance par rapport  la cam
	
	if(Nb_visible>1)
		Sort_Files(0, Nb_visible-1);


	// Initialisation du brouillard
	glFogi(GL_FOG_COORDINATE_SOURCE_EXT, GL_FOG_COORDINATE_EXT);
	glFogi(GL_FOG_MODE, GL_LINEAR);			
	glFogfv(GL_FOG_COLOR, FogColor);		
	glFogf(GL_FOG_START, 0.0);				
	glFogf(GL_FOG_END, FogDepth);				

	// Affichage du ciel
	Draw_Sky();

	// Affichage du sol
	Draw_Floor();


	// Affichage des fichiers visibles
	int m = 0;
	bool sel;
	float d;
	CVertex pol1[4], pol2[4];
	CVertex lin[2];

	lin[0] = cam->m_vPosition;
	lin[1] = cam->m_vPosition + (cam->m_vView-cam->m_vPosition) * dist;

	// gros code de porc pour le test de slection (porc comme le reste)
	for(i=0 ; i<Nb_visible ; i++)
	if(V_Order[i]>=0 && V_Order[i]<Nb_Fichiers)
	{
		pol1[0].x = pos[i].x - Taille_Fichier * scale / 1.5f;
		pol1[0].y = Fichiers[V_Order[i]].y * scale;
		pol1[0].z = pos[i].z;
		pol1[1].x = pos[i].x + Taille_Fichier * scale / 1.5f;
		pol1[1].y = Fichiers[V_Order[i]].y * scale;
		pol1[1].z = pos[i].z;
		pol1[2].x = pos[i].x + Taille_Fichier * scale / 1.5f;
		pol1[2].y = 0.0f;
		pol1[2].z = pos[i].z;
		pol1[3].x = pos[i].x - Taille_Fichier * scale / 1.5f;
		pol1[3].y = 0.0f;
		pol1[3].z = pos[i].z;
		pol2[0].x = pos[i].x;
		pol2[0].y = Fichiers[V_Order[i]].y * scale;
		pol2[0].z = pos[i].z - Taille_Fichier * scale / 1.5f;
		pol2[1].x = pos[i].x;
		pol2[1].y = Fichiers[V_Order[i]].y * scale;
		pol2[1].z = pos[i].z + Taille_Fichier * scale / 1.5f;
		pol2[2].x = pos[i].x;
		pol2[2].y = 0.0f;
		pol2[2].z = pos[i].z + Taille_Fichier * scale / 1.5f;
		pol2[3].x = pos[i].x;
		pol2[3].y = 0.0f;
		pol2[3].z = pos[i].z - Taille_Fichier * scale / 1.5f;

		if(IntersectedPolygon(pol1, lin, 4)==true)
		{
			inter = IntersectedPolygonV(pol1, lin, 4);
			d = sqrt( pow(inter.x-cam->m_vPosition.x,2) + pow(inter.y-cam->m_vPosition.y,2) + pow(inter.z-cam->m_vPosition.z,2) );
			
			if(d<dist)	// alors le fichier est slectionn, normal
			{
				ret = V_Order[i];
				dist = d;
			}
		}
			
		if(IntersectedPolygon(pol2, lin, 4)==true)
		{
			inter = IntersectedPolygonV(pol2, lin, 4);
			d = sqrt( pow(inter.x-cam->m_vPosition.x,2) + pow(inter.y-cam->m_vPosition.y,2) + pow(inter.z-cam->m_vPosition.z,2) );
			
			if(d<dist)	// alors le fichier est slectionn, normal
			{
				ret = V_Order[i];
				dist = d;
			}
		}
	}
	
	for(i=0 ; i<Nb_visible ; i++)
	if(V_Order[i]>=0 && V_Order[i]<Nb_Fichiers)
	{
		deg = 1.0f - Z_Order[i] / (View_Max/1.0f);
		if(deg<0.0f) deg = 0.0f;


		sel = false;

		if(V_Order[i]==ret) 
			sel = true;
		
		if(deg>0.95f) deg = 0.95f + 1.0f-pow(1.0f-(0.95f-deg),2);
		if(deg>0.85f && deg<=0.95f)
			deg = 0.85f + sin((deg-0.85)*3.14/0.2)*0.1; 
		Mk_Tri(i, scale);

		Draw_File(&Fichiers[V_Order[i]], pos[i].x, pos[i].z, scale, deg, tri, sel);
	}

	return ret;
}




// Tri des fichiers visibles
void CRepertoire::Sort_Files(int deb, int fin)
{
	int i=deb;
	int j=fin;
	int   tmp_v;
	float tmp_z;
	float milieu = Z_Order[(deb+fin)/2];
	CVertex tmp_p;

	while(i<=j)
	{
		while(Z_Order[i]>milieu) i++;
		while(Z_Order[j]<milieu) j--;

		if(i<=j)
		{
			// On inverse tout
			tmp_z=Z_Order[i];
			Z_Order[i]=Z_Order[j];
			Z_Order[j]=tmp_z;
			tmp_v=V_Order[i];
			V_Order[i]=V_Order[j];
			V_Order[j]=tmp_v;
			tmp_p = pos[i];
			pos[i] = pos[j];
			pos[j] = tmp_p;
			i++; 
			j--;
		}
	}

	if(i<fin) Sort_Files(i, fin);
	if(deb<j) Sort_Files(deb, j);
}





void CRepertoire::Mk_Tri(int i, float scale)
{
	int m=0;
	int j;

	tri[0] = -1;

	if(cam->m_vPosition.y<Fichiers[V_Order[i]].y*scale)
		tri[0] = TRI_TOP;
	else tri[4] = TRI_TOP;

	if(tri[0]!=-1)
		m++;
	
	bool f=false;
	bool f2 = false;

	for(int k=0 ; k<2 ; k++)
	{
		if(k==0) j = 3;
		if(k==1) j = 1;

		if(f2==true || (f==false && (cam->m_vPosition.x<pos[i].x-Taille_Fichier * scale / 1.5f || cam->m_vPosition.x>pos[i].x+Taille_Fichier * scale / 1.5f)))
		{
			if(cam->m_vPosition.x<pos[i].x)
			{
				tri[m]   = TRI_RIGHT;
				tri[m+j] = TRI_LEFT;
				m++;
			}
			else
			{
				tri[m]   = TRI_LEFT;
				tri[m+j] = TRI_RIGHT;
				m++;
			}

			f = true;
		}
		else
		{
			if(cam->m_vPosition.z>pos[i].z)
			{
				tri[m]   = TRI_BACK;
				tri[m+j] = TRI_FRONT;
				m++;
			}
			else
			{
				tri[m]   = TRI_FRONT;
				tri[m+j] = TRI_BACK;
				m++;
			}

			f2 = true;
		}
	}
}





void CRepertoire::Draw_Floor()
{
	float s = 1500.0f;
	float u, v;
	CVertex c = 1.0f;

	u = -cam->m_vPosition.x * 5.0f / s;
	v = cam->m_vPosition.z * 5.0f / s;

	glEnable(GL_FOG);

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, Textures[1]);

	glTranslatef(cam->m_vPosition.x, 0.0f, cam->m_vPosition.z);
	
	glColor3f(1.0f, 1.0f, 1.0f);


	glEnable(GL_BLEND);					
	glBlendFunc(GL_ONE, GL_SRC_ALPHA);	
		
	glBegin(GL_TRIANGLES);
	
	Set_Fog(0.0f, 0.0f);
	glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
	glTexCoord2f(0.0f+u, 10.0f+v);    
	glVertex3f( s, 0.0f,  s);
	glTexCoord2f(0.0f+u, 0.0f+v);    
	glVertex3f( s, 0.0f, -s); 
	Set_Fog(0.0f, 1.0f);
	glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
	glTexCoord2f(5.0f+u, 5.0f+v);    
	glVertex3f( 0.0f, 0.0f, 0.0f); 
	
	Set_Fog(0.0f, 0.0f);
	glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
	glTexCoord2f(0.0f+u, 0.0f+v);    
	glVertex3f( s, 0.0f, -s); 
	glTexCoord2f(10.0f+u, 0.0f+v);    
	glVertex3f(-s, 0.0f, -s);
	Set_Fog(0.0f, 1.0f);
	glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
	glTexCoord2f(5.0f+u, 5.0f+v);    
	glVertex3f( 0.0f, 0.0f, 0.0f); 

	Set_Fog(0.0f, 0.0f);
	glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
	glTexCoord2f(10.0f+u, 0.0f+v);    
	glVertex3f(-s, 0.0f, -s);
	glTexCoord2f(10.0f+u, 10.0f+v);    
	glVertex3f(-s, 0.0f,  s);
	Set_Fog(0.0f, 1.0f);
	glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
	glTexCoord2f(5.0f+u, 5.0f+v);    
	glVertex3f( 0.0f, 0.0f, 0.0f); 


	Set_Fog(0.0f, 0.0f);
	glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
	glTexCoord2f(0.0f+u, 10.0f+v);    
	glVertex3f( s, 0.0f,  s);
	glTexCoord2f(10.0f+u, 10.0f+v);    
	glVertex3f(-s, 0.0f,  s);
	Set_Fog(0.0f, 1.0f);
	glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
	glTexCoord2f(5.0f+u, 5.0f+v);    
	glVertex3f( 0.0f, 0.0f, 0.0f); 

	glEnd();




	glTranslatef(-cam->m_vPosition.x, 0.0f, -cam->m_vPosition.z);

	glDisable(GL_FOG);
	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
}



void CRepertoire::Draw_Sky()
{
	float x, y, z, width, height, length;

	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);

	glColor3f(1.0f, 1.0f, 1.0f);

	glTranslatef(cam->m_vPosition.x, cam->m_vPosition.y, cam->m_vPosition.z);

	width  = 200.0f;
	height = 200.0f;
	length = 200.0f;

	x = - width  / 2;
	y = 50.0f - height / 2;
	z = - length / 2;

	glBindTexture(GL_TEXTURE_2D, TexSky[0]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glBegin(GL_QUADS);		
		glTexCoord2f(1.0f, 0.0f); glVertex3f(x + width, y,			z);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(x + width, y + height, z); 
		glTexCoord2f(0.0f, 1.0f); glVertex3f(x,			y + height, z);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(x,			y,			z);
		
	glEnd();

	glBindTexture(GL_TEXTURE_2D, TexSky[0]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glBegin(GL_QUADS);	
		glTexCoord2f(1.0f, 0.0f); glVertex3f(x,			y,			z + length);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(x,			y + height, z + length);
		glTexCoord2f(0.0f, 1.0f); glVertex3f(x + width, y + height, z + length); 
		glTexCoord2f(0.0f, 0.0f); glVertex3f(x + width, y,			z + length);
	glEnd();

	glBindTexture(GL_TEXTURE_2D, TexSky[0]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glBegin(GL_QUADS);		
		glTexCoord2f(0.0f, 1.0f); glVertex3f(x + width, y + height, z);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(x + width, y + height, z + length); 
		glTexCoord2f(1.0f, 0.0f); glVertex3f(x,			y + height,	z + length);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(x,			y + height,	z);
	glEnd();

	glBindTexture(GL_TEXTURE_2D, TexSky[0]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glBegin(GL_QUADS);		
		glTexCoord2f(0.0f, 1.0f); glVertex3f(x + width, y, z);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(x + width, y, z + length); 
		glTexCoord2f(1.0f, 0.0f); glVertex3f(x,			y,	z + length);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(x,			y,	z);
	glEnd();

	glBindTexture(GL_TEXTURE_2D, TexSky[0]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glBegin(GL_QUADS);		
		glTexCoord2f(1.0f, 1.0f); glVertex3f(x,			y + height,	z);	
		glTexCoord2f(0.0f, 1.0f); glVertex3f(x,			y + height,	z + length); 
		glTexCoord2f(0.0f, 0.0f); glVertex3f(x,			y,			z + length);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(x,			y,			z);		
	glEnd();

	glBindTexture(GL_TEXTURE_2D, TexSky[0]);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glBegin(GL_QUADS);		
		glTexCoord2f(0.0f, 0.0f); glVertex3f(x + width, y,			z);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(x + width, y,			z + length);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(x + width, y + height,	z + length); 
		glTexCoord2f(0.0f, 1.0f); glVertex3f(x + width, y + height,	z);
	glEnd();


	glTranslatef(-cam->m_vPosition.x, -cam->m_vPosition.y, -cam->m_vPosition.z);

	glEnable(GL_DEPTH_TEST);
}



