#include "kexplo.h"



void DecodeJPG(jpeg_decompress_struct* cinfo, tImageJPG *pImageData)
{
	int rowsRead = 0;
	unsigned char** rowPtr;
	int i;

	jpeg_read_header(cinfo, TRUE);
	jpeg_start_decompress(cinfo);

	pImageData->rowSpan = cinfo->image_width * cinfo->num_components;
	pImageData->sizeX   = cinfo->image_width;
	pImageData->sizeY   = cinfo->image_height;
	
	pImageData->data = new unsigned char[pImageData->rowSpan * pImageData->sizeY];
		
	rowPtr = new unsigned char*[pImageData->sizeY];
	
	for (i = 0; i < pImageData->sizeY; i++)
		rowPtr[i] = &(pImageData->data[i*pImageData->rowSpan]);

	while (cinfo->output_scanline < cinfo->output_height) 
		rowsRead += jpeg_read_scanlines(cinfo, &rowPtr[rowsRead], cinfo->output_height - rowsRead);
	
	delete [] rowPtr;

	jpeg_finish_decompress(cinfo);
}




tImageJPG *LoadJPG(const char *filename)
{
	struct jpeg_decompress_struct cinfo;
	tImageJPG *pImageData = NULL;
	FILE *pFile;
		
	if((pFile = fopen(filename, "rb")) == NULL) 
		return NULL;
	
	jpeg_error_mgr jerr;
	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_decompress(&cinfo);
	jpeg_stdio_src(&cinfo, pFile);
	pImageData = (tImageJPG*)malloc(sizeof(tImageJPG));
	DecodeJPG(&cinfo, pImageData);
	jpeg_destroy_decompress(&cinfo);
	
	fclose(pFile);

	return pImageData;
}


void CreateTexture(GLuint textureArray[], LPSTR strFileName, int textureID)
{
	if(!strFileName)								
		return;

	tImageJPG *pImage = LoadJPG(strFileName);			

	if(pImage == NULL)								
		MessageBox(NULL,strFileName,"-=(Status)=-",MB_OK);

	glGenTextures(1, &textureArray[textureID]);
	glBindTexture(GL_TEXTURE_2D, textureArray[textureID]);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, pImage->sizeX, pImage->sizeY, GL_RGB, GL_UNSIGNED_BYTE, pImage->data);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR_MIPMAP_LINEAR);	
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);


	if (pImage)									
	{
		if (pImage->data)							
			free(pImage->data);						

		free(pImage);								
	}
}
