#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include "extra.h"

void drawImg(SDL_Surface *desti, SDL_Surface *img, int x, int y) {
	SDL_Rect dest;
	dest.x = x;
	dest.y = y;
	//dest.w = img->w;
	//dest.h = img->h;
	
	SDL_SetColorKey(desti,SDL_SRCCOLORKEY,SDL_MapRGB(desti->format, 255,0,255));
	SDL_BlitSurface(img, NULL,  desti, &dest);
}

void drawImg2(SDL_Surface *desti, SDL_Surface *img, int x, int y, int w, int h, int x2, int y2) {
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_Rect dest2;
  dest2.x = x2;
  dest2.y = y2;
  dest2.w = w;
  dest2.h = h;
  SDL_BlitSurface(img, &dest2, desti, &dest);
}


void drawImgAlpha(SDL_Surface *desti, SDL_Surface *img, int x, int y, int alpha) {
	SDL_Rect dest;
	dest.x = x;
	dest.y = y;
	//dest.w = img->w;
	//dest.h = img->h;
	
	SDL_SetColorKey(desti,SDL_SRCCOLORKEY,SDL_MapRGB(desti->format, 255,0,255));
	SDL_BlitSurface(img, NULL,  desti, &dest);

        sge_FilledRectAlpha(desti, x, y, x+img->w, y+img->h, SDL_MapRGB(desti->format,0,0,0), 255-alpha);
}

void drawPixel(SDL_Surface *screen, int x, int y, Uint8 r, Uint8 g, Uint8 b) {
	sge_PutPixel(screen, x, y, SDL_MapRGB(screen->format, r, g, b));
}

/*
void drawPixel(SDL_Surface *screen, int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
  Uint32 color;
  color	= SDL_MapRGB(screen->format, R, G, B);
  switch (screen->format->BytesPerPixel)
  {
    case 1: // Assuming 8-bpp
      {
        Uint8 *bufp;
        bufp = (Uint8 *)screen->pixels + y*screen->pitch + x;
        *bufp = color;
      }
      break;
    case 2: // Probably 15-bpp or 16-bpp
      {
        Uint16 *bufp;
        bufp = (Uint16 *)screen->pixels + y*screen->pitch/2 + x;
        *bufp = color;
      }
      break;
    case 3: // Slow 24-bpp mode, usually not used
      {
        Uint8 *bufp;
        bufp = (Uint8 *)screen->pixels + y*screen->pitch + x * 3;
        if(SDL_BYTEORDER == SDL_LIL_ENDIAN)
        {
          bufp[0] = color;
          bufp[1] = color >> 8;
          bufp[2] = color >> 16;
        } else {
          bufp[2] = color;
          bufp[1] = color >> 8;
          bufp[0] = color >> 16;
        }
      }
      break;
    case 4: // Probably 32-bpp
      {
        Uint32 *bufp;
        bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x;
        *bufp = color;
      }
      break;
  }
}

*/

void line(SDL_Surface *screen, int x0, int y0, int x1, int y1, int color) {

	//sge_Line(screen, x0-1+110, y0-15, x1-1+110, y1-15, SDL_MapRGB(screen->format, 255,255,255));
	//sge_Line(screen, x0+1+110, y0-15, x1+1+110, y1-15, SDL_MapRGB(screen->format, 255,255,255));
  	
	sge_Line(screen, x0, y0, x1, y1, SDL_MapRGB(screen->format, 0,255,0));

}


void mirrorImg(SDL_Surface *src) {

	SDL_Surface *tmp = SDL_CreateRGBSurface( SDL_HWSURFACE, src->w, src->h,
                                  						src->format->BitsPerPixel,
                                  						src->format->Rmask,
                                  						src->format->Gmask,
                                  						src->format->Bmask,
                                  						src->format->Amask);		
	
	//SDL_SetColorKey(tmp,SDL_SRCCOLORKEY,SDL_MapRGB(tmp->format, 0,0,0));

	
	int i;
	for (i = 0; i < src->w; i++) 
			drawImg2(tmp, src, i, 0, 1, src->h, src->w - i, 0); 
	

	drawImg(src, tmp, 0, 0);
		
	SDL_FreeSurface(tmp);
		
}
		

int toInt(float number) {
        if (number < 0) {
                number = -number;
                return -(int)(number+0.5f);
        }
        else {
                return (int)(number+0.5f);
        }
}
