/* SDL Setup */
#define FULLSCREEN 1
#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 480
#define BOX_WIDTH 640
#define BOX_HEIGHT 300

#include <stdlib.h>
#include <math.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

/* if this doesn't work, and you've got SGE/fmod installed,
    uncomment the lines below, and comment the other ones.. */
		
/* #include <SDL/sge.h> */
/* #include <fmod.h> */
#include "extras/sge.h"
#include "extras/fmod.h"
#include "extra.h"


typedef struct
{
  int x,y, oldx, oldy;
} sinscroller_type;


typedef struct
{
  int x,y, oldx, oldy;
  
} amigascroller_type;

typedef struct
{
  	int x,y;
	int last_frame_time;
	int num_frames;
	int cur_frame;
	int duration;
	SDL_Surface *ani[12];
} anim_type;

typedef struct
{
  	int x,y,z;
	int speed_x;
	int num_frames;
	int cur_frame;
	int duration;
	int sinheight;
} snow_type;

typedef struct
{
  int x,y;
  int speed_x;
  int speed_y;
  int speed_x_factor;
 int speed_y_factor;
  int ballrotate;
  float ballscale;
  int ballspeed;
	int ballspeed_factor;
	int sinx, siny;
	int oldx, oldy;
} ball_type;


/* Globala variabler */
int currentScene = 0;
int currentEffect = 0;

snow_type snow[200];
anim_type hello,dance, ball;
sinscroller_type sinscroller[600];
ball_type amigaball[100];
amigascroller_type amigascroller[8];

/* fadevariabler */
int fadeInOutTrans = 0;
int fadeInOutTime = 0;
int fadeInOutDir = 1;
int fadeInOutFinished = 0;
int fadeTo = 0;
int mainTrans = 0;
char intromessage[] = "           #HEY THERE!                   #I AM KEZO...                 #YOU MIGHT KNOW WHO I AM...          <BACK IN THE OLD DAYS I <USED TO ARRANGE KICK-ASS  <LAN PARTIES!                         #THEN SUDDENLY EVERYTHING <CHANGED...                      #NOBODY WANTED TO COME PLAY WITH <ME ANYMORE...                   #WHERE IS EVERYBODY I ASK MYSELF?           <WHAT ARE THEY DOING?                 #AND WHY DID FULMUST CHOOSE THIS  <PICTURE OF ME WHERE I TELL <YOU TO FUCK OFF?                      #IN FACT, I DON'T KNOW WHY...            #IN FACT, I WOULD LIKE TO INVITE <YOU TO THE GREATEST LAN <PARTY OF ALL TIME!                 #<         SATURNUS LAN      <   - XMAS EDITION 2005  -                   #OMGROTFLOLBBQ!!!ONE11 <YOU MIGHT HAVE BURSTED OUT <RIGHT NOW...         #BUT I AM TELLING YOU...     <THIS WILL HAPPEN!    <  #AWESOME COMPOS WILL BE HELD...              #EVEN GINGERBREAD EATING COMPOS< WILL BE HELD!               #AND DONT FORGET THE SAUNA <AND THE ALCOHOL!               #SO PLEASE... COME TO SATURNUS..  <SATURNUS LAN.. DAR FOLKET AR <GLADA OCH HAR KUL SOM FAN...              #SATURNUS LAN WILL TAKE <PLACE 17 - 19 DECEMBER                  #I WILL TELL YOU TO FUCK OFF <IF YOU CANT MAKE IT THERE...             #REALLY...     <I AM NOT JOKING...           <I AM REALLY STRONG...           #I WILL KICK YOUR ASS IF <YOU DONT SHOW UP...               #SERIOUSLY, I AM EXTREMELY WELL <TRAINED...               #SO BE THERE...                  #I REALLY MEAN IT..          <I KNOW PEOPLE WHO CAN <HURT YOU REALLY BAD...             #NO.. IM JUST KIDDING...                   #OR AM I?                       #ANYWAYS...                #THIS INVITRO WAS BROUGHT <TO YOU BY...                #CODE AND GFX:  <FULMUST - CODER GURU <MUSIC AND GFX:   <FEGOLHUZZ - TRACKER GURU                #            ARGH!          <   SATURNUS LAN XMAS 2005<      17-19 DECEMBER     <     WWW.KAKMONSTER.COM                      @" ;

char *currentsection = intromessage;
int lastprint = 0;
int msgpos = 0;
int printer_finished=0;
											
											
/* fps ind */								
int td2,td;
float dt = 0;
int lastframe;

/* SDL-meck & annat */
SDL_Surface *screen;
SDL_Surface *img_snowflake, *img_snowflake2, *img_snowflake3;
SDL_Surface *img_top, *img_bottom, *img_top_bar, *img_tomte,*img_bar, *img_bar_1,*img_snow_down, *img_shaddow, *img_bubbla;
SDL_Surface *tmp_rotate, *img_satlogga, *img_satlogga_skugga, *img_border_nere, *img_border_uppe;
SDL_Surface *img_amigabars[5];
SDL_Event event;
sge_bmpFont *font,*font_intro,*font_intro_inverted;


/* plasmaeffekt */
int plasma[BOX_WIDTH][BOX_HEIGHT];
SDL_Color  buffer[BOX_WIDTH][BOX_HEIGHT];
static SDL_Color colors[256];


/* bajsfunktionen som teleporterar in en bild */
int bajs_cur_x = 0;
SDL_Surface *img_bajs;
SDL_Surface *bajssurface[15];
int lastbajs = 0;
int currentbajs  = 0;


/* fpscounter */
int lastfpsframe = 0;
int fpscounter = 0;
int lastfpscounter = 0;

/* sn */
int snowspeed = 1;
int snowheight = 1;

/* vrigt */
int bgtextx[200];
int bgtextx2[200];
float *spectrum;
int sluttrans = 0;
FSOUND_SAMPLE *handle_sound;

/* funktioner.. */

void initMusic() {

  	FSOUND_Init (44100, 32, 0);
	
 	//FMUSIC_StopSong(handle);
 	//handle = FMUSIC_LoadSong ("data/klappa.xm");
	//FMUSIC_PlaySong(handle);
	
	FSOUND_STREAM *handle_music;
	
	
	handle_sound = FSOUND_Sample_Load(0, "data/demo.mp3", 1, 0, 0);
	FSOUND_PlaySound(0, handle_sound);
	FSOUND_DSP_SetActive(FSOUND_DSP_GetFFTUnit(), 1);
}  
void initSnow(void) {
	
	int i;
	for (i=0;i<200;i++) {
		snow[i].x = rand() % SCREEN_WIDTH;
		snow[i].y = rand() % SCREEN_HEIGHT;
		snow[i].z = rand() % 3;
		snow[i].sinheight = rand() % 30;
	}
	
}

void drawSnow(void) {
	int i;

	for (i=0;i<200;i++) {	
			
		if (snow[i].z == 1) {
			if (snow[i].y < 121 || snow[i].y > SCREEN_HEIGHT-129)
				drawImg(screen, img_snowflake2, snow[i].x + snow[i].sinheight * snowheight * sin(0.01 * snow[i].y), snow[i].y);
			
			snow[i].y += toInt(dt*0.5*snowspeed);
		}
		else if (snow[i].z == 2) {
			if (snow[i].y < 121 || snow[i].y > SCREEN_HEIGHT-129)
				drawImg(screen, img_snowflake3, snow[i].x + snow[i].sinheight * snowheight * sin(0.02 * snow[i].y), snow[i].y);
			
			snow[i].y += toInt(dt*0.3*snowspeed);
		}
		
		
		
		if (snow[i].y > SCREEN_HEIGHT) 
			snow[i].y = 0;
		
	}
	
	
	
	drawImg(screen, img_shaddow, 0, SCREEN_HEIGHT - 121);
	
	for (i=0;i<200;i++) {	
		
		if (snow[i].z == 0) {
			drawImg(screen, img_snowflake, snow[i].x + snow[i].sinheight * snowheight * sin(0.01 * snow[i].y), snow[i].y);
			snow[i].y += toInt(dt*0.8*snowspeed);
		}
		
		if (snow[i].y > SCREEN_HEIGHT) 
			snow[i].y = 0;

	}
	
	
	
	
	
}



void drawBajs() {
	
	int i;
	
	// rita det som redan r inbajsat
	drawImg2(screen, bajssurface[currentbajs], 0, SCREEN_HEIGHT - 121, bajs_cur_x, BOX_HEIGHT, 0, 0);
	
	// fyll med den sista pixelraden i y-led fr resten	
	for (i=bajs_cur_x; i <bajssurface[currentbajs]->w; i++) {
		drawImg2(screen, bajssurface[currentbajs], i, SCREEN_HEIGHT-121, 1, 121, bajs_cur_x, 0);
	}
	
	bajs_cur_x += toInt(dt*5);
	
	if (bajs_cur_x > SCREEN_WIDTH)
		bajs_cur_x = SCREEN_WIDTH;

	if (SDL_GetTicks() - lastbajs > 10000) {
			bajs_cur_x = 0;
			lastbajs = SDL_GetTicks();
			currentbajs = (currentbajs + 1) % 12;
	}
	
}



void initBgText() {
	
	int i;
	for (i=0;i<200;i++) {
		bgtextx[i] = i * 2;
		bgtextx2[i] = i * 2;
	}
	
}
	

void drawBgText() {
	
	char bgtext[] = "SATURNUSLANSATURNUSLANSATURNUSLAN SATURNUS LAN";
	int i;
	char tmp[2];
	
	for (i=0;i<25;i++) {
		
		bgtextx[i] += toInt(1.1*dt);
		bgtextx2[i] += toInt(1.5*dt);
	
		tmp[0] = bgtext[i];
		tmp[1] = '\n';		
		
		int n;
		for (n=0; n < 8; n++)  
			sge_BF_textout(screen, font_intro, tmp, -90 + 40 * sin(bgtextx2[i]*0.01) + i * 35+ n * 10 * sin(bgtextx2[i]*0.01), 80 + n * 40 + 20 * sin(bgtextx[i]*0.1));	

		
	}
	
}


void animate(anim_type *anim) {
	
	if (SDL_GetTicks() - anim->last_frame_time > anim->duration) {
		anim->last_frame_time = SDL_GetTicks();
		anim->cur_frame = (anim->cur_frame + 1)%anim->num_frames;
	}
	
	//drawImg(screen, anim->ani->[anim->cur_frame], anim->x, anim->y);
	
}

void drawAmigaBalls() {
	
	animate(&ball);	
	//sge_ClearSurface(demoboxBuffer, SDL_MapRGB(screen->format, 0,0,0));
	
	int i;		
	for (i = 3; i >= 0; i--) {
			
		amigaball[i].sinx += dt;
		amigaball[i].siny += dt;
		
		amigaball[i].oldx = amigaball[i].x;
		amigaball[i].oldy = amigaball[i].y;
		
		amigaball[i].y = toInt(160.0 * -sin(amigaball[i].siny * 0.04));            //amigaball[i].speed_x * toInt(dt*amigaball[i].speed_x_factor);
		amigaball[i].x = 270 + toInt(280.0 * -sin(amigaball[i].sinx * 0.015));    //amigaball[i].speed_y * toInt(dt*amigaball[i].speed_y_factor);
			
		amigaball[i].ballrotate += 1;
		amigaball[i].ballscale = 1.5 - (abs(amigaball[i].y) / 180.0);  //(dt * 0.001)*amigaball[i].ballspeed*amigaball[i].ballspeed_factor;
	
		amigaball[i].y += 210;
		
		if (amigaball[i].oldy > amigaball[i].y)
			amigaball[i].ballscale = 0.5;
		
		
		
		if (amigaball[i].ballscale > 1.0) {
			amigaball[i].ballscale = 1;
			amigaball[i].ballspeed = -1;
		}
		else if (amigaball[i].ballscale < 0) {
			amigaball[i].ballscale = 0;
			amigaball[i].ballspeed = 1;
		}
			
		tmp_rotate->w = 100*amigaball[i].ballscale;
		tmp_rotate->h = 100*amigaball[i].ballscale;
		
		/*
		if (amigaball[i].x + toInt(amigaball[i].speed_x * dt * amigaball[i].speed_x_factor) + 50 + amigaball[i].ballscale*50 > BOX_WIDTH || amigaball[i].x + toInt(amigaball[i].speed_x * dt * amigaball[i].speed_x_factor) + 50-amigaball[i].ballscale*50 < 0) {
			amigaball[i].speed_x *= -1;
		}
			
		if (amigaball[i].y + toInt(amigaball[i].speed_y * dt* amigaball[i].speed_y_factor) + 50 + amigaball[i].ballscale*50 > BOX_HEIGHT || amigaball[i].y + toInt(amigaball[i].speed_y * dt * amigaball[i].speed_x_factor) + 50-amigaball[i].ballscale*50 < 0) {
			amigaball[i].speed_y *= -1;
		}
		*/
		
	
		
		

			//box_x += dt;
			//box_y += dt;
			//int box_x_old = box_x_new;
			//int box_y_old = box_y_new;		
			//box_y_new = toInt(200.0 * -sin(box_x * 0.04));
			//box_x_new = toInt(200.0 * -sin(10 + box_y * 0.01));
	
			//if (161 + box_y_new > 161+box_y_old) {
				//drawImg(screen, img_tomte, 320+box_x_new, 161+box_y_new);
			//}
		
			
		sge_ClearSurface(tmp_rotate, SDL_MapRGB(screen->format, 0,0,0));
		//sge_transform(ball.ani[ball.cur_frame], tmp_rotate, amigaball[i].ballrotate, amigaball[i].ballscale, amigaball[i].ballscale, (tmp2->w)/2, (tmp2->h)/2, (tmp2->w)/2, (tmp2->h)/2, SGE_TSAFE);
		sge_transform(ball.ani[ball.cur_frame], tmp_rotate, amigaball[i].ballrotate, amigaball[i].ballscale, amigaball[i].ballscale, 50, 50, (tmp_rotate->h)/2, (tmp_rotate->h)/2, SGE_TSAFE);
		
		/* going up */
		if (amigaball[i].oldy > amigaball[i].y) {

			
			if (amigaball[i].y + tmp_rotate->h > 359 && amigaball[i].y > 359 - tmp_rotate->h) {
				drawImg2(screen, tmp_rotate, amigaball[i].x, 359, tmp_rotate->w, tmp_rotate->h - (359 - amigaball[i].y), 0, 359 - amigaball[i].y);
			}
			
			else if (amigaball[i].y + tmp_rotate->h > 121 && amigaball[i].y < 121) {
					drawImg2(screen, tmp_rotate, amigaball[i].x, amigaball[i].y, tmp_rotate->w, 121 - amigaball[i].y, 0, 0);
			}
			
			else if (amigaball[i].y < 121 && amigaball[i].y > 0) {
				drawImg(screen, tmp_rotate, amigaball[i].x, amigaball[i].y);
			}
				//else if (amigaball[i].y + tmp_rotate > 352 && amigaball[i].y + tmp_rotate->h > 352) {
				//	drawImg2(screen, tmp_rotate, amigaball[i].x, amigaball[i].y, tmp_rotate->w, 352 - amigaball[i].y, 0, tmp_rotate->h - 352 - amigaball[i].y);
				//}
			//else {		
				//drawImg(screen, tmp_rotate, amigaball[i].x, amigaball[i].y);
			//}
			
		}
		
		else {
			drawImg(screen, tmp_rotate, amigaball[i].x, amigaball[i].y);
		}
	}
}	



void initPlasma() {
	
	int i=0;
	
	for (i = 0; i < 64; ++i)
    {
      colors[i].r = i << 4;
      colors[i].g = 255 - ((i << 2) + 1);
      colors[i+64].r = 255;
      colors[i+64].g = (i << 2) + 1;
      colors[i+128].r = 255 - ((i << 2) + 1);
      colors[i+128].g = 255 - ((i << 2) + 1);
      colors[i+192].g = (i << 2) + 1;
    }
	
	int x, y;
    for(x = 0; x < BOX_WIDTH; x++) {
    	for(y = 0; y < BOX_HEIGHT; y++)
    	{
        	int color = toInt(
			
			  128.0 + (128.0 * sin(x / 16.0))
            + 128.0 + (128.0 * sin(y / 32.0))
            + 128.0 + (64.0 * sin(sqrt((float)((x - BOX_WIDTH / 2.0)* (x - BOX_WIDTH / 2.0) + (y - BOX_HEIGHT / 2.0) * (y - BOX_HEIGHT / 2.0))) / 8.0))
            + 128.0 + (128.0 * sin(sqrt((float)(x * x + y * y)) / 8.0))

			
        ) / 4;

			plasma[x][y] = color;

    	}
	}	
		
}


void drawPlasma() {
	
	int paletteShift;
	paletteShift = toInt(SDL_GetTicks() / 5.0);
		
	int i,j;
	/*
	for (i = 0,j=0; i < 320; i++, j = j + 2) {
		//drawPixel(screen, j, 100 + toInt(100 * spectrum[i]) , 255, 255, 255);
					
		int k;
		
		for (k=240 - toInt(spectrum[i]*100); k < 240 + toInt(spectrum[i]*100); k++) {
				
			buffer[320+i][k] = colors[(plasma[320+i][k] + paletteShift) % 256];   
			drawPixel(screen, 320+i, k, buffer[320+i][k].r, buffer[320+i][k].g, buffer[320+i][k].b);

			buffer[320-i][k] = colors[(plasma[320-i][k] + paletteShift) % 256];   
			drawPixel(screen, 320-i, k, buffer[320-i][k].r, buffer[320-i][k].g, buffer[320-i][k].b);

			
		}
	}
	*/
	
	for (i = 0,j=0; i < 320; i++, j = j + 2) {
		//drawPixel(screen, j, 100 + toInt(100 * spectrum[i]) , 255, 255, 255);
					
		int k;
		
		for (k=128; k < 128 + toInt(spectrum[i]*170); k++) {
				
			buffer[320+i][k] = colors[(plasma[320+i][k] + paletteShift) % 256];   
			drawPixel(screen, 320+i, k, buffer[320+i][k].r, buffer[320+i][k].g, buffer[320+i][k].b);
			drawPixel(screen, 320+i, 480-k, buffer[320+i][k].r, buffer[320+i][k].g, buffer[320+i][k].b);

			buffer[320-i][k] = colors[(plasma[320-i][k] + paletteShift) % 256];   
			drawPixel(screen, 320-i, k, buffer[320-i][k].r, buffer[320-i][k].g, buffer[320-i][k].b);
			drawPixel(screen, 320-i, 480-k, buffer[320-i][k].r, buffer[320-i][k].g, buffer[320-i][k].b);

			
		}
		
		if (spectrum[i]*170 > 2) {
				drawPixel(screen, 320 + i, 128 + toInt(170 * spectrum[i]) + 4 , 255, 255, 255);
				drawPixel(screen, 320 - i, 128 + toInt(170 * spectrum[i]) + 4, 255, 255, 255);
			
				drawPixel(screen, 320 + i, 350 - toInt(170 * spectrum[i]), 255, 255, 255);
				drawPixel(screen, 320 - i,  350 - toInt(170 * spectrum[i]) , 255, 255, 255);				
		}	
	}
	/*	
				
			line(screen, 320 + j, 240 + toInt(spectrum[i]*100), 320 + j+2, 240 + toInt(spectrum[i+1]*100), 255) ;
			line(screen, 320 - j, 240 + toInt(spectrum[i]*100), 320 - (j+2), 240 + toInt(spectrum[i+1]*100), 255) ;

			line(screen, 320 + j, 240 - toInt(spectrum[i]*100), 320 + j+2, 240 - toInt(spectrum[i+1]*100), 255) ;
			line(screen, 320 - j, 240 - toInt(spectrum[i]*100), 320 - (j+2), 240 - toInt(spectrum[i+1]*100), 255) ;
			
	}	
	
	int paletteShift;
	paletteShift = toInt(SDL_GetTicks() / 10.0);
	
	int x, y, j;
    for(x = 0, j=0; x < BOX_WIDTH; x++, j=j+2) {
    	for(y = 0; y < BOX_HEIGHT; y++)
    	{
			buffer[x][y] = colors[(plasma[x][y] + paletteShift) % 256];   
			 // int color = toInt(128.0 + (128.0 * sin(x / 7.0)) + 128.0 + (128.0 * sin(y / 8.0))) / 2;
        	
			//plasma[x][y] = color;
			
			int z = spectrum[320-j]*100;
		
			
			if ((y < 240 + z) && (y > 240 - spectrum[x]*100)) {
				drawPixel(screen, x, y, buffer[x][y].r, buffer[x][y].g, buffer[x][y].b);
			}
    	}
	}
	*/
}


void loadGfx() {
	

	font = sge_BF_OpenFont("gfx/mario3.bmp", SGE_BFTRANSP|SGE_BFSFONT);
	font_intro = sge_BF_OpenFont("gfx/newfont.bmp", SGE_BFTRANSP|SGE_BFSFONT);
	font_intro_inverted = sge_BF_OpenFont("gfx/newfont_inverted.bmp", SGE_BFTRANSP|SGE_BFSFONT);




	hello.ani[0] = IMG_Load("gfx/mun_1.png");
	hello.ani[1] = IMG_Load("gfx/mun_2.png");
		
	hello.num_frames = 2;
	hello.last_frame_time = 0;
	hello.cur_frame = 0;
	hello.duration = 200;
	hello.x = 100;
	hello.y = 100;		

		
	dance.ani[0] = IMG_Load("gfx/kakmonsterdansar.png");
	dance.ani[1] = IMG_Load("gfx/kakmonsterdansar2.png");
	dance.ani[2] = IMG_Load("gfx/kakmonsterdansar3.png");	
	dance.ani[3] = IMG_Load("gfx/kakmonsterdansar2.png");	
	
	dance.num_frames = 4;
	dance.last_frame_time = 0;
	dance.cur_frame = 0;
	dance.duration = 150;
	
	
	img_snowflake = SDL_DisplayFormat(IMG_Load("gfx/snow1.png"));
	img_snowflake2 = IMG_Load("gfx/snow2.png");
	img_snowflake3 = IMG_Load("gfx/snow3.png");
	SDL_SetColorKey(img_snowflake, SDL_SRCCOLORKEY, SDL_MapRGB(img_snowflake->format, 255, 0, 255));

	
	bajssurface[0] = IMG_Load("gfx/pics_1.png");
	bajssurface[1] = IMG_Load("gfx/pics_2.png");
	bajssurface[2] = IMG_Load("gfx/pics_3.png");
	bajssurface[3] = IMG_Load("gfx/pics_7.png");
	bajssurface[4] = IMG_Load("gfx/pics_12.png");
	bajssurface[5] = IMG_Load("gfx/pics_11.png");
	bajssurface[6] = IMG_Load("gfx/pics_5.png");
	bajssurface[7] = IMG_Load("gfx/pics_10.png");
	bajssurface[8] = IMG_Load("gfx/pics_9.png");
	bajssurface[9] = IMG_Load("gfx/pics_8.png");
	bajssurface[10] = IMG_Load("gfx/pics_4.png");
	bajssurface[11] = IMG_Load("gfx/pics_6.png");
	bajssurface[12] = IMG_Load("gfx/botton.png");
	bajssurface[13] = IMG_Load("gfx/botton.png");


	ball.ani[0] = IMG_Load("gfx/boll0001.png");
	ball.ani[1] = IMG_Load("gfx/boll0002.png");
	ball.ani[2] = IMG_Load("gfx/boll0003.png");
	ball.ani[3] = IMG_Load("gfx/boll0004.png");
	ball.ani[4] = IMG_Load("gfx/boll0005.png");
	ball.ani[5] = IMG_Load("gfx/boll0006.png");
	
	ball.num_frames = 5;
	ball.last_frame_time = 0;
	ball.cur_frame = 0;
	ball.duration =  20;	

		
	img_shaddow = IMG_Load("gfx/shaddow.png");
	img_bubbla = IMG_Load("gfx/bubbla.png");	
	
	img_snow_down = IMG_Load("gfx/snow_down.png");
	img_top = SDL_DisplayFormat(IMG_Load("gfx/top.png"));
	img_bar = SDL_DisplayFormat(IMG_Load("gfx/bar.png"));
	img_bar_1 = SDL_DisplayFormat(IMG_Load("gfx/bar_1.png"));
	
	img_amigabars[0] = SDL_DisplayFormat(IMG_Load("gfx/bar_1.png"));
	img_amigabars[1] = SDL_DisplayFormat(IMG_Load("gfx/bar_2.png"));
	img_amigabars[2] = SDL_DisplayFormat(IMG_Load("gfx/bar_3.png"));
	
	img_bottom = SDL_DisplayFormat(IMG_Load("gfx/botton.png"));
	img_top_bar = IMG_Load("gfx/top_bar_snow.png");
	img_tomte = IMG_Load("gfx/tomte.png");
	
	img_satlogga = SDL_LoadBMP("gfx/saturnusliten.bmp");
	SDL_SetColorKey(img_satlogga, SDL_SRCCOLORKEY, SDL_MapRGB(img_satlogga->format, 0, 0, 0));
	img_satlogga = SDL_DisplayFormat(img_satlogga);
	
	img_satlogga_skugga = SDL_LoadBMP("gfx/saturnus_skugga.bmp");
	SDL_SetColorKey(img_satlogga_skugga, SDL_SRCCOLORKEY, SDL_MapRGB(img_satlogga_skugga->format, 0, 0, 0));
	img_satlogga_skugga = SDL_DisplayFormat(img_satlogga_skugga);
		
	
	img_border_uppe = IMG_Load("gfx/border_uppe.png");
	img_border_nere = IMG_Load("gfx/border_nere.png");
	
	tmp_rotate =  sge_transform_surface(ball.ani[ball.cur_frame], 0, 0, 1.0, 1.0, SGE_TSAFE);
	tmp_rotate->w = 100;
	tmp_rotate->h = 100;
	
	int i;
	for (i = 0; i < 5; i++) {
		amigaball[i].speed_x = 1;
		amigaball[i].speed_y = 1;
		amigaball[i].speed_x_factor = 1+ rand() % 2;
		amigaball[i].speed_y_factor = 1 + rand() % 2;
		amigaball[i].x = rand() % (BOX_WIDTH - 50);
		amigaball[i].y = rand() % (BOX_HEIGHT- 50);
		amigaball[i].ballscale = (RAND_MAX-(float)rand())/RAND_MAX;
		//amigaball[i].ballscale_speed = 1+rand() % 3;
		amigaball[i].ballspeed_factor = 1 + rand() % 3;
		amigaball[i].ballspeed = 1;
		amigaball[i].sinx = i * 60;
		amigaball[i].siny = i * 25;
		amigaball[i].oldx = 0;
		amigaball[i].oldy = 0;
		
	}	
}




		
void initAmigaScroller() {
  
  int i;
  for (i=0; i <7; i++) 
    amigascroller[i].x = i * 90; 
    
}

void drawAmigaScroller(void) {
  
	//sge_ClearSurface(demoboxBuffer, SDL_MapRGB(demoboxBuffer->format, 0, 0, 0));
	
  	int i;
  	for (i=0; i<3; i++) {
    
		
    	amigascroller[i].x += 4 * dt;
		amigascroller[i].oldy = amigascroller[i].y;
		amigascroller[i].y = 15 * sin(0.013 * amigascroller[i].x);
		
		if (amigascroller[i].y > amigascroller[i].oldy) {
			drawImg(screen, img_amigabars[i], 0, 352 + amigascroller[i].y);
			drawImg(screen, img_amigabars[i], 0, 121 + amigascroller[i].y);
		}

	}
	
	drawImg(screen, img_top_bar, 0, 109);
	drawImg(screen, img_bar, 0, SCREEN_HEIGHT - 128);
	
	for (i=0; i<3; i++) {
	
			if (amigascroller[i].y <= amigascroller[i].oldy) {
				drawImg(screen, img_amigabars[i], 0, 352 + amigascroller[i].y);
				drawImg(screen, img_amigabars[i], 0, 121 + amigascroller[i].y);
			}
  	}
  
  
}




void printMsg(char *message, int x, int y) {

	char tmp[2];
  	tmp[1]='\0';

  	int i=0;

  	if (*(currentsection + msgpos + 1) == '@') {
    	printer_finished = 1;
	 }
	
	if (1) {
	
  		/* kolla om nsta steg innebr ny section.. flytta fram sektionspekaren d */
  		if (*(currentsection + msgpos + 1) == '#') {
    		currentsection += msgpos + 2;
    		msgpos = 0;
  		}

  		char *msgptr;
  		msgptr = currentsection;

  		int offset=0;

  		/* flska igenom strgen med brjan p den aktuella sektionen */
  		for (i=0;i<=msgpos;i++,msgptr++) {
    
    		tmp[0] = *msgptr;

    		/* om < ska det bli ny rad.. */
    		if (*msgptr == '<') {
      			y += 20; 
      			offset = (i+1)*10;
    		}
    		else 
      			sge_BF_textout(screen, font, tmp, (x + i*10) - offset, y);
    
  		}

  		if (SDL_GetTicks() - lastprint > 20 + rand()%70) {
    		if (!printer_finished)
				msgpos++;
			
    		lastprint = SDL_GetTicks();
  		}

	}
	
}










int main(int argc, char *argv[]) {
	
	
	/* Initiera SDL */	
  	SDL_Init (SDL_INIT_VIDEO);
	
  	if (FULLSCREEN) {
    	screen = SDL_SetVideoMode (SCREEN_WIDTH, SCREEN_HEIGHT, 32, SDL_HWSURFACE|SDL_FULLSCREEN|SDL_DOUBLEBUF);
  	}
  	else {
	    screen = SDL_SetVideoMode (SCREEN_WIDTH, SCREEN_HEIGHT, 32, SDL_SWSURFACE|SDL_DOUBLEBUF);
  	}
	
  	SDL_WM_SetCaption("Saturnus LAN XMAS 2005","");

  	atexit(SDL_Quit);
	
	/* flska p musik och ladda in bilder */
	initMusic();
  	int now = SDL_GetTicks();  	
	
	loadGfx();
 
  	/* Inita starfieldet & lines och annat*/
	initPlasma();
	initBgText();
	initSnow();
	initAmigaScroller();

  	/* ingen autoupdate.. flimmrar fult. */
  	sge_Update_OFF();

  	int done = 0;
	int elapsed = 0;
	
	
  	while (!done) {
		
		elapsed = SDL_GetTicks() - now;
		

    	/* kalkylera en konstant fr fps-indie. */
    	td2=SDL_GetTicks();
    	dt=((float)(td2-td)*0.1);
    	td=td2;		
    
		
		/* spelas ltajvlen? */
		if (!FSOUND_IsPlaying(0))
			FSOUND_PlaySound(0, handle_sound);
		
		/* inhmta ljudspectrat */
		spectrum = FSOUND_DSP_GetSpectrum();
		
		sge_ClearSurface(screen, SDL_MapRGB(screen->format, 0, 0, 0));

		/* igng? */
		if (elapsed > 18000) {
					
			if (currentScene == 0) {
				if (mainTrans + toInt(5*dt) >= 255 && mainTrans != 255) {
					mainTrans = 255;
					currentScene++;
				}
				else {
					mainTrans += toInt(5*dt);
				}
			}
			else if (currentScene == 1) {
				
				if (mainTrans - toInt(dt*9) <= 0) {
					mainTrans = 0;			
				}			
				else {
					mainTrans -= toInt(dt*9);
				}
			}
			
			if (mainTrans > 0)			
				sge_FilledRectAlpha(screen, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, SDL_MapRGB(screen->format,255,255,255), mainTrans);
		
		}
		
		
		if (currentScene == 0) {

			int i,j;
			int s_offset = 4;
		
			for (i = 0,j=0; i < 320; i++, j = j + 4) {
			
				if (spectrum[i]*100 > 2) {
					drawPixel(screen, 320 + j, 240 + toInt(100 * spectrum[i]) , 255, 255, 255);
					drawPixel(screen, 320 - j, 240 + toInt(100 * spectrum[i]) , 255, 255, 255);
			
					drawPixel(screen, 320 + j, 240 - toInt(100 * spectrum[i]) , 255, 255, 255);
					drawPixel(screen, 320 - j, 240 - toInt(100 * spectrum[i]) , 255, 255, 255);			
					

					//line(screen, 320 + j, 240 + toInt(spectrum[i]*100), 320 + j+2, 240 + toInt(spectrum[i+1]*100), 255) ;
					//line(screen, 320 - j, 240 + toInt(spectrum[i]*100), 320 - (j+2), 240 + toInt(spectrum[i+1]*100), 255) ;

					//line(screen, 320 + j, 240 - toInt(spectrum[i]*100), 320 + j+2, 240 - toInt(spectrum[i+1]*100), 255) ;
					//line(screen, 320 - j, 240 - toInt(spectrum[i]*100), 320 - (j+2), 240 - toInt(spectrum[i+1]*100), 255) ;

					//line(screen, 320 + j, 240 + toInt(spectrum[i]*100), 320 + j+2, 240 + toInt(spectrum[i+1]*100), 255) ;
					//line(screen, 320 - j, 240 + toInt(spectrum[i]*100), 320 - (j+2), 240 + toInt(spectrum[i+1]*100), 255) ;

					//line(screen, 320 + j, 240 - toInt(spectrum[i]*100), 320 + j+2, 240 - toInt(spectrum[i+1]*100), 255) ;
					//line(screen, 320 - j, 240 - toInt(spectrum[i]*100), 320 - (j+2), 240 - toInt(spectrum[i+1]*100), 255) ;
				}
			}
		}
			
		else {
		
			
			drawBgText();
			drawPlasma();			
			drawImg(screen, img_top, 0, 0);
			
			//animate(&dance);
			//drawImg(screen, dance.ani[dance.cur_frame], 30, 50);
			
			//drawImg(screen, img_top_bar, 0, 109);
			
			
			drawImg(screen, img_bottom, 0, SCREEN_HEIGHT - 121);
		
			//box_x += dt;
			//box_y += dt;
			//int box_x_old = box_x_new;
			//int box_y_old = box_y_new;		
			//box_y_new = toInt(200.0 * -sin(box_x * 0.04));
			//box_x_new = toInt(200.0 * -sin(10 + box_y * 0.01));
	
			//if (161 + box_y_new > 161+box_y_old) {
				//drawImg(screen, img_tomte, 320+box_x_new, 161+box_y_new);
			//}
			
			
			animate(&hello);
			drawImg(screen, hello.ani[hello.cur_frame], 175, 83);
			
			
			
			drawBajs();
			
			//drawImg(screen, img_bar, 0, SCREEN_HEIGHT - 128);
			
			
			drawSnow();
			
			drawAmigaScroller();
			
			drawImg(screen, img_bubbla, 238, 17);
			printMsg("", 290, 30);
			
			drawImg(screen, img_satlogga, (SCREEN_WIDTH/2 - img_satlogga->w/2) + 100 * sin(SDL_GetTicks() / 700.0), 145);
			drawImg(screen, img_satlogga_skugga, (SCREEN_WIDTH/2 - img_satlogga_skugga->w/2) + 100 * sin(SDL_GetTicks() / 700.0), 265);
			
			drawImg(screen, img_snow_down, 0, SCREEN_HEIGHT - 50);
			
			//drawImg(screen, img_border_uppe, 0, 0);
			//drawImg(screen, img_border_nere, 0, SCREEN_HEIGHT - img_border_nere->h);
			
			
			
			drawAmigaBalls();
			
			/*
			if (elapsed > 210000) {
				
				sluttrans += 2*dt;
		
				if (sluttrans > 255) {
			
					// lite fulhack hr i slutet.. 
					int slutcolor = 255;
					while (slutcolor > 0) {
						sge_ClearSurface(screen, SDL_MapRGB(screen->format, slutcolor, slutcolor, slutcolor));
						SDL_Delay(20);
						SDL_Flip(screen);
						slutcolor -= 10;
					}

					SDL_Delay(1000);
					exit(1);
				}
			}
			else {
				sge_FilledRectAlpha(screen, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, SDL_MapRGB(screen->format,255,255,255), sluttrans);
			}
			*/
		
		}

		
		
		
		
    	/* keypresses..  */
    	while ( SDL_PollEvent(&event) )
      	{
	        if (event.type == SDL_QUIT )  {  done = 1;  }
    	    if (event.type == SDL_KEYDOWN )
        	  {
            	if (event.key.keysym.sym == SDLK_ESCAPE ) { done = 1; }
				if (event.key.keysym.sym == SDLK_UP ) {  }
				if (event.key.keysym.sym == SDLK_DOWN ) {  }
				if (event.key.keysym.sym == SDLK_LEFT ) { }
				if (event.key.keysym.sym == SDLK_RIGHT ) { }
            	if (event.key.keysym.sym == SDLK_f) { 
              		SDL_WM_ToggleFullScreen(screen);
	                //if (show_menu) show_menu = 0;
    	           //else show_menu = 1;
        	    }
            
          	}
      	}	

		
	
		/* fps */		
		if (SDL_GetTicks() - lastfpsframe > 1000)	{
			lastfpscounter = fpscounter;
			lastfpsframe = SDL_GetTicks();
			fpscounter = 0;
		}		
		
		fpscounter++;
		//sge_BF_textoutf(screen, font, 10, 10, "FPS: %d   SPECT:  %f  NOW:  %d   ELAPSED:  %d", lastfpscounter, spectrum[100], now, SDL_GetTicks() - now);
		
	    SDL_Flip(screen);	
	
	}
  
  	return 0;	

}
