{ unit for loading raw 320*200 picture data, no palette
  used for the bumpmap }
unit map;

interface
const vidseg = $a000;

var scrpos : word;
    x,y : word;

procedure grabSCR(filename:string);
procedure grabSCRe(filename:string;leng:word);
procedure grabPAL(filename:string);
procedure loadMAP(segi:word; filename:string);
procedure loadMAPe(segi:word; filename:string; leng:word);
procedure loadMAPeo(off,segi:word; filename:string; leng:word);
procedure loadPAL(filename:string);

implementation

procedure grabSCR(filename:string);
var tof : file;
    buf : byte;
    x,y:word;

begin
  Assign(ToF, filename); { Open output file }
  Rewrite(ToF, 1);  { Record size = 1 }
  scrpos:=0;
  for y:=0 to 319 do
    for x:=0 to 199 do begin
      buf:=mem[vidseg:scrpos];
      blockwrite(tof,buf,1);
      inc(scrpos);
    end;
  close(tof);
end;
procedure grabSCRe(filename:string; leng:word);
var tof : file;
    buf : byte;
    x,y:word;

begin
  Assign(ToF, filename); { Open output file }
  Rewrite(ToF, 1);  { Record size = 1 }
  scrpos:=0;
  for x:=0 to leng do begin
    buf:=mem[vidseg:scrpos];
    blockwrite(tof,buf,1);
    inc(scrpos);
  end;
  close(tof);
end;

procedure grabPAL(filename:string);
var tof : file;
    buf : byte;
    pos:word;
    r,g,b:byte;

begin
  Assign(ToF, filename); { Open output file }
  Rewrite(ToF, 1);  { Record size = 1 }
  for pos:=0 to 255 do begin
    port[$3c7]:=pos;
    r:=port[$3c9];
    g:=port[$3c9];
    b:=port[$3c9];
    blockwrite(tof,r,1);
    blockwrite(tof,g,1);
    blockwrite(tof,b,1);
  end;
  close(tof);
end;

procedure loadMAP(segi:word; filename:string); { needs to be FAST! }
var fromf : file;
    buf : byte;

begin
  Assign(FromF, filename); { Open input file }
  Reset(FromF, 1);  { Record size = 1 }
  blockread(fromf,mem[segi:0],64000); { the whole map at once }
  close(fromf);
end;

procedure loadMAPe(segi:word; filename:string; leng:word); { needs to be FAST! }
var fromf : file;
    buf : byte;

begin
  Assign(FromF, filename); { Open input file }
  Reset(FromF, 1);  { Record size = 1 }
  blockread(fromf,mem[segi:0],leng); { the whole map at once }
  close(fromf);
end;

procedure loadMAPeo(off,segi:word; filename:string; leng:word); { needs to be FAST! }
var fromf : file;
    buf : byte;

begin
  Assign(FromF, filename); { Open input file }
  Reset(FromF, 1);  { Record size = 1 }
  blockread(fromf,mem[segi:off],leng); { the whole map at once }
  close(fromf);
end;

procedure loadPAL(filename:string); { needs to be FAST! }
var fromf : file;
    pos : word;
    r,g,b: byte;

begin
  Assign(FromF, filename); { Open input file }
  Reset(FromF, 1);  { Record size = 1 }
  for pos:=0 to 255 do begin
    blockread(fromf,r,1);
    blockread(fromf,g,1);
    blockread(fromf,b,1);
    port[$3c8]:=pos;
    port[$3c9]:=r;
    port[$3c9]:=g;
    port[$3c9]:=b;
  end;
  close(fromf);
end;

end.