#ifndef SoundsOfWor_H
#define SoundsOfWor_H

/*
 *  Name        : SoundsOfWor.h
 *  Version     : 1.9 
 *  Description : HEADER file for "Sounds Of Wor I" Mod/Soundfx driver.
 *  Coder       : DANZiG / NAPALM
 *  Date        : 07/99
 *  SoftDrink   : Lots of Pepsi
 */



/* ======================================================================= */
/*    External stuff you can use to sync demos, make goofy equalizers, etc */
/* ======================================================================= */

extern u_short NP_Time;     /* Number of Scanlines being used per tick     */
extern u_short NP_TimeMax;  /* Keeps track of Maximum Scanlines used...    */
extern u_short NP_NumChan;  /* Number of channels in this mod              */
extern short NP_Row;        /* Current Row                                 */
extern short NP_SongPos;    /* Current Song Position                       */
extern short NP_Volume[16]; /* Current Volumes of each channel             */
extern short NP_Freq[16];   /* Current Frequencies of each channel         */
extern u_char NP_LastSample[16]; /* Current Instrument of each channel     */
extern u_char NP_OrderTable[128]; /* Songtable to find Current Pattern     */


/* ======================================================================= */
/*    Mod Player Controls.   Usage: NPM_Control(command);                  */
/* ======================================================================= */

#define npPLAY  1   /* play mod ( or continue mod if paused )              */
#define npSTOP  2   /* stops mod                                           */
#define npPAUSE 3   /* pauses mod                                          */
#define npCONT  4   /* continues mod                                       */
#define npFADE  5   /* fades mod to silence, then stops it                 */
#define npPAN1	6   /* Mimics Amiga channel separations: channel 1 plays     
                       on LEFT side only, channel 2 plays on RIGHT, etc    */
#define npPAN2  7   /* 50% channel separations: Channel 1 plays 100% on      
                       LEFT, 50% on RIGHT, chan 2: 50% LEFT/100% RIGHT etc
                       (this is default, sounds best I think)              */
#define npPAN3  8   /* NO channel separations. 100% on LEFT & RIGHT        */

/* ======================================================================= */
/*    MOD Player Commands                                                  */
/* ======================================================================= */

int  NPM_SetSong(char *, char *);
                            /* Pass the addresses of SONG + INSTRUMENTS    */
                            /* Songs have the .NPS extension and           */
                            /* Instruments have the .NPI extension.        */
                            /* Note: Returns 0 on failure                  */

void NPM_Control(u_short);  /* Check macros above for usage                */

void NPM_GlobalVol(u_short);/* Master volume, 0-64(loudest) default: 64
                               Can use this for game type stuff...           
                               Example: when pausing, reduce volume to 32 or
                               less to keep music faint but still playing  */

void NPM_FreeSong(void);    /* When ya wanna init another mod, eh          */

void NPM_SongJump(u_short); /* Jump to song position x                     */
                            /* NPM_jump is useful for games: end-of-level  */
                            /* boss muzak in which the pattern datas can   */ 
                            /* be in the same mod (why load another mod?)  */
                            /* (or even multipart demos)                   */

/* ======================================================================= */
/*    Sound Effects Commands                                               */
/* ======================================================================= */
/*
 * index   : 0-95 (up to 96 samples at the same time, should be enuff, no?)
 * channel : 0-19(4 chan mods), 0-15(8 chan mods), 0-11(12 chan mods), and
             0-7(16 chan mods)
 * pitch   : 0-0x3fff
 * volume  : 0-255
 *
 * NPM_SfxLoad expects a pointer to a VAG file. (Use Aiff2Vag to create em)
*/

int  NPM_SfxLoad( u_short index, char * );           /* Returns 0 on error */
int  NPM_SfxPlay( u_short channel, u_short index );
void NPM_SfxPitch( u_short channel, u_short pitch );
void NPM_SfxVol( u_short channel, u_short volumeleft, u_short volumeright );
void NPM_SfxOff( u_short channel );
void NPM_SfxFree( u_short index );

#endif
