// ------------------------------------------------------
// 1kPack v0.9 - Packer
// Written by Franck "hitchhikr" Charlet / Neural
// ------------------------------------------------------

// ------------------------------------------------------
// Includes
#include <windows.h>
#include <stdio.h>
#include "7z/7zdeflate.h"
#include <zlib.h>

// ------------------------------------------------------
// Constants
#define VERSION 0
#define REVISION 9

// ------------------------------------------------------
// Variables
BYTE *Input_Mem;
BYTE *Depacker_Mem;
BYTE *Test_Mem;
DWORD Input_Size;
DWORD Depacker_Size;
unsigned int Output_Size;
char Output_Name[MAX_PATH];

// ------------------------------------------------------
// Load a file into a memory block
BYTE *Load_Input_File(char *FileName, DWORD *Size)
{
    BYTE *Memory;
    FILE *Input = fopen(FileName, "rb");
    
    if(!Input) return(NULL);
    // Get the filesize
    fseek(Input, 0, SEEK_END);
    *Size = ftell(Input);
    fseek(Input, 0, SEEK_SET);
    
    Memory = (BYTE *) malloc(*Size);
    if(!Memory) return(NULL);
    if(fread(Memory, 1, *Size, Input) != (size_t) *Size) return(NULL);
    if(Input) fclose(Input);
    Input = NULL;
    return(Memory);
}

// ------------------------------------------------------
// Remove the extension from a filename
void Get_FileName(char *dest_string, char *string)
{
    int len = strlen(string);
    if(len > 4)
    {
        if(string[len - 4] == '.')
        {
            memcpy(dest_string, string, len - 4);
            return;
        }
    }
    memcpy(dest_string, string, len);
}

// ------------------------------------------------------
// Entry point
int main(int argc, char* argv[])
{
    FILE *Output;

    printf("1kPack v%d.%d - Written by hitchhikr / Neural\n\n", VERSION, REVISION);
    if(argc < 3)
    {
        printf("Usage: depacker.bin input.bin [output.exe]\n");
        return(0);
    }
    if(argc != 4)
    {
        Get_FileName(Output_Name, argv[2]);
        strcat(Output_Name, ".exe");
    }
    else
    {
        strcpy(Output_Name, argv[3]);
    }

    Input_Mem = Load_Input_File(argv[2], &Input_Size);
    if(!Input_Mem || Input_Size == 0)
    {
        printf("Can't load input file\n");
        return(0);
    }

    Depacker_Mem = Load_Input_File(argv[1], &Depacker_Size);
    if(!Depacker_Mem)
    {
        printf("Can't load specified depacker file: '%s'\n", argv[1]);
        return(0);
    }

    // Remove any trailing zeroes
    while(Input_Mem[Input_Size - 1] == 0 || Input_Mem[Input_Size - 1] == 0x90)
    {
        Input_Size--;
    }

    BYTE *Packed_Mem = (BYTE *) malloc(Input_Size * 2);
    memset(Packed_Mem, 0, Input_Size * 2);

    // Pack the file
    Output_Size = Input_Size * 2;
    if(!compress_rfc1950_7z(Input_Mem, Input_Size, Packed_Mem, Output_Size))
    {
        return false;
    }

#if defined(_DEBUG)
    z_stream d_stream;
    memcpy(Packed_Mem + 2, Packed_Mem, Output_Size);
    Packed_Mem[0] = 0x58;
    Packed_Mem[1] = 0xc3;
    Output_Size += 2;
    unsigned char *Test_Mem = (unsigned char *) malloc(Output_Size * 2);
    if(Test_Mem)
    {
        memset(&d_stream, 0, sizeof(d_stream));
        d_stream.next_in = (unsigned char *) Packed_Mem;
        d_stream.avail_in = Output_Size;
        d_stream.next_out = Test_Mem;
        d_stream.avail_out = (unsigned int) 0x430000;
        inflateInit(&d_stream);
        inflate(&d_stream, Z_FULL_FLUSH);
        inflateEnd(&d_stream);
    }
    memcpy(Packed_Mem, Packed_Mem + 2, Output_Size);
    Output_Size -= 2;
#else
    if(Output_Size >= Input_Size)
    {
        printf("Packed file is bigger than unpacked one\n");
        return(0);
    }

#endif

    Output = fopen(Output_Name, "wb");
    if(Output)
    {
        // Fix the depacker
        DWORD *dwDepacker_Mem = (DWORD *) (Depacker_Mem + 0x50);
        *dwDepacker_Mem = Output_Size + 2; // (+ the size of the fake header)
        // Write the packed datas
        fwrite(Depacker_Mem, 1, Depacker_Size, Output);
        fwrite(Packed_Mem, 1, Output_Size, Output);
        fclose(Output);
        printf("Input size: %d bytes\nFinal size: %d bytes\n", Input_Size, Output_Size + Depacker_Size);
    }
    else
    {
        printf("Can't open output file '%s'\n", Output_Name);
    }

    if(Depacker_Mem) free(Depacker_Mem);
    if(Test_Mem) free(Test_Mem);
    if(Packed_Mem) free(Packed_Mem);
    if(Input_Mem) free(Input_Mem);
    return 0;
}
