; ------------------------------------------------------------------
; Circling
; Written by hitchhikr/Neural

; ------------------------------------------------------------------
; Constants
Y_SCREEN_CIRCLES        =       129
X_SCREEN_CIRCLES        =       464
X_LARG_CIRCLES          =       (X_SCREEN_CIRCLES/8)

; ------------------------------------------------------------------
                        section prog,code_c

; ------------------------------------------------------------------
start:                  lea     $dff005,a5
                        move.w  2-5(a5),-(a7)
                        move.w  $1c-5(a5),-(a7)
                        lea     $7a004,a0
                        lea     (15)+(125*40)-$5000-4(a0),a1
clear_gfx:              clr.l   -(a0)
                        cmp.l   #$50000,a0
                        bhi.b   clear_gfx
                        lea     logo-(start-4)(a3),a2
                        moveq   #6-1,d6
copy_lines_logo:        moveq   #10-1,d7
copy_cols_logo:         move.b  (a2)+,(a1)+
                        dbf     d7,copy_cols_logo
                        lea     (40-10)(a1),a1
                        dbf     d6,copy_lines_logo
                        moveq   #16-1,d7
                        moveq   #0,d0
                        move.w  #(8*26)+1,d4
create_all_circles:     move.w  d7,-(a7)
                        moveq   #Y_SCREEN_CIRCLES-2,d1
                        addq.w  #2,d1
                        move.w  d0,d2
                        addq.w  #2,d2
                        addq.w  #1,d0
                        and.w   #7,d0
                        bne.b   create_a_circle
                        eor.w   #8,d4
create_a_circle:        move.l  d2,-(a7)
                        move.l  d2,a4
                        muls.w  d2,d2
                        moveq   #-1,d3
draw_loop:              addq.l  #1,d3
                        move.l  d3,d5
                        move.l  a4,d6
                        addq.l  #1,d5
                        muls.w  d5,d5
                        muls.w  d6,d6
                        add.l   d6,d5
                        sub.l   a4,d5
                        sub.l   d2,d5
                        ble.b   do_down_part
                        subq.l  #1,a4
                        move.l  d1,d6
                        sub.l   a4,d6
                        bsr.w   draw_up_part
do_down_part:           move.l  d1,d6
                        sub.l   d3,d6
                        bsr.w   draw_down_part
                        cmp.l   d3,a4
                        bhi.b   draw_loop
                        move.l  (a7)+,d2
                        addq.l  #8,d2
                        cmp.w   d4,d2
                        blt.b   create_a_circle
                        lea     (X_LARG_CIRCLES*Y_SCREEN_CIRCLES)-8(a0),a1
                        move.l  #$9f00012,$40-$5(a5)
                        clr.l   $64-$5(a5)
                        move.l  a1,$50-$5(a5)
                        move.l  a1,$54-$5(a5)
                        move.w  #(Y_SCREEN_CIRCLES*64)+(X_LARG_CIRCLES/2),$58-5(a5)
                        move.w  (a7)+,d7
                        lea     (X_LARG_CIRCLES*(Y_SCREEN_CIRCLES))(a0),a0
                        dbf     d7,create_all_circles
                        lea     copperlist-(start-4)(a3),a0
                        move.l  a0,$80-$5(a5)
main_loop:              btst.b  #0,(a5)
                        beq.b   main_loop
wait_sync:              btst.b  #0,(a5)
                        bne.b   wait_sync
                        add.l   #(X_LARG_CIRCLES*(Y_SCREEN_CIRCLES)),d0
                        cmp.l   #(X_LARG_CIRCLES*(Y_SCREEN_CIRCLES))*16,d0
                        bne.b   reset_circles
                        moveq   #0,d0
reset_circles:          move.l  d0,d1
                        add.l   #$50002,d1
                        move.l  d1,$e0-5(a5)
                        btst    #6,$bfe001
                        bne.b   main_loop
                        movem.w (a7)+,d0/d1
                        or.w    #$c000,d0
                        or.w    #$8000,d1
                        move.l  4.w,a0
                        move.l  156(a0),a0
                        move.l  38(a0),$80-5(a5)
                        move.w  d1,$96-5(a5)
                        move.w  d0,$9a-5(a5)
                        moveq   #0,d0
                        rts

; ------------------------------------------------------------------
draw_down_part:         muls.w  #X_LARG_CIRCLES,d6
                        move.l  a4,d5
                        bsr.b   draw_point1
                        sub.l   a4,d5
                        bra.b   draw_point
draw_up_part:           muls.w  #X_LARG_CIRCLES,d6
                        move.l  d3,d5
                        bsr.b   draw_point1
                        sub.l   d3,d5
                        bra.b   draw_point
draw_point1:            cmp.w   #Y_SCREEN_CIRCLES*X_LARG_CIRCLES,d6
                        bcc.b   no_point
                        add.l   #(X_SCREEN_CIRCLES/2)-32-24,d5
draw_point:             move.l  d5,d7
                        lsr.l   #3,d5
                        not.b   d7
                        add.l   d6,d5
                        bset.b  d7,(a0,d5.l)
                        move.l  #(X_SCREEN_CIRCLES/2)-32-24,d5
no_point:               rts

; ------------------------------------------------------------------
logo:                   dc.b    %00001111,%11111110,%01111111,%11000111,%11111111,%00111111,%11100011,%11000000,%00111111,%11100000
                        dc.b    %00001111,%00011110,%01111000,%00000111,%10001111,%00111100,%00000011,%11000000,%00111100,%00000000
                        dc.b    %00001111,%11111110,%01111111,%00000111,%11111111,%00111111,%10000011,%11000000,%00111111,%11111100
                        dc.b    %00001111,%10001111,%01111100,%00000111,%11000111,%10111110,%00000011,%11100000,%00000000,%01111100
                        dc.b    %00001111,%10001111,%01111100,%00000111,%11000111,%10111110,%00000011,%11100000,%00000000,%01111100
                        dc.b    %00001111,%10001111,%01111111,%11110111,%11111111,%10111111,%11111011,%11111111,%10111111,%11111100

; ------------------------------------------------------------------
copperlist:             dc.w    $9a,$7fff,$96,$20
                        dc.w    $8e,$2c81,$90,$2cc1
                        dc.w    $92,$38,$94,$d0
logo_bps:               dc.w    $e4,7,$e6,$5000
                        dc.w    $100,$2200
                        dc.w    $108,X_LARG_CIRCLES-40,$10a,0,$1fc,0
                        dc.w    $180,$214,$182,$439,$184,$edf,$186,$fff
                        dc.w    $ac09,-2,$108,-X_LARG_CIRCLES-40
                        dc.l    -2
