/**
	
    TODO:
        * on CUT pattern length, keep track of old length

	Updates:
		2002-09-18	gnilk	fixed the paste overwrite bug
		2002-09-18	gnilk	added some comments...
        
**/
#include "stdafx.h"
#include "tracker.h"

#include "mainfrm.h"
#include "gtkformat.h"
#include "trackerDoc.h"
#include "trackerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SETHIBYTE(a,b) ((a)=((a)&0x0f)|(((b)<<4)&0xf0));
#define SETLOWBYTE(a,b) ((a)=((a)&0xf0)|((b)&0x0f));
#define GETHIBYTE(a) (((a)>>4)&0xff);
#define GETLOWBYTE(a) ((a)&0x0f));
#define mswap(a,b) {int tmp; tmp=(a);(a)=(b);(b)=tmp;}

static int legal_note_num[]=
{
  1,2,3,4,5,6,7,8,9,10,11,12,13,14,
    12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29
};

static char *legal_note_char="ZSXDCVGBHNJM,L.Q2W3ER5T6Y7UI9O0P";
static char *legal_trkctrl_char="KCV";
static char *legal_num_char="0123456789ABCDEF";

void CPatternView::CopyPatternBlock()
{
  CTrackerDoc *pDoc = GetDocument ();
  int ep1,ep2,ec1,ec2;
  GTK_PATTERN *src_pattern;
  GTK_PATTERNPOS *src_patpos,*dst_patpos;
  int num,i,j;
  EDTCOPYBUFFER *cpbuf;


  ep1 = pDoc->editData.beginmark.pos;
  ep2 = pDoc->editData.endmark.pos;
  if (ep1 > ep2)
   mswap(ep1,ep2);

  ec1 = pDoc->editData.beginmark.col;
  ec2 = pDoc->editData.endmark.col;
  if (ec1 > ec2)
   mswap(ec1,ec2);

  cpbuf = &pDoc->editData.copybuffer;
  if (cpbuf->hasdata)
  {
    for (i=0;i<cpbuf->posnum;i++)
      free (cpbuf->poslist[i]);

    free (cpbuf->poslist);
    
  }
  
  cpbuf->posnum = (ep2 - ep1)+1;
  cpbuf->colnum = (ec2 - ec1)+1;

  cpbuf->poslist = (GTK_PATTERNPOS **)malloc (sizeof (*cpbuf->poslist) * cpbuf->posnum);
  for (i=0;i<cpbuf->posnum;i++)
    cpbuf->poslist[i]=(GTK_PATTERNPOS *)malloc (sizeof (GTK_PATTERNPOS) * cpbuf->colnum);


  num = pDoc->editData.patternmark;//pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
  src_pattern = &pDoc->gtk->patterns[num];

  for (i=0;i<cpbuf->posnum;i++)
  {
    src_patpos = src_pattern->patterndata[i+ep1];
    dst_patpos = cpbuf->poslist[i];
    for (j=0;j<cpbuf->colnum;j++)
      dst_patpos[j]=src_patpos[j+ec1];
  }  
  pDoc->editData.copybuffer.hasdata=1;
}

/*---------------------------------------------------

  paste pattern block

  auth:	
	gnilk
  updates:
	2002-09-18, range checking, wont overwrite paste dst pattern length...
 
 ---------------------------------------*/
void CPatternView::PastePatternBlock()
{
	CTrackerDoc *pDoc = GetDocument ();
	GTK_PATTERN *dst_pattern;
	GTK_PATTERNPOS *src_patpos,*dst_patpos;
	int num,i,j,ep1,ec1;
	EDTCOPYBUFFER *cpbuf;

	ep1 = patCursor.pos;
	ec1 = patCursor.col;

	cpbuf = &pDoc->editData.copybuffer;
	num = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
	dst_pattern = &pDoc->gtk->patterns[num];

	for (i=0;i<cpbuf->posnum;i++)
	{
		// range checking...
		if ((i+ep1) >= dst_pattern->len)
			break;

		dst_patpos = dst_pattern->patterndata[i+ep1];
		src_patpos = cpbuf->poslist[i];
		for (j=0;j<cpbuf->colnum;j++)
		dst_patpos[j+ec1]=src_patpos[j];
	}  


}
/*---------------------------------------------------

	interpolate block


	auth:	
		gnilk
 
 ---------------------------------------*/
void CPatternView::PatternInterpolate (int rowcol, int start_pos, int end_pos)
{
	CTrackerDoc *pDoc = GetDocument ();
	GTK_PATTERNPOS *patpos;
	int i;
	float sval,eval,dval;
	int pnum = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern; 

	// we want to work in a single direction
	if (start_pos> end_pos)
		mswap(start_pos,end_pos);


	// dual case since minor/major is the _same_ column for interpolation
	// fetch interpolation start value from right column
	patpos = &pDoc->gtk->patterns[pnum].patterndata[start_pos][patCursor.col];
	switch (rowcol)
	{
		case 1 :
		case 2 :
			sval = patpos->velocity;
			break;
		case 3 :
		case 4 :
			sval = patpos->fx;
			break;
		case 5 :
		case 6 :
			sval = patpos->param;
			break;
		default :
			return;
	}
	// fetch interpolation end value
	patpos = &pDoc->gtk->patterns[pnum].patterndata[end_pos][patCursor.col];
	switch (rowcol)
	{
		case 1 :
		case 2 :
			eval = patpos->velocity;
			break;
		case 3 :
		case 4 :
			eval = patpos->fx;
			break;
		case 5 :
		case 6 :
			eval = patpos->param;
			break;
		default :
			return;
	}

	// delta
	dval = (eval-sval) / (float(end_pos-start_pos));


	// interpolate
	for (i=start_pos;i<end_pos;i++)
	{
		patpos = &pDoc->gtk->patterns[pnum].patterndata[i][patCursor.col];
		switch (rowcol)
		{
			case 1 :
			case 2 :
				patpos->velocity=(unsigned char)sval;
				break;
			case 3 :
			case 4 :
				patpos->fx=(unsigned char)sval;
				break;
			case 5 :
			case 6 :
				patpos->param=(unsigned char)sval;
				break;
			default :
				return;      
		}
		sval+=dval;

	}  
}
/*---------------------------------------------------

  OnMIDIKeyDown

  auth:	
	steffo (?)
 
 ---------------------------------------*/
void CPatternView::OnMIDIKeyDown( UINT key, UINT velocity )
{
	CTrackerDoc *pDoc = GetDocument();

	if (pDoc->editData.state == GTK_EDITSTATE_DEFAULT && !isPatternEdit) {
      return;
	}

	int pnum = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
	GTK_PATTERNPOS *patpos = patpos = &pDoc->gtk->patterns[pnum].patterndata[patCursor.pos][patCursor.col];

	int note = key + 1;
    int curinst = seqCursor.col;  
	isEVENT event;
	event.type = NOTE_ON;
	event.param1 = note;
	event.param2 = velocity;
    pDoc->synth->instrument[curinst]->Event( event );

	patpos->velocity = velocity;
	patpos->note = note;
	Invalidate();
	UpdateWindow();

	MIDIReceptor::OnMIDIKeyDown( key, velocity );
	
}

void CPatternView::OnMIDIKeyUp( UINT key, UINT velocity )
{
	CTrackerDoc *pDoc = GetDocument();

	if (pDoc->editData.state == GTK_EDITSTATE_DEFAULT && !isPatternEdit) {
      return;
	}

	int note = key + 1;
    int curinst = seqCursor.col;  
	isEVENT event;
	event.type = NOTE_OFF;
	event.param1 = note;
	event.param2 = velocity;
    pDoc->synth->instrument[curinst]->Event( event );

	MIDIReceptor::OnMIDIKeyUp( key, velocity );
}

/*---------------------------------------------------

	Pattern process edit key
	takes actions depending on none special keys...

  auth:	
	gnilk
 
 ---------------------------------------*/
int CPatternView::PatternProcessEditKey (int nChar, int ctrlflag)
{
	CTrackerDoc *pDoc = GetDocument ();

	char *ptr;
	int val;
	GTK_PATTERNPOS *patpos;
	int pnum = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
	patpos = &pDoc->gtk->patterns[pnum].patterndata[patCursor.pos][patCursor.col];

	// check if control was pressed, take special action if so...
	
	if (ctrlflag)
	{
		switch (nChar)
		{
			case 'K': // Cut pattern
				pDoc->gtk->patterns[pnum].len = patCursor.pos;
				SetPatternCursor (pDoc->gtk->patterns[pnum].len-1,0);
				return 0;
				break;
            case 'E' :  // pattern extend..
                {
                    int oldlen,newlen,i;
                    void *oldptr;
                    oldlen = pDoc->gtk->patterns[pnum].len;
                    newlen = oldlen * 2;
                    if (newlen > 65536)
                        newlen = 65535;

                    oldptr=pDoc->gtk->patterns[pnum].patterndata;
                    
                    pDoc->gtk->patterns[pnum].patterndata = (GTK_PATTERNPOS **)realloc(pDoc->gtk->patterns[pnum].patterndata,sizeof (GTK_PATTERNPOS *) * newlen); //GTK_DEFAULT_PATCHANNELS);
                    if (pDoc->gtk->patterns[pnum].patterndata!=NULL)
                    {
                        pDoc->gtk->patterns[pnum].len = newlen;

                        for (i=oldlen;i<=newlen;i++)
                        {
                            pDoc->gtk->patterns[pnum].patterndata[i] = (GTK_PATTERNPOS *)malloc (sizeof (GTK_PATTERNPOS) * GTK_DEFAULT_PATCHANNELS); //gtk->patterns[i].len);
                            memset (pDoc->gtk->patterns[pnum].patterndata[i],0,sizeof (GTK_PATTERNPOS) * GTK_DEFAULT_PATCHANNELS); // gtk->patterns[i].len);                        
                        }
                    } else
                    {
                        pDoc->gtk->patterns[pnum].patterndata = (GTK_PATTERNPOS **)oldptr;
                    }
                    
                    return 0;
                }
                break;
            case 'B' :  // Begin mark
                if (pDoc->editData.state!=GTK_EDITSTATE_PATTERNSELECT)
                {
                  pDoc->editData.state = GTK_EDITSTATE_PATTERNSELECT;
                  pDoc->editData.patternmark = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
                  pDoc->editData.beginmark=patCursor;
                  pDoc->editData.endmark=patCursor;
                } else pDoc->editData.state = GTK_EDITSTATE_DEFAULT;
                return 0;
                break;
            case 'I' :
                PatternInterpolate (patCursor.rowcol,pDoc->editData.beginmark.pos,pDoc->editData.endmark.pos);
                break;
/*
      case 'F' :
        // kopiera
        CopyPatternBlock();
        pDoc->editData.state = GTK_EDITSTATE_DEFAULT;
        return 0;
        break;
      case 'G' :
        PastePatternBlock();
        pDoc->editData.state = GTK_EDITSTATE_DEFAULT;
        return 0;
        break;
*/
        

		}
	}

	if (nChar == -1)
	{
		if (!ctrlflag)
		{
			switch (patCursor.rowcol)
			{
				case 0 :
					patpos->note = 0;
					break;
				case 1 :
				case 2 :
					patpos->velocity = 0;
					break;
				case 3 :
				case 4 :
					patpos->fx = 0;
					break;
				case 5 :
				case 6 :
					patpos->param = 0;
					break;

			} 
		} else memset (patpos,0,sizeof (GTK_PATTERNPOS));
		return 1;
	}

	
	if (!patCursor.rowcol)
	{

		// special key:
		if (nChar == VK_OEM_102)
		{
			val = GTK_NOTE_OFF;
		} else
			{
				ptr = strchr (legal_note_char,nChar);
				if (ptr != NULL)
				{
					val = ptr - (char *)legal_note_char;
					val = legal_note_num[val] + pDoc->editData.octave*12;
					if (val > 6*12) return 0;
				} else return 0;
			}
	} else
		{
			ptr = strchr (legal_num_char,nChar);	
			if (ptr!=NULL)
				val = ptr-(char *)legal_num_char;
			else return 0;
		}


	switch (patCursor.rowcol)
	{
		case 0 :
			patpos->note = val;
      if (!patpos->velocity) patpos->velocity  = 0x80;
      break;
		case 1 :
			SETHIBYTE (patpos->velocity,val);
			break;
		case 2 :
			SETLOWBYTE (patpos->velocity,val);
			break;
		case 3 :
			SETHIBYTE (patpos->fx,val);
			break;
		case 4 :
			SETLOWBYTE (patpos->fx,val);
			break;
		case 5 :
			SETHIBYTE (patpos->param,val);
			break;
		case 6 :
			SETLOWBYTE (patpos->param,val);
			break;
		default :
			return 0;

	}
	return 1;
	
}
void CPatternView::MovePatternCursor (int val,int flag)
{
	CTrackerDoc *pDoc = GetDocument ();
	int pnum = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;

	switch (flag)
	{
		case 0 :
			if ((val==1) || (val==-1)) val*=pDoc->editData.patposadd;			
			patCursor.pos+=val;
			if (patCursor.pos > pDoc->gtk->patterns[pnum].len-1) patCursor.pos = pDoc->gtk->patterns[pnum].len-1;//patCursor.pos = 63;
			if (patCursor.pos < 0) patCursor.pos = 0;	
			break;
		case 1:
			patCursor.rowcol+=val;
			if (patCursor.rowcol > 6) patCursor.rowcol = 0;
			if (patCursor.rowcol < 0) patCursor.rowcol = 6;
			break;
		case 2 :
			patCursor.col+=val;
			if (patCursor.col > 15) patCursor.col = 0;
			if (patCursor.col < 0) patCursor.col = 15;
			break;
	}

  if (pDoc->editData.state == GTK_EDITSTATE_PATTERNSELECT)
  {
    pDoc->editData.endmark=patCursor;
  }
}
void CPatternView::SetPatternCursor (int val,int flag)
{
	if (!flag)
	{
		patCursor.pos=val;
	} else
		{
			patCursor.rowcol = val;			
		}
}
/*_-------------------------------------------
	process pattern key
	
	dispatch diffrent actions depending on keyobard input
	default is to call the pattern key edit function

    auth:
		gnilk
-------------------------------------*/
void CPatternView::ProcessPatternKey(UINT nChar, UINT nRepCnt, UINT nFlags)
{
  CTrackerDoc *pDoc = GetDocument ();
  
  EDITDATA *edt;
  edt = &pDoc->editData;
  if (pDoc != NULL)
  {
    int pnum = pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos].pattern;
    
    switch (nChar)
    {
    case VK_F1 :
      edt->octave = 0;
      break;
    case VK_F2 :
      edt->octave = 1;
      break;
    case VK_F3 :
      edt->octave = 2;
      break;
    case VK_F4 :
      edt->octave = 3;
      break;
    case VK_F5 :
      edt->octave = 4;
      break;
    case VK_HOME :
      SetPatternCursor (0,0);
      break;
    case VK_END :
      SetPatternCursor (pDoc->gtk->patterns[pnum].len-1,0);
      break;
    case VK_DOWN :
      if (!(GetKeyState (VK_CONTROL) & 0x8000))
        MovePatternCursor (1,0);
      else
        if (pDoc->editData.state == GTK_EDITSTATE_DEFAULT)
          isPatternEdit=0;
      break;
    case VK_UP :
      if (!(GetKeyState (VK_CONTROL) & 0x8000))
        MovePatternCursor (-1,0);
      else
        if (pDoc->editData.state == GTK_EDITSTATE_DEFAULT)
          isPatternEdit=0;
      break;
    case VK_NEXT :
      MovePatternCursor (16,0);
      break;
    case VK_PRIOR :
      MovePatternCursor (-16,0);
      break;
    case VK_RIGHT :
      if (!(GetKeyState (VK_CONTROL) & 0x8000))
        MovePatternCursor (1,1);
      else
      {
        MovePatternCursor (1,2);
        SetPatternCursor (0,1);
      }
      break;
    case VK_LEFT :
      if (!(GetKeyState (VK_CONTROL) & 0x8000)) 
        MovePatternCursor (-1,1);
      else
      {
        if (!patCursor.rowcol) MovePatternCursor (-1,2);
        SetPatternCursor (0,1);
      }
      break;
    case VK_TAB :
      if (!(GetKeyState (VK_RSHIFT) & 0x8000))
      {
        if (GetKeyState (VK_LSHIFT) & 0x8000)
          MovePatternCursor (-1,2);
        else MovePatternCursor (1,2);
      } else
      {
        if (pDoc->editData.state == GTK_EDITSTATE_DEFAULT)
          isPatternEdit=0;
      }
      break;
				case VK_DELETE :
          if (PatternProcessEditKey (-1,(GetKeyState (VK_CONTROL) & 0x8000)))
            MovePatternCursor (1,0);
          break;
        default :
          if (PatternProcessEditKey (nChar,(GetKeyState (VK_CONTROL) & 0x8000)))
            MovePatternCursor (1,0);
          break;
          
    } // switch
//    pDoc->UpdateAllViews (NULL);
    //pDoc->SetModifiedFlag();
    //pDoc->UpdateAllViews(this);
    Invalidate();
    UpdateWindow();
    
  }
}
