// InsertFilter.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "InsertFilter.h"
#include "isSynth.h"
#include "isFilter.h"
#include "tkerror.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInsertFilter dialog

#define FloatIntMAX 1024
#define uFloatToInt(a) ((a)*1024)
#define sFloatToInt(a) ((a)*1024+1024)

#define uIntToFloat(a) ((a)/1024.0f)
#define sIntToFloat(a) (((a)-1024)/1024.0f)


CInsertFilter::CInsertFilter(CWnd* pParent /*=NULL*/)
	: CInsertBaseDlg(CInsertFilter::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInsertFilter)
	//}}AFX_DATA_INIT
}


void CInsertFilter::DoDataExchange(CDataExchange* pDX)
{
	CInsertBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInsertFilter)
	DDX_Control(pDX, IDC_CHECK_FILTERCASCADE, m_cascade);
	DDX_Control(pDX, IDC_EDIT_FILTERMODAMOUNT3, m_fltmodamount3);
	DDX_Control(pDX, IDC_EDIT_FILTERMODAMOUNT2, m_fltmodamount2);
	DDX_Control(pDX, IDC_EDIT_FILTERMODAMOUNT1, m_fltmodamount1);
	DDX_Control(pDX, IDC_COMBO_FILTERMODNR3, m_modnrlist3);
	DDX_Control(pDX, IDC_COMBO_FILTERMODNR2, m_modnrlist2);
	DDX_Control(pDX, IDC_COMBO_FILTERMODNR1, m_modnrlist1);
	DDX_Control(pDX, IDC_STATIC_RESVALUE, m_resvalue);
	DDX_Control(pDX, IDC_STATIC_GAINVALUE, m_gainvalue);
	DDX_Control(pDX, IDC_STATIC_CUTVALUE, m_cutvalue);
	DDX_Control(pDX, IDC_SLIDER_RESONACE, m_sliderResonance);
	DDX_Control(pDX, IDC_SLIDER_GAIN, m_sliderGain);
	DDX_Control(pDX, IDC_SLIDER_CUTOFF, m_sliderCutoff);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInsertFilter, CInsertBaseDlg)
	//{{AFX_MSG_MAP(CInsertFilter)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_RADIO_LP, OnRadio)
	ON_CBN_SELCHANGE(IDC_COMBO_FILTERMODNR1, OnSelchangeComboFiltermodnr)
	ON_EN_MAXTEXT(IDC_EDIT_FILTERMODAMOUNT1, OnMaxtextEditFiltermodamount)
	ON_BN_CLICKED(IDC_CHECK_FILTERCASCADE, OnCheckFiltercascade)
	ON_BN_CLICKED(IDC_RADIO_HP, OnRadio)
	ON_BN_CLICKED(IDC_RADIO_BP, OnRadio)
	ON_BN_CLICKED(IDC_RADIO_BS, OnRadio)
	ON_CBN_SELCHANGE(IDC_COMBO_FILTERMODNR2, OnSelchangeComboFiltermodnr)
	ON_CBN_SELCHANGE(IDC_COMBO_FILTERMODNR3, OnSelchangeComboFiltermodnr)
	ON_EN_MAXTEXT(IDC_EDIT_FILTERMODAMOUNT2, OnMaxtextEditFiltermodamount)
	ON_EN_MAXTEXT(IDC_EDIT_FILTERMODAMOUNT3, OnMaxtextEditFiltermodamount)
	ON_BN_CLICKED(IDC_RADIO_FORMANT, OnRadio)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInsertFilter message handlers
void CInsertFilter::SetCntrlData()
{
    char buffer[128];
    isFilter *filter;
    filter = (isFilter *)insert;
    m_sliderGain.SetPos(uFloatToInt(filter->gain));
    m_sliderCutoff.SetPos(uFloatToInt(filter->cutoff));
    m_sliderResonance.SetPos(uFloatToInt(filter->resonance));


    sprintf (buffer,"%5.4f",filter->gain);
    m_gainvalue.SetWindowText (buffer);
    sprintf (buffer,"%5.4f",filter->cutoff);
    m_cutvalue.SetWindowText (buffer);
    sprintf (buffer,"%5.4f",filter->resonance);
    m_resvalue.SetWindowText (buffer);

    CheckDlgButton(IDC_RADIO_LP,0);
    CheckDlgButton(IDC_RADIO_HP,0);
    CheckDlgButton(IDC_RADIO_BP,0);
    CheckDlgButton(IDC_RADIO_BS,0);


    switch (filter->mode)    
    {
    case LP :
        CheckDlgButton(IDC_RADIO_LP,1);
        break;
    case HP :
        CheckDlgButton(IDC_RADIO_HP,1);
        break;
    case BP :
        CheckDlgButton(IDC_RADIO_BP,1);
        break;
    case BS :
        CheckDlgButton(IDC_RADIO_BS,1);
        break;
    case FORMANT :
        CheckDlgButton(IDC_RADIO_FORMANT,1);
        break;
    }

    if(filter->cascade)
        CheckDlgButton(IDC_CHECK_FILTERCASCADE,1);
    else
        CheckDlgButton(IDC_CHECK_FILTERCASCADE,0);

    
    
}
void CInsertFilter::ReadCntrlData()
{
    int i,csel;
    char buffer[128];

    isFilter *filter;
    filter = (isFilter *)insert;
    filter->gain=uIntToFloat(m_sliderGain.GetPos());
    filter->cutoff=uIntToFloat(m_sliderCutoff.GetPos());
    filter->resonance=uIntToFloat(m_sliderResonance.GetPos());

    
    CEdit *edtab[]={&m_fltmodamount1,&m_fltmodamount2,&m_fltmodamount3};
    CComboBox *listtab[]={&m_modnrlist1,&m_modnrlist2,&m_modnrlist3};
    for (i=0;i<3;i++)
    {    
        
        edtab[i]->GetWindowText (buffer,128);
        
        
        filter->modAmount[i]=atof (buffer);
        tdbg_printf("  assiging: %d with %f\n",i,filter->modAmount[i]);
        csel = listtab[i]->GetCurSel ();
        filter->modNr[i]=listtab[i]->GetItemData(csel);
    }

    
    if (IsDlgButtonChecked(IDC_CHECK_FILTERCASCADE))
        filter->cascade = true;
    else
        filter->cascade = false;
    
    
    
    if (IsDlgButtonChecked(IDC_RADIO_LP))
        filter->mode = LP;
    else
        if (IsDlgButtonChecked(IDC_RADIO_HP))
            filter->mode = HP;
        else
            if (IsDlgButtonChecked(IDC_RADIO_BP))
                filter->mode = BP;
            else
                if (IsDlgButtonChecked(IDC_RADIO_BS))
                    filter->mode = BS;
                else
					if (IsDlgButtonChecked(IDC_RADIO_FORMANT))
						filter->mode = FORMANT;
					else
						filter->mode = LP;
                
                
//    instrument->Update();
}
void CInsertFilter::UpdateInsertData()
{
    int i,j;
    char buffer[128];
    isFilter *filter;
    filter = (isFilter *)insert;
    
    CComboBox *listtab[]={&m_modnrlist1,&m_modnrlist2,&m_modnrlist3};
    
    for (i=0;i<3;i++)
        listtab[i]->ResetContent();
    for (i=0;i<voice->GetNrOfModulators();i++)
    {
        sprintf (buffer,"modnr:%d",i);
        tdbg_printf("  modnr: %d\n",i);
        for (j=0;j<3;j++)
        {
            listtab[j]->InsertString(i,buffer);
            listtab[j]->SetItemData(i,i);
        }
        //listtab[j]->SetCurSel(voice->GetModulator)
    }
    for (i=0;i<3;i++)
        listtab[i]->SetCurSel(filter->modNr[i]);

    CEdit *dumtab[]={&m_fltmodamount1,&m_fltmodamount2,&m_fltmodamount3};
    
    for (i=0;i<3;i++)
    {
        sprintf (buffer,"%f",filter->modAmount[i]);
        dumtab[i]->SetWindowText (buffer);
        tdbg_printf("  fetching: %d with %f\n",i,filter->modAmount[i]);
    }
    
    
    SetCntrlData();
}

void CInsertFilter::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
    
    ReadCntrlData();
    SetCntrlData();
    
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}


BOOL CInsertFilter::OnInitDialog() 
{
	CInsertBaseDlg::OnInitDialog();
	
	// TODO: Add extra initialization here
    m_sliderCutoff.SetRange(0,FloatIntMAX);
    m_sliderGain.SetRange(0,FloatIntMAX);
    m_sliderResonance.SetRange(0,FloatIntMAX);

       
    
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CInsertFilter::OnRadio() 
{
	// TODO: Add your control notification handler code here
    ReadCntrlData();
	
}

void CInsertFilter::OnSelchangeComboFiltermodnr() 
{
	// TODO: Add your control notification handler code here
    ReadCntrlData();	
}

void CInsertFilter::OnMaxtextEditFiltermodamount() 
{
	// TODO: Add your control notification handler code here
    ReadCntrlData();	
}

void CInsertFilter::OnCheckFiltercascade() 
{
	// TODO: Add your control notification handler code here
    ReadCntrlData();
	
}
