/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isFilter_h
#define __isFilter_h

#include "isInsert.h"
#include "isModulator.h"

#define CUTOFF_MIN 0.004f // lower clamp value of cutoff
#define CUTOFF_MAX 1.0f // upper clamp value of cutoff
enum isFilterMode
{
	LP = 0,HP,BP,BS,FORMANT
};

class isFilter : public isInsert
{
public:
	isFilter(isModulator **modList);
	virtual ~isFilter();

	void Load(isFile *f);
	void Save(isFile *f);
	
	void Play(float *buffer, int polyNr);
	void Event(isEVENT event, int polyNr) { };
	
	// the variables
	isFilterMode mode;
	float cutoff;
	float resonance;
	float gain;
	bool cascade;				// cascade two filters for 24db/octave ?
	// modulators (max is 256, so 8bits is enough for indexing)
	// 0 1 = cutoff  -  3 = mod 0 amount (303 anyone?)
	unsigned char modNr[3]; 
	// amount for each
	float modAmount[3];	
	
private:
	isModulator  **modulatorList;
	

	// for the pure rendering part
	float lo[MAXPOLY],hi[MAXPOLY],bp[MAXPOLY],bs[MAXPOLY];
	// for the cascaded
	float lo2[MAXPOLY],hi2[MAXPOLY],bp2[MAXPOLY],bs2[MAXPOLY];

	// formant filter stuff
	static const double coeff[5][11];
	double memory[10][MAXPOLY]; 


};

#endif
