#pragma once

//#ifndef __VIO_H
//#define __VIO_H

#ifdef __WATCOMC__
#pragma library("formats.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include "system/xstdio.h"
#include "misc/col.h"

typedef struct s_VIO VIO;
typedef enum
{
	VIOFLAG_8BIT = 1 << 0,
  VIOFLAG_24BIT = 1 << 1,
  VIOFLAG_32BIT = 1 << 2,
  VIOFLAG_PALETTE = 1 << 3,
  VIOFLAG_ZBUFFER = 1 << 4,
  VIOFLAG_YTAB = 1 << 5,
  VIOFLAG_16BIT = 1 << 6
} VIOFLAGS;

VIO *vio_load ( char *filename);
int vio_save ( char *filename, VIO *image);

VIO *vio_create8bit( int *zbuffer, RGB *palette, BYTE *image, int width, int height);
VIO *vio_create24bit( int *zbuffer, RGB *image, int width, int height);
VIO *vio_create32bit( int *zbuffer, RGBA *image, int width, int height);
void vio_free( VIO *image);

int vio_make8bit( VIO *image);
int vio_make16bit (VIO *image);
int vio_make24bit (VIO *image);
int vio_make32bit (VIO *image);

struct s_VIO
{
	int width,height;

	VIOFLAGS flags;

	RGB *palette;
	BYTE *image8;
  WORD *image16;
	RGB *image24;
	RGBA *image32;

  int *zbuffer;
	int *ytab;
};

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
