/*--------------------------------------------------------------------------
 * File: lws2v3d.c
 * Written by: Alexander Boczar, 1997-05-04
 * Description: Lightwave Scene to V3D converter
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-xx-xx | Alexander Boczar |
 * 1997-10-18 | Fredrik Kling    | M$ Dev-studio
 *
 * Todo:
 *
 -------------------------------------------------------------------------------*/

#include <stddef.h>
#include "formats/lws.h"
#include "formats/v3d.h"

int main( int argc, char *argv[])
{
  V3D *v3d;

  if (argc<2)
  {
    printf (" usage: lws2v3d <infile> <outfile>\n");
    exit (1);
  }
	printf ("-+- Reading LWS file -+-\n");
  if ((v3d=lws_load(argv[1]))!=NULL)
	{
		printf ("-+- Writing V3D file -+-\n");
  		v3d_save (v3d,argv[2],V3D_SAVE_NORMAL);
 	} else printf ("[!] %s\n",lws_geterror ());
	return( 0);
}
