/*-----------------------------------------------------------------------------
 * File: matrix.h
 * Written by: Fredrik Kling, 1997-03-05
 * Description: Header file for matrix calculations
 *
 * -- Date -- | --- Name ---- |-- Did what....
 * 1997-05-03 | Fredrik Kling | Implementation
 * 1997-05-29 | Fredrik Kling | matrix-vector multiplikation i asm... QUAKE!
 *-----------------------------------------------------------------------------*/

#pragma once

//#ifndef __MATRIX_H
//#define __MATRIX_H

#ifdef __WATCOMC__
#pragma library("vmath.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include "vmath/vector.h"

// Type definitions

typedef struct s_MATRIX MATRIX;

// Structures!

struct s_MATRIX
{
  float el[3][3];
};

void matmul (MATRIX  *,MATRIX *, MATRIX *);
void rotateZ (int v, MATRIX *);
void rotateX (int v, MATRIX *);
void rotateY (int v, MATRIX *);
void buildrotationmatrix (int , int , int ,MATRIX *);
void matrixfromvectors (VECTOR *, VECTOR *, MATRIX *);

void vecmul (MATRIX *, VECTOR *, VECTOR *);
#ifdef __WATCOMC__
#pragma aux vecmul "*" = \
	"fld	dword ptr [ebx]",\
	"fmul	dword ptr [esi]",\
	"fld  dword ptr [ebx]",\
	"fmul dword ptr [esi + 12]",\
	"fld	dword ptr [ebx]",\
	"fmul dword ptr [esi + 24]",\
\
	"fld	dword ptr [ebx + 4]",\
	"fmul dword ptr [esi + 4]",\
	"fld  dword ptr [ebx + 4]",\
	"fmul dword ptr [esi + 16]",\
	"fld	dword ptr [ebx + 4]",\
	"fmul dword ptr [esi + 28]",\
\
	"fxch	st(2)",\
	"faddp	st(5),st(0)",\
	"faddp  st(3),st(0)",\
	"faddp  st(1),st(0)",\
\
	"fld	dword ptr [ebx + 8]",\
	"fmul dword ptr [esi + 8]",\
	"fld  dword ptr [ebx + 8]",\
	"fmul dword ptr [esi + 20]",\
	"fld	dword ptr [ebx + 8]",\
	"fmul dword ptr [esi + 32]",\
\
	"fxch	st(2)",\
	"faddp	st(5),st(0)",\
	"faddp  st(3),st(0)",\
	"faddp  st(1),st(0)",\
\
	"fstp	dword ptr	[edi+8]",\
	"fstp dword ptr [edi+4]",\
	"fstp dword ptr [edi]",\
	parm [esi] [ebx] [edi];
#endif

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif

