/*
 * Decompiled with CFR 0.152.
 */
package code;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import micromod.MicroMod;
import micromod.Module;
import micromod.ModuleLoader;
import micromod.output.JavaSoundOutputDevice;
import micromod.output.PCM16StreamOutputDevice;
import micromod.output.converters.SS16LEAudioFormatConverter;
import micromod.resamplers.LinearResampler;

class micromodplayer {
    MicroMod microMod;
    PCM16StreamOutputDevice outDev = null;

    micromodplayer() {
    }

    public void play() {
        this.microMod.doRealTimePlayback();
    }

    public void pause() {
        this.outDev.pause();
    }

    public void stop() {
        try {
            this.outDev.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void off() {
        this.outDev.close();
        this.outDev = null;
    }

    public void start(String fileName) {
        try {
            this.outDev = new JavaSoundOutputDevice(new SS16LEAudioFormatConverter(), 44100, 1000);
            Module module = ModuleLoader.read(new RandomAccessFile(fileName, "r"));
            this.microMod = new MicroMod(module, this.outDev, new LinearResampler());
            this.outDev.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startFromZip(String zipName, String fileName) {
        try {
            this.outDev = new JavaSoundOutputDevice(new SS16LEAudioFormatConverter(), 44100, 1000);
            ZipFile zf = new ZipFile(zipName);
            ZipEntry ze = zf.getEntry(fileName);
            InputStream is = zf.getInputStream(ze);
            DataInputStream dis = new DataInputStream(is);
            Module module = ModuleLoader.read(dis);
            this.microMod = new MicroMod(module, this.outDev, new LinearResampler());
            this.outDev.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

