/*
 * $Id: c64_state.hpp 150 2007-11-08 23:44:59Z ehaase $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



#ifndef C64_STATE_HPP
#define C64_STATE_HPP

#include "main.hpp"
#include "state.hpp"
#include "bitmap/bitmap.hpp"
#include "timer.hpp"


class c64_state :
	public state
{
public:
	c64_state(void);
	~c64_state(void);
	virtual void enterState(void);
	virtual void exitState(void);
	virtual void update(void);
private:
	// C64 screen
    Bitmap     *c64screen;
	static const int   COLIDX_UPPERTEXT_AND_BORDER  = 0;
	static const int   COLIDX_BACKGROUND			= 1;
    static const int   COLIDX_LOWERTEXT				= 2;
    static const int   COLIDX_CURSOR				= 3;
	PALETTEENTRY lightBlue;
	PALETTEENTRY darkBlue;
    RECT        full;
	Timer timer;
	DWORD knownElapsed;
};

#endif
