/*
 * $Id: keyboard.hpp 149 2007-11-08 23:43:53Z hangman $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



#ifndef KEYBOARD_HPP
#define KEYBOARD_HPP



//
// MACROS
//

/* Reads the keyboard asynchronously */
#define KEY_DOWN(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
/* Reads the keyboard asynchronously */
#define KEY_UP(vk_code)   ((GetAsyncKeyState(vk_code) & 0x8000) ? 0 : 1)
/* Reads the keyboard asynchronously, but halts until a pressed key is released. */



//
// Functions.
//

/** */
bool keyPressed(int vk_code);



#endif
