/*
 * $Id: main.hpp 149 2007-11-08 23:43:53Z hangman $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



#ifndef MAIN_HPP
#define MAIN_HPP



//
// DEFINES
//

/* Excludes several things from Windows' include files. */
#define WIN32_LEAN_AND_MEAN
/* require at least version 7 of DirectX */
#define DIRECTDRAW_VERSION 0x0700

/* Windows class name. */
#define WINDOW_CLASS_NAME "WHAT_WE_ARE"
/* Window title */
#define WINDOW_TITLE "DirectX WhatWeAre"
/* size of window */
#define WINDOW_WIDTH  0         
/* size of window */
#define WINDOW_HEIGHT 0
/* size of screen */
#define SCREEN_WIDTH  320      
/* size of screen */
#define SCREEN_HEIGHT 240
/* bits per pixel */
#define SCREEN_DEPTH 8          
/* desired screen refresh rate */
#define SCREEN_REFRESH_HZ 60

/* App (selfmade) message: advance the state! */
#define APPMSG_ADVANCE_STATE  123
/* App (selfmade) message: we have the focus back, resume! */
#define APPMSG_RESUME         456

/* Utility to clear memory are with zeroes */
#define ZeroMem(x) {memset(&x, 0, sizeof(x));}

/* Because of a bug in the audio subsystem, after pausing a module,
 * we need to stay updating the audio frames, even when in NULL state
 * (i.e. ALT-TABbed away to desktop).
 */
#define AUDIO_PAUSE_WORKAROUND

//
// INCLUDES ///////////////////////////////////////////////
//

#include <windows.h>
#include <windowsx.h> 
#include <mmsystem.h>

#include <iostream>
#include <memory>
#include <string>

#include <initguid.h> // So that we can safely use versioned DIRECTDRAW7 and such.
#include <ddraw.h>    // DirectX includes

#include "compat.hpp"
#include "exceptions.hpp"

//
// Exported variables.
//

extern HWND                    main_window_handle;
extern LPDIRECTDRAW7           lpdd;                   // dd object
extern LPDIRECTDRAWSURFACE7    lpddsprimary;           // dd primary surface
extern LPDIRECTDRAWSURFACE7    lpddsback;              // dd backbuffer surface (for double buffering)
extern LPDIRECTDRAWPALETTE     lpddpal;                // a pointer to the created dd palette



//
// Functions.
//
void clearSurfaces(void) /*throw (GameException)*/; // TODO: why can we not declare "throw" like this?!



#endif
