#include "dream.h"
#include "eblogo.h"
#include "ebdemo.h"
#include "to2.h"
#include "myclouds.h"

int imgx, imgy;
RGB_T background;
int goingright, goingdown;

void dcPaintBG(RGB_T color)  {
  int x, y;

  for (y=0; y<480; y++) {
    for (x=0; x<640; x++) {
       vram_l [y*640+x] = (color.red << 16) | (color.green << 8) |
                          (color.blue << 0);
    }
  }
}

void dcDrawHLine(int x1, int x2, int y, RGB_T color) {
  int tmpx;

  for (tmpx = x1; tmpx < x2; tmpx++) {
    vram_l[y * 640 + tmpx] = (color.red << 17) | (color.green << 8) | 
                             (color.blue << 0);
  } 

}

void dcDrawVLine(int y1, int y2, int x, RGB_T color) {
  int tmpy;

  for (tmpy = y1; tmpy < y2; tmpy++) {
    vram_l[tmpy * 640 + x] = (color.red << 17) | (color.green << 8) |
                             (color.blue << 0);
  } 

}

void showshutdown(unsigned int showx, unsigned int showy) {
  int x, y, refpt;
  RGB_T col;

  col.red=0; col.green=0; col.blue=0;
  dcPaintBG(col);
  
  
  refpt = 0;
  for (x = shutdown.height; x > 0; x--) {
    for (y = 0; y < shutdown.width; y++) {
       vram_l [(-(x-shutdown.height) + showy)*640+(y + showx)] = 
         (shutdown.pixel_data[refpt] << 16)  |
         (shutdown.pixel_data[refpt+1] << 8) |
         (shutdown.pixel_data[refpt+2] << 0); 
      refpt += 4;
    }
  }
}


void showeblogo(int showx, int showy) {
  int x, y, refpt;
 
  refpt = 0;
  for (x = gimp_image.height; x > 0; x--) {
    for (y = 0; y < gimp_image.width; y++) {
       vram_l [(-(x-gimp_image.height) + showy)*640+(y + showx)] = 
         (gimp_image.pixel_data[refpt] << 16)  |
         (gimp_image.pixel_data[refpt+1] << 8) |
         (gimp_image.pixel_data[refpt+2] << 0); 
      refpt += 3;
    }
  }
}

int get_cont_stat() {
  uint8 mcont;
  cont_cond_t cond;

  mcont = maple_controller_addr();
  if (!mcont) {
    printf("No Controllers attached\r\n");
    return -1;
  }

  if (cont_get_cond(mcont, &cond)) {
    printf("Error getting statusr\n");
    return -1;
  } 
  return cond.buttons;
} 

void drawSlider(int x, int y,int lenx,int endheight, RGB_T color) {
  dcDrawHLine(x,x + lenx,y, color);
  dcDrawVLine(y-(endheight/2),y+(endheight/2),x,color);
  dcDrawVLine(y-(endheight/2),y+(endheight/2),x+lenx,color);
}

void redraw(void) {
  showeblogo(imgx, imgy);
}

int adjustgreen() {
  int stat;
  RGB_T color;
  while (1) {
    stat = get_cont_stat();
    color.red = 0; color.green = 255; color.blue = 0;
    drawSlider(112,320,255,10,color);
    sleep(10);	
    if (!(stat & CONT_X)) {
      return stat;
    }
    if (!(stat & CONT_DPAD_LEFT)) {
      if (background.green > 0) background.green -= 1;
      dcPaintBG(background);
      printf("r %d, g %d, b %d \r\n",background.red, background.green,
                                     background.blue);
    }
    if (!(stat & CONT_DPAD_RIGHT)) {
      if (background.green < 127) background.green  += 1;
      dcPaintBG(background);
      printf("r %d, g %d, b %d \r\n",background.red, background.green,
                                     background.blue);
    }
  }
  return -1;
}

int adjustblue() {
  int stat;
  RGB_T color;
  while (1) {
    stat = get_cont_stat();
    color.red = 0; color.green = 0; color.blue = 255;
    drawSlider(112,260,255,10,color);
    sleep(10);	
    if (!(stat & CONT_X)) {
      return stat;
    }
    if (!(stat & CONT_DPAD_LEFT)) {
      if (background.blue   >   0) background.blue   -= 1;
      dcPaintBG(background);
      printf("r %d, g %d, b %d \r\n",background.red, background.green,
                                     background.blue);
    }
    if (!(stat & CONT_DPAD_RIGHT)) {
      if (background.blue < 127) background.blue  += 1;
      dcPaintBG(background);
      printf("r %d, g %d, b %d \r\n",background.red, background.green,
                                     background.blue);
    }
  }
  return -1;
}


int adjustred() {
  int stat;
  RGB_T color;
  while (1) {
    stat = get_cont_stat();
    color.red = 255; color.green = 0; color.blue = 0;
    drawSlider(112,200,255,10,color);
    sleep(10);	
    if (!(stat & CONT_X)) {
      return stat;
    }
    if (!(stat & CONT_DPAD_LEFT)) {
      if (background.red   >   0) background.red   -= 1;
      dcPaintBG(background);
      printf("r %d, g %d, b %d \r\n",background.red, background.green,
                                     background.blue);
    }
    if (!(stat & CONT_DPAD_RIGHT)) {
      if (background.red < 127) background.red   += 1;
      dcPaintBG(background);
      printf("r %d, g %d, b %d \r\n",background.red, background.green,
                                     background.blue);
    }
  }
  return -1;
}

void showstartup() {
    
  int x, y, refpt, status;
 
  refpt = 0;
  for (x = startup.height; x > 0; x--) {
    for (y = 0; y < startup.width; y++) {
       vram_l [(-(x-startup.height))*640+y] = 
         (startup.pixel_data[refpt] << 16)  |
         (startup.pixel_data[refpt+1] << 8) |
         (startup.pixel_data[refpt+2] << 0); 
      refpt += 3;
    }
  }
  
  sleep(10000);
  
}

int docontroller(void) {
  int status;
      
  status = get_cont_stat();
   if (status > 0) {
    if(!(status & CONT_DPAD_UP)) {
      imgy -= 1;
      redraw();
      return 0;
    }

    if(!(status & CONT_DPAD_DOWN)) {
      imgy += 1;
      redraw();
      return 0;
    }

    if(!(status & CONT_DPAD_LEFT)) {
      imgx -= 1;
      redraw();
      return 0;
    }

    if(!(status & CONT_DPAD_RIGHT)) {
      imgx += 1;
      redraw();
      return 0; 
    }
    
    if(!(status & CONT_A)) {
      if (adjustred() & CONT_X) {
        redraw();
        return 0;
      }
    }

    if(!(status & CONT_Y)) {
      if (adjustgreen() & CONT_X) {
        redraw();
        return 0;
      }
    }

    if(!(status & CONT_B)) {
      if (adjustblue() & CONT_X) {
        redraw();
        return 0;
      }
    }

    if(!(status & CONT_START)) {
      return -1;
    }
    sleep(10);

    if (goingright == 1) imgx++; else imgx--;
    if (goingdown  == 1) imgy++; else imgy--;
    if (imgx == 640 - gimp_image.height) goingright = 0;
    if (imgx == 0) goingright   = 1;
    if (imgy == 0) goingdown = 1;
    if (imgy == 480 - gimp_image.width) goingdown = 0;

    showeblogo(imgx,imgy);
  }
  return 0;   
}

int dc_main() {
  
  imgx = 1;
  imgy = 1;
  goingright = 1;
  goingdown = 1;

  dc_setup(DM_640x480, PM_RGB888);

  showstartup(); 

  background.red = 0; background.green = 0; 
  background.blue = 0;
  dcPaintBG(background);   
  showeblogo(imgx,imgy);  

  while (1) {
    if (docontroller() == -1) {
      showshutdown((640-shutdown.width)/2,(480-shutdown.height)/2);
      break;
    }
  }  

  return 0;
}
