#include "main.h"
#include "distort.h"

static GLuint dist_tex;
static GLuint scr_tex;
texdata_t *texture;

void make_distortion (int, int, float *, float *, float, int);

/* du kan egentlig drite i denne funksjonen */
void
make_texture (void)
{
  int i, j, d;
  texdata_t imgdata[64][64];

  for (i = 0; i < 64; i++)
    {
      for (j = 0; j < 64; j++)
	{
	  d = ((i&0x8)^(j&0x8))*255;
	  imgdata[i][j].r = d;
	  imgdata[i][j].g = d;
	  imgdata[i][j].b = d;
	  imgdata[i][j].a = 255;
	}
    }

  glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
  glGenTextures (1, &dist_tex);
  glBindTexture (GL_TEXTURE_2D, dist_tex);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

  glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, 64, 64, 0, GL_RGBA, GL_UNSIGNED_BYTE, imgdata);
}

void
setup_view (void)
{
  if ((texture = malloc (256*256*sizeof(texdata_t))) == NULL)
    {
      fprintf (stderr, "Skaff deg mer minne, lamer!\n");
      exit (1);
    }
  glViewport (0.0, 0.0, 256, 256);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluPerspective (70.0, 256 / 256, 0.1, 100);
  glMatrixMode (GL_MODELVIEW);
}

void
distort_scene (int w, int h, float var, int n, int type)
{
  float u, v;
  int i, j, res = 256, res2 = 128;

  glReadPixels (0, 0, 256, 256, GL_RGBA, GL_UNSIGNED_BYTE, texture);
  glGenTextures (1, &scr_tex);
  glBindTexture (GL_TEXTURE_2D, scr_tex);
  glTexParameterf (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
  glTexParameterf (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR); 
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, 256, 256, 0, GL_RGBA, GL_UNSIGNED_BYTE, texture);

  /* reset view*/
  glViewport (0.0, 0.0, w, h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluPerspective (40.0, (float)w/h, 0.1, 100.0);
  glOrtho (-128/2, 128/2, -128/2, 128/2, 1.0, 1000.0);
  glMatrixMode (GL_MODELVIEW);

  glLoadIdentity ();
  glTranslatef (96, 96, 0);
  glEnable (GL_TEXTURE_2D);
  glBindTexture (GL_TEXTURE_2D, scr_tex);

  glBegin (GL_QUADS);
  for (i = 0; i < res; i += n)
    {
      for (j = 0; j < res; j += n)
	{
	  make_distortion (i, j, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f (i-res2, j-res2, 0);
	  
	  make_distortion (i, j+n, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f (i-res2, (j+n)-res2, 0);
	  
	  make_distortion (i+n, j+n, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f ((i+n)-res2, (j+n)-res2, 0);
	  
	  make_distortion (i+n, j, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f ((i+n)-res2, j-res2, 0);
	}
    }
  glEnd ();

  glDeleteTextures(1, &scr_tex);
  free (texture);
}

/* 
   du kan egentlig drite i denne funksjonen, men kan brukes p
   enkle teksturer, istedenfor hele scenen. Ja, den er helt lik!
   argument 3 = textur-id til teksturen du vil lame med.
*/
void
draw_distortion (int res, float var, int type, int n, int texid)
{
  float u, v;
  int i, j;
  float res2 = (float)res / 2;

  glBindTexture (GL_TEXTURE_2D, texid);
  glEnable (GL_TEXTURE_2D);

  glBegin (GL_QUADS);
  for (i = 0; i < res; i += n)
    {
      for (j = 0; j < res; j += n)
	{
	  make_distortion (i, j, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f (i-res2, j-res2, 0);
	  
	  make_distortion (i, j+n, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f (i-res2, (j+n)-res2, 0);
	  
	  make_distortion (i+n, j+n, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f ((i+n)-res2, (j+n)-res2, 0);
	  
	  make_distortion (i+n, j, &u, &v, var, type);
	  glTexCoord2f (u, v);
	  glVertex3f ((i+n)-res2, j-res2, 0);
	}
    }
  glEnd ();
}

void
make_distortion (int u, int v, float *newu, float *newv, float var, int type)
{
  float x, y, xnew, ynew;
  float a, b;

  x = (float)u / 32;
  y = (float)v / 32;

  /* feel free til  prve  finne p noen re funksjoner til  distorte ting */
  switch (type)
    {
    case NONE:
      xnew = x;
      ynew = y;
      break;
    case EXP_SINE: /* bruk p teksturer */
      xnew = exp(x) * sin(y+var);
      ynew = exp(y) * sin(x-var);
      break;
    case SINE: /* denne er ogs vill */
      xnew = sin(x) * cos(y+var) - sin(y-var) * cos(x-var);
      ynew = cos(x) * sin(y+var) + sin(x+var) * cos(y+var);
      break;
    case WEIRD:
      xnew = x + sin(x)*cos(x)*sin(y-var);
      ynew = y + sin(y)*cos(y)*sin(x+var);
      break;
    case WAVY: /* faen i helvete */
      xnew = x + sin(x)*cos(x)*sin(y+var)*cos(y+var);
      ynew = y + sin(y)*cos(y)*sin(x-var)*cos(x-var);
      break;
    }

  *newu = xnew / 2;
  *newv = ynew / 2;
}
