﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using OpenTK.Graphics.OpenGL;

namespace Pixels3d
{
    /// <summary>
    /// Represents a pixel block (cube) to be rendered
    /// </summary>
    public class PixelBlock
    {
        public float X, Y, Z, Depth;
        public PixelColor Color;

        public PixelBlock(float x, float y, float z, float depth)
        {
            X = x;
            Y = y;
            Z = z;
            Depth = depth;
        }
        
        public PixelBlock(float x, float y, float z, float depth, PixelColor color) : this(x,y,z, depth)
        {
            Color = color;
        }

        public void AddToBuffer(ref RenderBuffer renderBuffer)
        {
            renderBuffer.AddVertex(new Vertex(-1.0f + X, -1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(-1.0f + X, 1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, 1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, -1.0f + Y, -1.0f + Z));

            renderBuffer.AddVertex(new Vertex(-1.0f + X, -1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, -1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, -1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(-1.0f + X, -1.0f + Y, 1.0f + Z));

            renderBuffer.AddVertex(new Vertex(-1.0f + X, -1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(-1.0f + X, -1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(-1.0f + X, 1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(-1.0f + X, 1.0f + Y, -1.0f + Z));

            renderBuffer.AddVertex(new Vertex(-1.0f + X, -1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, -1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, 1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(-1.0f + X, 1.0f + Y, 1.0f + Z));

            renderBuffer.AddVertex(new Vertex(-1.0f + X, 1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(-1.0f + X, 1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, 1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, 1.0f + Y, -1.0f + Z));

            renderBuffer.AddVertex(new Vertex(1.0f + X, -1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, -1.0f + Y, -1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, 1.0f + Y, 1.0f + Z));
            renderBuffer.AddVertex(new Vertex(1.0f + X, 1.0f + Y, 1.0f + Z));

            /*
            GL.Color3(pb.Color.R, pb.Color.G, pb.Color.B);
            //GL.Color3(Color.Honeydew);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);

            //GL.Color3(Color.Honeydew);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);

            //GL.Color3(Color.Moccasin);

            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);

            //GL.Color3(Color.IndianRed);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);

            //GL.Color3(Color.PaleVioletRed);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);

            //GL.Color3(Color.ForestGreen);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);

            renderBuffer.AddVertex(new Vertex(X, Y, Z));
            renderBuffer.AddColor(new VertexColor());*/
        }
    }

    /// <summary>
    /// Color for a pixel block
    /// </summary>
    public class PixelColor
    {
        public float R, G, B, A;
        public Color col;

        /// <summary>
        /// Color from float R/G/B
        /// </summary>
        public PixelColor(float r, float g, float b, float a)
        {
            R = r;
            G = g;
            B = b;
            A = a;
        }

        /// <summary>
        /// Color from .net colour
        /// </summary>
        /// <param name="col"></param>
        public PixelColor(System.Drawing.Color col) 
        {
            R = col.R == 0 ? 0 : (float)col.R /255;
            G = col.G == 0 ? 0 : (float)col.G / 255;
            B = col.B == 0 ? 0 : (float)col.B / 255;
            A = col.A == 0 ? 0 : (float)col.A / 255;
        }
    }
        
    /// <summary>
    /// List of pixel blocks, this handles rendering the list of blocks too
    /// </summary>
    public class PixelList : List<PixelBlock>
    {
        public int Width;
        public int Height;

        public static PixelList CurrentList;

        private RenderBuffer _buffer = new RenderBuffer();

        public static PixelList ListFromImageAndHeightMap(Image image, Image heightMap)
        {
            var list = new PixelList();
            list.Width = image.Width;
            list.Height = image.Height;

            // convert images to bitmaps for pixel reading
            var imageBmp = new Bitmap(image);
            var heightBmp = new Bitmap(heightMap);

            // each row
            for (int y = 0; y < image.Height; y++)
            {
                // each column
                for(int x=0; x<image.Width; x++)
                {
                    Color imagePixel = imageBmp.GetPixel(x, y);
                    Color heightPixel = heightBmp.GetPixel(x, y);
                    var depthByte = (byte)((heightPixel.R + heightPixel.G + heightPixel.B)/3);
                    float depthVal = (float)depthByte/255;
                    var pixelColor = new PixelColor(imagePixel);
                    var vertex = new PixelBlock(x, -y, 0, depthVal*10, pixelColor);
                    list.Add(vertex);
                }
            }

            return list;
        }

        /// <summary>
        /// Draws a pixel block
        /// </summary>
        /// <param name="pb"></param>
        private void DrawCube(PixelBlock pb)
        {
            GL.Color3(pb.Color.R, pb.Color.G, pb.Color.B);
            //GL.Color3(Color.Honeydew);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, -1.0f+pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);

            //GL.Color3(Color.Honeydew);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);

            //GL.Color3(Color.Moccasin);

            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);

            //GL.Color3(Color.IndianRed);
            GL.Vertex3(-1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);

            //GL.Color3(Color.PaleVioletRed);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(-1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);

            //GL.Color3(Color.ForestGreen);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, -1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, 1.0f + pb.Y, 1.0f + pb.Depth);
            GL.Vertex3(1.0f + pb.X, -1.0f + pb.Y, 1.0f + pb.Depth);

        }

        /// <summary>
        /// 
        /// </summary>
        public void Render()
        {
            //_buffer.Clear();
            //GL.ColorPointer();
            //GL.DrawArrays(BeginMode.Quads, 0, 50);
            //DrawCube();
            //return;
           // GL.PushMatrix();
            int numPixels = this.Count;
            //GL.Translate(0, 0, 0.0f);
            var start = new PointF(-(Width/2), (Height/2));
            GL.Translate(start.X, start.Y, 0);
            GL.Begin(BeginMode.Quads);
            // each row
            for (int y = 0; y < Height; y++)
            {
                // each column
                for (int x = 0; x < Width; x++)
                {
                    int idx = x + (Width * y);
                    // render the block (cube)
                    DrawCube(this[idx]);
                    //GL.Begin(BeginMode.);
                }
            }
            GL.End();
            //_buffer.Render();
            //GL.PopMatrix();
        }
    }
}
    