/*  FreeJ
 *  (c) Copyright 2001 Denis Roio aka jaromil <jaromil@dyne.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <inttypes.h>

#include <context.h>
#include <screen.h>
#include <font_pearl_8x8.h>
#include <config.h>

#define HBOUND 32
#define VBOUND 23
#define WCENTER (env->screen->w/2)-140
#define VBP 16 /* vertical bound proportion */
#define HBP 13 /* horizontal bound proportion */
#define TOPLIST 6 /* distance down from vbound where they start the vertical lists */


uint32_t *Osd::print(char *text, uint32_t *pos, int hsize, int vsize) {
  uint32_t *diocrap = pos; //(uint32_t *)env->coords(xpos,ypos);
  unsigned char *buffer = (unsigned char *)env->screen->get_surface();
  v = env->screen->w*vsize;
  
  //  len = strlen(text);
  
  /* quest'algoritmo di rastering a grandezza variabile delle font
     e' una cosa di cui vado molto fiero, ogni volta che lo vedo il
     petto mi si gonfia e mi escono sonore scorregge. */
  for (y=0; y<CHAR_HEIGHT; y++) {
    ptr = diocrap += v;
  
    /* control screen bounds */
    if(diocrap-(uint32_t *)buffer>(env->screen->size - env->screen->pitch)) 
      return diocrap-newline; /* low bound */
    while(diocrap-(uint32_t *)buffer<env->screen->pitch) ptr = diocrap += v;

    //    for (x=0; x<len; x++) {
    x=0;
    while(text[x]!='\0') {
      f = fontdata[text[x] * CHAR_HEIGHT + y];
      for (i = CHAR_WIDTH-1; i >= 0; i--)
	if (f & (CHAR_START << i))
	  for(ch=0;ch<hsize;ch++) {
	    for(cv=0;cv<v;cv+=env->screen->w)
	      ptr[cv] = color32;
	    ptr++; }
        else ptr+=hsize; 
      x++;
    }
  }
  return(diocrap);
}

Osd::Osd() {
  env = NULL;
  top = mid = low = false;
}

Osd::~Osd() { }


void Osd::print_low(char *text, ...) {
  va_list arg;
  va_start(arg,text);
  
  vsnprintf(low_str, 50, text, arg);
  low_str[51] = '\0';
  va_end(arg);
  low = true;
}


void Osd::print_mid(char *text, ...) {
  va_list arg;
  va_start(arg,text);
  
  vsnprintf(mid_str, 50, text, arg);
  mid_str[51] = '\0';
  va_end(arg);
  mid = true;
}


void Osd::print_top(char *text, ...) {
  va_list arg;
  va_start(arg,text);
  
  vsnprintf(top_str, 50, text, arg);
  top_str[51] = '\0';
  va_end(arg);
  top = true;
}


void Osd::init(Context *screen) {
  uint32_t vpos;
  this->env = screen;
  set_color(white);

  vpos = env->screen->h/2-120;
  top_offset = (uint32_t*)env->screen->coords(HBOUND+env->screen->h/4,
					      vpos);
  vpos+=60;
					      //	      VBOUND*3);
  mid_offset = (uint32_t*)env->screen->coords(HBOUND+env->screen->h/4,
					      vpos);
					      //	      (env->screen->h/2)-(CHAR_HEIGHT/2));
  vpos+=60;
  low_offset = (uint32_t*)env->screen->coords(HBOUND+env->screen->h/4,
					      vpos);
					      //	      env->screen->h - VBOUND*3);

  newline = env->screen->pitch*(CHAR_HEIGHT);

  func("OSD initialized");
  
}

void Osd::cafudda() {
  env->screen->lock();
  if(top) print(top_str,top_offset,1,2);
  if(mid) print(mid_str,mid_offset,1,2);
  if(low) print(low_str,low_offset,1,2);  
  env->screen->unlock();
}

void Osd::clean() {
  top = mid = low = false;
}

void Osd::set_color(colors col) {
  switch(col) {
  case black:
    color32 = 0x00000000;
    break;
  case white:
    color32 = 0x00fefefe;
    break;
  case green:
    color32 = 0x0000ee00;
    break;
  case red:
    color32 = 0x00ee0000;
    break;
  case blue:
    color32 = 0x000000fe;
    break;
  case yellow:
    color32 = 0x00ffef00;
    break;
  }
}

