/*  FreeJ
 *  (c) Copyright 2001 Denis Roio aka jaromil <jaromil@dyne.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __OSD_H__ 
#define __OSD_H__

#include <context.h>
#include <inttypes.h>


typedef enum { black, white, green, red, blue, yellow } colors;

class Osd {
 private:
  uint32_t newline;
  

  uint32_t *top_offset;
  uint32_t *mid_offset;
  uint32_t *low_offset;

  uint32_t color32;

  /* used by the font renderer */
  int y,x,i,len,f,v,ch,cv;
  uint32_t *ptr;


 public:
  Osd();
  ~Osd();

  void init(Context *screen);
  void cafudda();
  void set_color(colors col);

  bool top, mid, low;
  char top_str[52];
  char mid_str[52];
  char low_str[52];
  void print_low(char *text, ...);
  void print_mid(char *text, ...);
  void print_top(char *text, ...);
  void clean();

  Context *env;

  uint32_t *print(char *text, uint32_t* pos, int hsize, int vsize);

};

#endif
