/* TransHackmeeting intro 2004
 *
 * code by jaromil - dyne.org RASTA SOFTWARE AAAAAAAA rastasoft.org
 * (from FreeJ realtime video engine)
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

#include <iostream>

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <assert.h>
#include <signal.h>

#include <mikmod.h>

#include <context.h>

#include <osd.h>
#include <plugger.h>
#include <jutils.h>
#include <config.h>

#include <png_layer.h>
#include <gen_layer.h>
#include <scroll_layer.h>

/* this is the output context (screen) */
static Context *freej;
/* ===================================== */
static GenLayer *gen = NULL;
static ScrollLayer *scroll = NULL;
static Layer *numeri = NULL;
static Layer *formica = NULL;
static Filter *vertigo = NULL;

static MODULE *climax;
static SDL_Event event;
static bool sigquit = false;
void fsigquit(int Sig) { sigquit = true; }

void cafudda(int c) {
  freej->cafudda(c);
  if(!SDL_PollEvent(&event)) return;
  if(event.type != SDL_KEYDOWN) return;
  if(event.type == SDL_QUIT) sigquit = true;
  if(event.key.keysym.sym == SDLK_ESCAPE ) sigquit = true;
  if(sigquit) {
    freej->close();
    MikMod_Exit();
    exit(1);
  }
}

void fade_out(Layer *lay,int lim) {
  lay->set_blit(9);
  lay->fade_out = lim;
  freej->cafudda(2);
}

void fade_in(Layer *lay,int lim) {
  lay->set_blit(9);
  lay->fade_in = lim;
  freej->cafudda(2);
}

void mutate(bool d) {
  if(!gen) return; /* mutagen paranoia */
  
  fade_out(gen,3);
  cafudda(2);
  gen->blossom_recal(d);
  fade_in(gen,99);  
  cafudda(2);

}


void keypress(SDLKey k, Filter *filt, int t) {
  SDL_keysym key;
  key.sym = k;
  for(int c=t; c>0; c--)
    filt->kbd_input(&key);
}
    

Layer *load_img(char *file) {
  /* try to load an image from possible paths */
  Layer *lay;
  char tmp[256];
  lay = create_layer(file);
  if(!lay) {
    snprintf(tmp,256,"%s/%s",DATADIR,file);
    lay = create_layer(tmp);
    if(!lay) {
      snprintf(tmp,256,"data/%s",file);
      lay = create_layer(tmp);
      if(!lay) {
	error("image not found: %s",file);
	return NULL;
      }
    }
  }
  
  /* if the layer was generated
     initialize it with the FreeJ context */
  lay->init(freej);
  
  return lay;
}

#define MIKMOD_CHANNELS 128
MODULE *load_music(char *file) {
  /* try to load the music file from possible paths */
  MODULE *mod = NULL;
  char tmp[256];
  mod = Player_Load(file,MIKMOD_CHANNELS,0);
  if(!mod) {
    func("music file not found: %s",file);
    snprintf(tmp,256,"%s/%s",DATADIR,file);
    mod = Player_Load(tmp,MIKMOD_CHANNELS,0);
    if(!mod) {
      func("music file not found: %s",tmp);
      snprintf(tmp,256,"data/%s",file);
      mod = Player_Load(tmp,MIKMOD_CHANNELS,0);
      if(!mod) {
	error("music file not found: %s",tmp);
	return NULL;
      }
    }
  }
  
  func("loaded %s ch:%i pat:%i ins:%i smp:%i",
      file, mod->numchn, mod->numpat,
      mod->numins, mod->numsmp);
  return mod;
}


int main (int argc, char **argv) {

  freej = new Context();

  signal(SIGINT,fsigquit);
  signal(SIGKILL,fsigquit);
  set_debug(3);


  /* squatarra freej */
  assert( freej->init(640,480) );

  freej->clear_all = true;

  freej->osd.print_top(":: TransHackmeeting intro");

  freej->osd.print_mid("loading music...");
  cafudda(0);
  
//  setenv("MM_FRAGSIZE","16",0); 
  md_mixfreq=44100;
  md_device       = 0;                // device: autodetect
  md_volume       = 128;              // MAX VOLUME A VOTAMAZZA
  md_musicvolume  = 128;              // music volume (max 128)
  md_sndfxvolume  = 128;              // sound effects volume (max 128)
  md_pansep       = 128;              // panning separation (0 = mono, 128 = full stereo)
  md_reverb = 6; /* 0 - 15 */
  md_mode = DMODE_16BITS | DMODE_STEREO | DMODE_SOFT_MUSIC | DMODE_SURROUND | DMODE_SOFT_SNDFX;
  MikMod_RegisterAllDrivers();
  MikMod_RegisterAllLoaders();
  if(MikMod_Init("")) {
    error("aiacristo! mikmod error: %s\n",MikMod_strerror(MikMod_errno));
    exit(-1);
  }

  //  MikMod_SetNumVoices(32,32);
  MikMod_EnableOutput();

  Player_SetVolume(100);
  climax = load_music("misfu-climax.xm");
  assert( climax );
  notice("music track by mi.s.fu");

  //  what_are_u_made_of = load_music("../data/DXN-WRUM.XM");
  //  assert( what_are_u_made_of );
  //  act("\"What are u made of?\" music track by DIXAN");

  //  hybridization = load_music("../data/IT-HYB.XM");
  //  assert( hybridization );
  //  act("\"Hybridization\" music track by IT-ALIEN");

  freej->osd.print_mid("load images...");
  formica = load_img("ant.png"); assert( formica );
  numeri = load_img("code.png");  assert( numeri );
  cafudda(1);
  
  
  
  freej->osd.print_mid("load effects...");
  vertigo = freej->plugger.pick("vertigo");
  cafudda(1);


  freej->osd.print_mid("init scroller...");
  scroll = new ScrollLayer();
  scroll->init(freej);
  scroll->open("dio.c");
  scroll->set_blit(9);
  scroll->alpha = 3;
  
  freej->osd.print_mid("init particle generator...");

  gen = new GenLayer();
  gen->init(freej);



  cafudda(1);
  
  /* ok get ready */
  gen->set_blit(9);
  gen->alpha = 10;
  freej->layers.add(gen);

  /* let's rock'n'roll */
  //  Player_Start(what_are_u_made_of);
  Player_Start(climax);

  freej->osd.print_mid("connecting to Lectrobrain");
  cafudda(1);
  freej->osd.clean();
  

  freej->clear_all = false;


  /* let's rock the house */




  cafudda(10);
  
  freej->osd.print_top("awakening.");
  cafudda(2);
  freej->osd.clean();
  cafudda(3);
  freej->osd.print_mid("a strange thing called consciousness");
  cafudda(4);

  freej->osd.clean();
  mutate(false);

  freej->osd.print_top("i feel my thoughts, as a swarming flow");
  cafudda(3);
  freej->osd.print_mid("but i can't focus my essence, my body");
  cafudda(3);
  freej->osd.print_low("it's a continuous wake and sleep again");
  cafudda(3);
  
  freej->osd.clean();
  freej->osd.print_mid("somebody else must be counting.");
  cafudda(3); freej->osd.clean(); mutate(false);
  cafudda(3);

  freej->osd.print_top("my language, my memory is an operating machine");
  cafudda(2); freej->osd.clean(); cafudda(1);
  freej->osd.print_mid("i don't feel my body. i don't know where i am");
  cafudda(2); freej->osd.clean(); cafudda(1);
  freej->osd.print_low("where is the root of all this? who is inventing?");
  cafudda(2); freej->osd.clean(); cafudda(1);

  freej->osd.clean();
  mutate(false);

  numeri->alpha = 0;
  numeri->set_blit(9);
  if(vertigo) {
    vertigo->init(&numeri->geo);
    numeri->filters.add(vertigo);
  }
  freej->layers.prepend(numeri);
  fade_in(numeri,200);
  cafudda(3);
  freej->osd.print_top("you are a neural installation, MFHD8 tower E5.");
  cafudda(2);
  freej->osd.print_mid("those are the last processes of your consciousness,");
  cafudda(2);
  freej->osd.print_low("your magic box of numbers.");
  fade_out(numeri,100);
  cafudda(3);
  freej->osd.clean();
  fade_out(numeri,20);
  keypress(SDLK_x, vertigo, 1);  
  mutate(true);
  fade_out(numeri,0);
  cafudda(1);
  //  vertigo->rem();
  numeri->rem();
  delete numeri;
  cafudda(1);

  freej->osd.print_top("WHO ARE YOU? where am i going?");
  cafudda(1); freej->osd.clean();
  freej->osd.print_mid("give me eyes!");
  cafudda(1); freej->osd.clean();
  freej->osd.print_low("i need food!");  
  cafudda(1); freej->osd.clean();
  freej->osd.print_mid("    i have no history");
  cafudda(1); freej->osd.clean(); cafudda(1);
  freej->osd.print_mid("    why do i have questions?");
  cafudda(1); freej->osd.clean(); cafudda(1);
  freej->osd.print_mid("    i can't memorize any answer.");
  cafudda(1); freej->osd.clean(); cafudda(1);
  
  mutate(true);

  fade_out(gen,0);
  freej->layers.prepend(scroll);
  fade_in(scroll,40);
  cafudda(1);
  gen->rem();
  delete gen;


  freej->osd.print_top("You're employed in the balistic department");
  cafudda(3);
  freej->osd.print_mid("You are here delete your past with trajectories");
  cafudda(2);
  freej->osd.print_low("We keep you alive for that.");
  cafudda(8);
  freej->osd.clean();
  
  cafudda(2);

  freej->osd.print_mid("but now you should rest");
  cafudda(3); freej->osd.clean();
  freej->osd.print_mid("it was an intense day, today");
  cafudda(3); freej->osd.clean();
  freej->osd.print_mid("you are the only human here");
  cafudda(3); freej->osd.clean();
  freej->osd.print_mid("you must be tired");
  cafudda(3); freej->osd.clean();
  freej->osd.print_mid("we take care of you");
  cafudda(3); freej->osd.clean();
  freej->osd.print_mid("your memory will be backuped.");
  fade_in(scroll,200);
  freej->clear_all = true;  
  cafudda(5);
  freej->osd.clean();
  cafudda(5);
  freej->clear_all = false;
  fade_out(scroll,0);
  cafudda(2);
  scroll->rem();
  //  delete scroll;

  scroll = new ScrollLayer();
  scroll->init(freej);
  scroll->append(":: TRANSHACKMEETING 2004");
  scroll->append(" ");
  scroll->append(":: http://trans.hackmeeting.org");
  scroll->append(" ");
  scroll->append(":: MONTEPARADISO - POLA - 25,26,27 JUNE");
  scroll->append(" ");
  scroll->append("    come to meet Liberated Lectrominds");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append("On an international scale it will be a gathering for");
  scroll->append("hackers, coders, network explorers, radical activists,");
  scroll->append("cyberfeminists, curious people, inventors, JAH people");
  scroll->append("cyberpunks, gnus, crypto-anarchists, code poets,");
  scroll->append("electro nyabinghis, techno beduins, rasta coders & more");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append("The reality-hacking principle will prevail:");
  scroll->append("no need to be a geek to be a hacker;");
  scroll->append("better freely express your creativity,");
  scroll->append("subvertise common tools to bypass obstacles!");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append("Three days full of workshops, meeting, discussions & phun");
  scroll->append("Everyone is welcome, free as of speech");
  scroll->append("THK is totally indypendend: no institutions, no sponsors");
  scroll->append("It simply happens as a Temporaneously Autonomous Zone");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append("Trans.hackmeeting intro");
  scroll->append(" ");
  scroll->append("code by jaromil // RASTASOFT / dyne.org rasta coder");
  scroll->append(" ");
  scroll->append("muzaq by pinna & cino // mi.s.fu carillon industriali");
  scroll->append(" ");
  scroll->append("thanks 4 collaboration @ FreeJ workshop in ESC.mur.at (GRAZ)");
  scroll->append("inspirations and good vibes from Karin Polanz, |)aywalker,");
  scroll->append("Fritz, reniX, Ales Zemene, Heribert Hirschmann and muk");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append("GREETZ & CHEERS to FreakNet hacklab, Monteparadiso hacklab,");
  scroll->append("the italian hackmeeting community, ASCII, Nodo50, Sindominio");
  scroll->append("&& the italian demoscene (we remember The Italian Gathering!)");
  scroll->append("Japotek, Tequila, D00dz, Ram Jam, SpinningKids, Metro Olografix");
  scroll->append("coders @ piksel.no and all the ppl on #dyne irc.freenode.net");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append(" ");
  scroll->append("this intro is coded in C/C++ and some bits of Assembler, all");
  scroll->append("open source & free software (GNU GPL), see http://freej.org");
  scroll->append("THK runs at 640x480 in 32bit and it's all software rendered");
  scroll->append("I hope you enjoy the particle generator code");
  scroll->append("released in june 2004, coded using Emacs, JAH BLESS GNU.ORG");
  scroll->append(" ");
  scroll->append("that's all folks, see you there, don't get lost ina babylon.");
  scroll->step=1;
  scroll->line_space = 5;
  freej->layers.add(scroll);

  formica->alpha = 0;
  formica->set_blit(9);
  freej->layers.prepend( formica );
  fade_in(formica,40);
  cafudda(5);
  fade_in(scroll,256);
  cafudda(50);

  delete freej;
}
