function load(name) {
  document.getElementById('code').contentDocument.body.innerHTML = lightProgram(name);
  document.getElementById('name').value = name;
  update();
}

function runAudio() {
  var name = document.getElementById('name').value;
  try {
    start(name + '/' + return_code(name)[1]);
  } catch(e) {}
}

function start(name) {
	try {
		loop.stop();
	} catch(e) {}
	loop.start(name);
}

function update() {
  var name = document.getElementById('name');
  var info = return_code(name.value);
  var dst_code = document.getElementById('dst_code');
  dst_code.value = info[0];
  document.getElementById('n').innerHTML = name.value.replace('-hidden', '');
  if(info[1]===undefined) {
	document.getElementById('a').innerHTML = '';
	document.getElementById('by').innerHTML = '';
  } else {
    document.getElementById('a').innerHTML = info[1];
    document.getElementById('by').innerHTML = ' by ';
  }
  return dst_code.value;
}

function init() {
  load('Forth Shader Collection-hidden');
  animate_haikus(function() {});
  createList();
}

function createList() {
  for(var i in apps()) {
      var name = (i.split('/')[0]).split(' ').join('_');
      var url = '../' + i.split('/')[1] + '-' + name + '.html';

      var a = document.createElement('a'); a.href = url; a.target = 'src_code';
      var img = document.createElement('img'); img.src = '../icons/' + name + '.png';

      if(!(i.indexOf('-hidden')+1)) {
        document.getElementById('list').innerHTML += '<a href="#" onclick="load(\'' + i.split('/')[0] + '\')"><img src="../icons/' + name + '.png" title="' + i.split('/')[0] + '"></a>';
      }
  }
} 